/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.openexi.proc.common.QName;
import org.openexi.proc.io.DateTimeValueScriberBase;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.Scriber;
import org.openexi.schema.EXISchema;
import org.openexi.schema.XSDateTime;

public final class DateTimeValueScriber
extends DateTimeValueScriberBase {
    public static final DateTimeValueScriber instance = new DateTimeValueScriber();

    private DateTimeValueScriber() {
        super(new QName("exi:dateTime", "http://www.w3.org/2009/exi"));
    }

    public short getCodecID() {
        return 4;
    }

    public int getBuiltinRCS(int n, Scriber scriber) {
        return -5;
    }

    public boolean process(String string, int n, EXISchema eXISchema, Scribble scribble, Scriber scriber) {
        if (!this.trimWhitespaces(string)) {
            return false;
        }
        BigInteger bigInteger = null;
        int n2 = Integer.MIN_VALUE;
        this.nextPosition = this.startPosition;
        if (!this.parseYearField(string, scribble) || this.nextPosition == this.limitPosition) {
            return false;
        }
        int n3 = scribble.intValue1;
        if (string.charAt(this.nextPosition++) != '-' || this.nextPosition == this.limitPosition) {
            return false;
        }
        if (!this.parseMonthField(string, scribble) || this.nextPosition == this.limitPosition) {
            return false;
        }
        int n4 = scribble.intValue1;
        if (string.charAt(this.nextPosition++) != '-' || this.nextPosition == this.limitPosition) {
            return false;
        }
        if (!this.parseDayField(string, n3, n4, scribble) || this.nextPosition == this.limitPosition) {
            return false;
        }
        int n5 = scribble.intValue1;
        if (string.charAt(this.nextPosition++) != 'T' || this.nextPosition == this.limitPosition) {
            return false;
        }
        if (!this.parseHourField(string, scribble) || this.nextPosition == this.limitPosition) {
            return false;
        }
        int n6 = scribble.intValue1;
        if (string.charAt(this.nextPosition++) != ':' || this.nextPosition == this.limitPosition) {
            return false;
        }
        if (!this.parseMinuteField(string, scribble) || this.nextPosition == this.limitPosition) {
            return false;
        }
        int n7 = scribble.intValue1;
        if (n6 == 24 && n7 != 0) {
            return false;
        }
        if (string.charAt(this.nextPosition++) != ':' || this.nextPosition == this.limitPosition) {
            return false;
        }
        if (!this.parseSecondField(string, scribble)) {
            return false;
        }
        int n8 = scribble.intValue1;
        if (n6 == 24 && n8 != 0) {
            return false;
        }
        if (this.nextPosition != this.limitPosition) {
            if (string.charAt(this.nextPosition) == '.') {
                if (++this.nextPosition == this.limitPosition) {
                    return false;
                }
                bigInteger = this.parseFractionalSecondField(string);
                if (bigInteger == null) {
                    return false;
                }
                if (bigInteger.signum() == 0) {
                    bigInteger = null;
                }
            }
            if (this.nextPosition != this.limitPosition) {
                if (!this.parseTimezoneField(string, scribble) || this.nextPosition != this.limitPosition) {
                    return false;
                }
                n2 = scribble.intValue1;
            }
        }
        scribble.dateTime = new XSDateTime(n3, n4, n5, n6, n7, n8, bigInteger, n2, 8);
        return true;
    }

    void scribeDateTimeValue(XSDateTime xSDateTime, OutputStream outputStream, Scriber scriber) throws IOException {
        this.writeYear(xSDateTime.year, outputStream, scriber);
        this.writeMonthDay(xSDateTime.month, xSDateTime.day, outputStream, scriber);
        this.writeTime(xSDateTime.hour, xSDateTime.minute, xSDateTime.second, xSDateTime.reverseFractionalSecond, outputStream, scriber);
        this.writeTimeZone(xSDateTime.timeZone, outputStream, scriber);
    }
}

