/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XMLResourceBundle
extends ResourceBundle {
    private final HashMap<String, String> m_msgs = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLResourceBundle() throws MissingResourceException {
        String string = this.getShortName() + ".xml";
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            InputStream inputStream = null;
            try {
                inputStream = uRL.openStream();
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(false);
                sAXParserFactory.setValidating(false);
                XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
                xMLReader.setContentHandler(new MessageContentHandler());
                xMLReader.parse(new InputSource(inputStream));
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                iOException.printStackTrace();
            }
            catch (SAXException sAXException) {
                System.err.println(sAXException.getMessage());
                sAXException.printStackTrace();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                System.err.println(parserConfigurationException.getMessage());
                parserConfigurationException.printStackTrace();
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                    iOException.printStackTrace();
                }
            }
        } else {
            throw new MissingResourceException("Resource file '" + string + "' could not be found.", string, null);
        }
    }

    protected String getShortName() {
        String string = this.getClass().getPackage().getName();
        String string2 = this.getClass().getName();
        return string2.substring(string.length() + 1, string2.length());
    }

    @Override
    public Enumeration<String> getKeys() {
        Set<String> set = this.m_msgs.keySet();
        final Iterator<String> iterator = set.iterator();
        return new Enumeration<String>(){

            @Override
            public String nextElement() {
                return (String)iterator.next();
            }

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }
        };
    }

    @Override
    protected Object handleGetObject(String string) throws MissingResourceException {
        return this.m_msgs.get(string);
    }

    private final class MessageContentHandler
    extends DefaultHandler {
        private String m_key;
        private int m_msg_level;
        private int m_level;
        private final StringBuffer m_buf = new StringBuffer();

        private MessageContentHandler() {
        }

        public void startDocument() throws SAXException {
            this.m_level = 0;
            this.m_msg_level = 0;
            this.m_key = null;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ++this.m_level;
            if (string3.equals("msg")) {
                this.m_key = attributes.getValue("id");
                if (this.m_key != null) {
                    this.m_key = this.m_key.trim();
                    this.m_msg_level = this.m_level;
                }
                this.m_buf.delete(0, this.m_buf.length());
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.m_msg_level > 0 && this.m_level >= this.m_msg_level) {
                this.m_buf.append(cArray, n, n2);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.m_level == this.m_msg_level) {
                if (this.m_key != null && this.m_key.length() > 0) {
                    XMLResourceBundle.this.m_msgs.put(this.m_key, this.m_buf.toString());
                }
                this.m_msg_level = 0;
            }
            --this.m_level;
        }
    }
}

