/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.DatatypeID;
import com.siemens.ct.exi.datatype.WhiteSpace;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;

public class StringDatatype
extends AbstractDatatype {
    private static final long serialVersionUID = 4636133910606239257L;
    protected final boolean isDerivedByUnion;
    protected String lastValue;

    public StringDatatype(QNameContext schemaType) {
        this(schemaType, WhiteSpace.preserve);
    }

    public StringDatatype(QNameContext schemaType, WhiteSpace whiteSpace) {
        this(schemaType, false);
        this.whiteSpace = whiteSpace;
    }

    public DatatypeID getDatatypeID() {
        return DatatypeID.exi_string;
    }

    public StringDatatype(QNameContext schemaType, boolean isDerivedByUnion) {
        super(BuiltInType.STRING, schemaType);
        this.isDerivedByUnion = isDerivedByUnion;
    }

    public boolean isDerivedByUnion() {
        return this.isDerivedByUnion;
    }

    public boolean isValid(Value value) {
        this.lastValue = value.toString();
        return true;
    }

    public void writeValue(QNameContext qnContext, EncoderChannel valueChannel, StringEncoder stringEncoder) throws IOException {
        stringEncoder.writeValue(qnContext, valueChannel, this.lastValue);
    }

    public Value readValue(QNameContext qnContext, DecoderChannel valueChannel, StringDecoder stringDecoder) throws IOException {
        return stringDecoder.readValue(qnContext, valueChannel);
    }
}

