/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.openexi.proc.io.Scriber;

public final class ByteAlignedCommons {
    private ByteAlignedCommons() {
    }

    public static final boolean readBoolean(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        switch (n) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        assert (n == -1);
        throw new EOFException();
    }

    public static int readNBitUnsigned(int n, InputStream inputStream) throws IOException {
        assert (n != 0);
        int n2 = (n & 7) != 0 ? (n & 0xFFFFFFF8) + 8 : n & 0xFFFFFFF8;
        int n3 = 0;
        int n4 = 0;
        do {
            int n5;
            if ((n5 = inputStream.read()) == -1) {
                throw new EOFException();
            }
            n3 |= n5 << n4;
        } while ((n4 += 8) != n2);
        return n3;
    }

    public static int readEightBitsUnsigned(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    public static void writeNBitUnsigned(int n, int n2, OutputStream outputStream) throws IOException {
        int n3 = n2 >>> 3;
        int n4 = (n2 & 7) != 0 ? n3 + 1 : n3;
        for (int i = 0; i < n4; ++i) {
            outputStream.write(n >>> (i << 3) & 0xFF);
        }
    }

    public static void writeUnsignedInteger32(int n, OutputStream outputStream) throws IOException {
        boolean bl = true;
        do {
            int n2 = n & 0x7F;
            if ((n >>>= 7) != 0) {
                n2 |= 0x80;
            } else {
                bl = false;
            }
            outputStream.write(n2);
        } while (bl);
    }

    public static void writeUnsignedInteger64(long l, OutputStream outputStream) throws IOException {
        boolean bl = true;
        do {
            int n = (int)l & 0x7F;
            if ((l >>>= 7) != 0L) {
                n |= 0x80;
            } else {
                bl = false;
            }
            outputStream.write(n);
        } while (bl);
    }

    public static void writeUnsignedInteger(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        boolean bl = true;
        do {
            int n = bigInteger.and(Scriber.BIGINTEGER_0x007F).intValue();
            if (!(bigInteger = bigInteger.shiftRight(7)).equals(BigInteger.ZERO)) {
                n |= 0x80;
            } else {
                bl = false;
            }
            outputStream.write(n);
        } while (bl);
    }
}

