/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

public final class PrefixUriBindings {
    private final String[] prefixes;
    private final String[] uris;
    private final String defaultUri;

    public PrefixUriBindings() {
        this(new String[0], new String[0], "");
    }

    private PrefixUriBindings(String[] stringArray, String[] stringArray2, String string) {
        this.prefixes = stringArray;
        this.uris = stringArray2;
        this.defaultUri = string;
    }

    public final int getSize() {
        return this.prefixes.length;
    }

    public final String getPrefix(int n) {
        return this.prefixes[n];
    }

    public final String getUri(int n) {
        return this.uris[n];
    }

    public final String getPrefix(String string) {
        int n = this.uris.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.uris[i])) continue;
            return this.prefixes[i];
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
            return "xml";
        }
        return null;
    }

    public final String getUri(String string) {
        int n = this.prefixes.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.prefixes[i])) continue;
            return this.uris[i];
        }
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return null;
    }

    public final String getDefaultUri() {
        return this.defaultUri;
    }

    public PrefixUriBindings unbind(String string) {
        int n = this.prefixes.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.prefixes[i])) continue;
            String[] stringArray = new String[n - 1];
            System.arraycopy(this.prefixes, 0, stringArray, 0, i);
            System.arraycopy(this.prefixes, i + 1, stringArray, i, n - i - 1);
            String[] stringArray2 = new String[n - 1];
            System.arraycopy(this.uris, 0, stringArray2, 0, i);
            System.arraycopy(this.uris, i + 1, stringArray2, i, n - i - 1);
            return new PrefixUriBindings(stringArray, stringArray2, this.defaultUri);
        }
        return this;
    }

    public PrefixUriBindings bind(String string, String string2) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.prefixes.length && (n = string.compareTo(this.prefixes[n2])) >= 0; ++n2) {
            if (n != 0) continue;
            if (string2.equals(this.uris[n2])) {
                return this;
            }
            String[] stringArray = (String[])this.uris.clone();
            stringArray[n2] = string2;
            return new PrefixUriBindings(this.prefixes, stringArray, this.defaultUri);
        }
        String[] stringArray = new String[this.prefixes.length + 1];
        System.arraycopy(this.prefixes, 0, stringArray, 0, n2);
        String[] stringArray2 = new String[this.uris.length + 1];
        System.arraycopy(this.uris, 0, stringArray2, 0, n2);
        stringArray[n2] = string;
        stringArray2[n2] = string2;
        System.arraycopy(this.prefixes, n2, stringArray, n2 + 1, this.prefixes.length - n2);
        System.arraycopy(this.uris, n2, stringArray2, n2 + 1, this.uris.length - n2);
        return new PrefixUriBindings(stringArray, stringArray2, this.defaultUri);
    }

    public PrefixUriBindings bindDefault(String string) {
        if (string.equals(this.defaultUri)) {
            return this;
        }
        return new PrefixUriBindings(this.prefixes, this.uris, string);
    }

    public PrefixUriBindings unbindDefault() {
        if (this.defaultUri == "") {
            return this;
        }
        return new PrefixUriBindings(this.prefixes, this.uris, "");
    }
}

