/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.openexi.proc.io.ByteAlignedCommons;
import org.openexi.proc.io.DateTimeValueScriber;
import org.openexi.proc.io.DateTimeValueScriberBase;
import org.openexi.proc.io.DateValueScriber;
import org.openexi.proc.io.DecimalValueScriber;
import org.openexi.proc.io.FloatValueScriber;
import org.openexi.proc.io.GDayValueScriber;
import org.openexi.proc.io.GMonthDayValueScriber;
import org.openexi.proc.io.GMonthValueScriber;
import org.openexi.proc.io.GYearMonthValueScriber;
import org.openexi.proc.io.GYearValueScriber;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.Scriber;
import org.openexi.proc.io.TimeValueScriber;
import org.openexi.proc.io.ValueScriberBase;
import org.openexi.schema.Base64;
import org.openexi.schema.EXISchema;
import org.openexi.schema.XSDateTime;

final class EnumerationValueScriber
extends ValueScriberBase {
    private final DatatypeFactory m_datatypeFactory;
    private static final FloatValueScriber m_floatValueScriber = FloatValueScriber.instance;
    private static final DateTimeValueScriber m_dateTimeValueScriber = DateTimeValueScriber.instance;
    private static final DateValueScriber m_dateValueScriber = DateValueScriber.instance;
    private static final TimeValueScriber m_timeValueScriber = TimeValueScriber.instance;
    private static final GYearMonthValueScriber m_gYearMonthValueScriber = GYearMonthValueScriber.instance;
    private static final GMonthDayValueScriber m_gMonthDayValueScriber = GMonthDayValueScriber.instance;
    private static final GYearValueScriber m_gYearValueScriber = GYearValueScriber.instance;
    private static final GMonthValueScriber m_gMonthValueScriber = GMonthValueScriber.instance;
    private static final GDayValueScriber m_gDayValueScriber = GDayValueScriber.instance;
    private static final DecimalValueScriber m_decimalValueScriber = DecimalValueScriber.instance;

    public EnumerationValueScriber(DatatypeFactory datatypeFactory) {
        super(null);
        this.m_datatypeFactory = datatypeFactory;
    }

    public short getCodecID() {
        return 17;
    }

    public int getBuiltinRCS(int n, Scriber scriber) {
        assert (1 == scriber.schema.getVarietyOfSimpleType(n));
        int n2 = scriber.schema.getBaseTypeOfSimpleType(n);
        return scriber.getValueScriber(n2).getBuiltinRCS(n2, scriber);
    }

    public final boolean process(String string, int n, EXISchema eXISchema, Scribble scribble, Scriber scriber) {
        int n2;
        assert (eXISchema.getVarietyOfSimpleType(n) == 1);
        int n3 = eXISchema.getEnumerationFacetCountOfAtomicSimpleType(n);
        assert (n3 > 0);
        byte by = eXISchema.ancestryIds[eXISchema.getSerialOfType(n)];
        int n4 = by == 2 ? eXISchema.getWhitespaceFacetValueOfStringSimpleType(n) : 2;
        String string2 = n4 == 0 ? string : EnumerationValueScriber.normalize(string, n4);
        Object object = this.parseTextValue(string2, n, by, eXISchema, scribble, scriber);
        if (object != null && (n2 = this.getEnumerationIndex(string2, object, n, n3, eXISchema)) >= 0) {
            scribble.intValue1 = n2;
            return true;
        }
        return false;
    }

    public void scribe(String string, Scribble scribble, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        this.scribeEnumeration(scribble.intValue1, n3, outputStream, scriber);
    }

    private void scribeEnumeration(int n, int n2, OutputStream outputStream, Scriber scriber) throws IOException {
        int n3 = scriber.schema.getEnumerationFacetCountOfAtomicSimpleType(n2) - 1;
        int n4 = 0;
        while (n3 != 0) {
            n3 >>= 1;
            ++n4;
        }
        scriber.writeNBitUnsigned(n, n4, outputStream);
    }

    public Object toValue(String string, Scribble scribble, Scriber scriber) {
        return new EnumValue(scribble.intValue1);
    }

    public void doScribe(Object object, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        int n4 = scriber.schema.getEnumerationFacetCountOfAtomicSimpleType(n3) - 1;
        int n5 = 0;
        while (n4 != 0) {
            n4 >>= 1;
            ++n5;
        }
        ByteAlignedCommons.writeNBitUnsigned(((EnumValue)object).index, n5, outputStream);
    }

    private final int getEnumerationIndex(String string, Object object, int n, int n2, EXISchema eXISchema) {
        byte by = eXISchema.getVarietyOfSimpleType(n);
        assert (by != 3 && by != 2);
        for (int i = 0; i < n2; ++i) {
            int n3 = eXISchema.getEnumerationFacetOfAtomicSimpleType(n, i);
            assert (n3 != -1);
            if (!this.equalToVariant(object, n, eXISchema.ancestryIds[eXISchema.getSerialOfType(n)], n3, eXISchema)) continue;
            return i;
        }
        return -1;
    }

    private final boolean equalToVariant(Object object, int n, int n2, int n3, EXISchema eXISchema) {
        switch (n2) {
            case 2: 
            case 18: {
                String string = eXISchema.getStringValueOfVariant(n3);
                if (!((String)object).equals(string)) break;
                return true;
            }
            case 4: {
                Scribble scribble = (Scribble)object;
                if (DecimalValueScriber.getSign(scribble) != eXISchema.getSignOfDecimalVariant(n3) || !DecimalValueScriber.getIntegralDigits(scribble).equals(eXISchema.getIntegralDigitsOfDecimalVariant(n3)) || !DecimalValueScriber.getReverseFractionalDigits(scribble).equals(eXISchema.getReverseFractionalDigitsOfDecimalVariant(n3))) break;
                return true;
            }
            case 21: {
                BigInteger bigInteger;
                switch (eXISchema.getTypeOfVariant(n3)) {
                    case 4: {
                        int n4 = eXISchema.getIntValueOfVariant(n3);
                        bigInteger = BigInteger.valueOf(n4);
                        break;
                    }
                    case 5: {
                        long l = eXISchema.getLongValueOfVariant(n3);
                        bigInteger = BigInteger.valueOf(l);
                        break;
                    }
                    case 3: {
                        bigInteger = eXISchema.getIntegerValueOfVariant(n3);
                        break;
                    }
                    default: {
                        assert (false);
                        return false;
                    }
                }
                if (!((BigInteger)object).equals(bigInteger)) break;
                return true;
            }
            case 5: 
            case 6: {
                Scribble scribble = (Scribble)object;
                if (FloatValueScriber.getMantissa(scribble) != eXISchema.getMantissaOfFloatVariant(n3) || FloatValueScriber.getExponent(scribble) != eXISchema.getExponentOfFloatVariant(n3)) break;
                return true;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                XSDateTime xSDateTime = eXISchema.getComputedDateTimeValueOfVariant(n3);
                return ((XSDateTime)object).equals(xSDateTime);
            }
            case 7: {
                Duration duration = eXISchema.getDurationValueOfVariant(n3);
                if (!((Duration)object).equals(duration)) break;
                return true;
            }
            case 16: 
            case 17: {
                int n5;
                byte[] byArray = eXISchema.getBinaryValueOfVariant(n3);
                byte[] byArray2 = (byte[])object;
                if (byArray2.length != byArray.length) break;
                for (n5 = 0; n5 < byArray2.length && byArray2[n5] == byArray[n5]; ++n5) {
                }
                if (n5 != byArray2.length) break;
                return true;
            }
            case 3: {
                assert (false);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return false;
    }

    private static final String normalize(String string, int n) {
        int n2;
        assert (n != 0);
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && !Character.isWhitespace(string.charAt(n2)); ++n2) {
        }
        if (n2 == n3) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n3);
        if (n == 2) {
            boolean bl = true;
            boolean bl2 = false;
            block7: for (n2 = 0; n2 < n3; ++n2) {
                char c = string.charAt(n2);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (bl) continue block7;
                        bl2 = true;
                        continue block7;
                    }
                    default: {
                        if (bl) {
                            assert (!bl2);
                            bl = false;
                        } else if (bl2) {
                            stringBuilder.append(' ');
                            bl2 = false;
                        }
                        stringBuilder.append(c);
                    }
                }
            }
        } else {
            assert (n == 1);
            block8: for (n2 = 0; n2 < n3; ++n2) {
                char c = string.charAt(n2);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        stringBuilder.append(' ');
                        continue block8;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
            }
        }
        return stringBuilder.toString();
    }

    private Object parseTextValue(String string, int n, byte by, EXISchema eXISchema, Scribble scribble, Scriber scriber) {
        assert (eXISchema.getVarietyOfSimpleType(n) == 1);
        switch (by) {
            case 2: 
            case 18: {
                return string;
            }
            case 4: {
                if (m_decimalValueScriber.doProcess(string, scribble, scriber.stringBuilder1, scriber.stringBuilder2)) {
                    DecimalValueScriber.canonicalizeValue(scribble);
                    return scribble;
                }
                return null;
            }
            case 21: {
                BigInteger bigInteger;
                if (string.length() != 0 && string.charAt(0) == '+') {
                    string = string.substring(1);
                }
                try {
                    bigInteger = new BigInteger(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                return bigInteger;
            }
            case 5: 
            case 6: {
                if (m_floatValueScriber.doProcess(string, scribble, scriber.stringBuilder1)) {
                    FloatValueScriber.canonicalizeValue(scribble);
                    return scribble;
                }
                return null;
            }
            case 3: {
                return this.parseBoolean(string, n);
            }
            case 8: {
                if (m_dateTimeValueScriber.process(string, -1, null, scribble, null)) {
                    DateTimeValueScriberBase.canonicalizeValue(scribble);
                    return scribble.dateTime;
                }
                return null;
            }
            case 10: {
                if (m_dateValueScriber.process(string, -1, null, scribble, null)) {
                    DateTimeValueScriberBase.canonicalizeValue(scribble);
                    return scribble.dateTime;
                }
                return null;
            }
            case 9: {
                if (m_timeValueScriber.process(string, -1, null, scribble, null)) {
                    DateTimeValueScriberBase.canonicalizeValue(scribble);
                    return scribble.dateTime;
                }
                return null;
            }
            case 11: {
                if (m_gYearMonthValueScriber.process(string, -1, null, scribble, null)) {
                    DateTimeValueScriberBase.canonicalizeValue(scribble);
                    return scribble.dateTime;
                }
                return null;
            }
            case 13: {
                if (m_gMonthDayValueScriber.process(string, -1, null, scribble, null)) {
                    DateTimeValueScriberBase.canonicalizeValue(scribble);
                    return scribble.dateTime;
                }
                return null;
            }
            case 12: {
                if (m_gYearValueScriber.process(string, -1, null, scribble, null)) {
                    DateTimeValueScriberBase.canonicalizeValue(scribble);
                    return scribble.dateTime;
                }
                return null;
            }
            case 15: {
                if (m_gMonthValueScriber.process(string, -1, null, scribble, null)) {
                    DateTimeValueScriberBase.canonicalizeValue(scribble);
                    return scribble.dateTime;
                }
                return null;
            }
            case 14: {
                if (m_gDayValueScriber.process(string, -1, null, scribble, null)) {
                    DateTimeValueScriberBase.canonicalizeValue(scribble);
                    return scribble.dateTime;
                }
                return null;
            }
            case 7: {
                return this.parseDuration(string);
            }
            case 17: {
                return Base64.decode(string);
            }
            case 16: {
                return HexBin.decode(string);
            }
        }
        assert (false);
        return null;
    }

    private Duration parseDuration(String string) {
        Duration duration = null;
        if (string.length() != 0) {
            try {
                duration = this.m_datatypeFactory.newDuration(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return duration;
    }

    private Boolean parseBoolean(String string, int n) {
        boolean bl;
        switch (string.length()) {
            case 1: {
                char c = string.charAt(0);
                if (c == '1') {
                    bl = true;
                    break;
                }
                if (c == '0') {
                    bl = false;
                    break;
                }
                return null;
            }
            case 4: {
                char c = string.charAt(0);
                if (c == 't' && "true".equals(string)) {
                    bl = true;
                    break;
                }
                return null;
            }
            case 5: {
                char c = string.charAt(0);
                if (c == 'f' && "false".equals(string)) {
                    bl = false;
                    break;
                }
                return null;
            }
            default: {
                return null;
            }
        }
        return bl;
    }

    private static class HexBin {
        private HexBin() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static byte[] decode(String string) {
            byte[] byArray = null;
            if (string != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    int n = 0;
                    int n2 = string.length();
                    int n3 = 0;
                    while (n < n2) {
                        int n4 = 0;
                        while (n4 < 2 && n < n2) {
                            char c = string.charAt(n);
                            if (!Character.isWhitespace(c)) {
                                if ('`' < c) {
                                    if ('f' < c) {
                                        byte[] byArray2 = null;
                                        return byArray2;
                                    }
                                    n3 |= 10 + (c - 97) << 4 * (1 - n4++);
                                } else if (c < ':') {
                                    if (c < '0') {
                                        byte[] byArray3 = null;
                                        return byArray3;
                                    }
                                    n3 |= c - 48 << 4 * (1 - n4++);
                                } else if ('@' < c && c < 'G') {
                                    n3 |= 10 + (c - 65) << 4 * (1 - n4++);
                                } else {
                                    byte[] byArray4 = null;
                                    return byArray4;
                                }
                            }
                            ++n;
                        }
                        if (n4 < 2) {
                            byte[] byArray5 = null;
                            return byArray5;
                        }
                        byteArrayOutputStream.write(n3);
                        n3 = 0;
                    }
                }
                finally {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    private class EnumValue {
        int index;

        EnumValue(int n) {
            this.index = n;
        }
    }
}

