/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi;

import com.siemens.ct.exi.exceptions.UnsupportedOption;
import com.siemens.ct.exi.grammars.event.EventType;
import com.siemens.ct.exi.grammars.grammar.Grammar;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedFirstStartTagGrammar;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedGrammar;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedStartTagGrammar;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class FidelityOptions
implements Serializable {
    private static final long serialVersionUID = 2403291078846997571L;
    public static final String FEATURE_COMMENT = "PRESERVE_COMMENTS";
    public static final String FEATURE_PI = "PRESERVE_PIS";
    public static final String FEATURE_DTD = "PRESERVE_DTDS";
    public static final String FEATURE_PREFIX = "PRESERVE_PREFIXES";
    public static final String FEATURE_LEXICAL_VALUE = "PRESERVE_LEXICAL_VALUES";
    public static final String FEATURE_SC = "SELF_CONTAINED";
    public static final String FEATURE_STRICT = "STRICT";
    protected Set<String> options = new HashSet<String>();
    protected boolean isStrict = false;
    protected boolean isComment = false;
    protected boolean isPI = false;
    protected boolean isDTD = false;
    protected boolean isPrefix = false;
    protected boolean isLexicalValue = false;
    protected boolean isSC = false;

    protected FidelityOptions() {
    }

    public static FidelityOptions createDefault() {
        FidelityOptions fo = new FidelityOptions();
        return fo;
    }

    public static FidelityOptions createStrict() {
        FidelityOptions fo = new FidelityOptions();
        fo.options.add(FEATURE_STRICT);
        fo.isStrict = true;
        return fo;
    }

    public static FidelityOptions createAll() {
        FidelityOptions fo = new FidelityOptions();
        fo.options.add(FEATURE_COMMENT);
        fo.isComment = true;
        fo.options.add(FEATURE_PI);
        fo.isPI = true;
        fo.options.add(FEATURE_DTD);
        fo.isDTD = true;
        fo.options.add(FEATURE_PREFIX);
        fo.isPrefix = true;
        fo.options.add(FEATURE_LEXICAL_VALUE);
        fo.isLexicalValue = true;
        return fo;
    }

    public void setFidelity(String key, boolean decision) throws UnsupportedOption {
        if (key.equals(FEATURE_STRICT)) {
            if (decision) {
                boolean prevContainedLexVal = this.options.contains(FEATURE_LEXICAL_VALUE);
                this.options.clear();
                this.isComment = false;
                this.isPI = false;
                this.isDTD = false;
                this.isPrefix = false;
                this.isLexicalValue = false;
                this.isSC = false;
                if (prevContainedLexVal) {
                    this.options.add(FEATURE_LEXICAL_VALUE);
                    this.isLexicalValue = true;
                }
                this.options.add(FEATURE_STRICT);
                this.isStrict = true;
            } else {
                this.options.remove(key);
                this.isStrict = false;
            }
        } else if (key.equals(FEATURE_LEXICAL_VALUE)) {
            if (decision) {
                this.options.add(key);
                this.isLexicalValue = true;
            } else {
                this.options.remove(key);
                this.isLexicalValue = false;
            }
        } else if (key.equals(FEATURE_COMMENT) || key.equals(FEATURE_PI) || key.equals(FEATURE_DTD) || key.equals(FEATURE_PREFIX) || key.equals(FEATURE_SC)) {
            if (decision) {
                if (this.isStrict()) {
                    this.options.remove(FEATURE_STRICT);
                    this.isStrict = false;
                }
                this.options.add(key);
                if (key.equals(FEATURE_COMMENT)) {
                    this.isComment = true;
                }
                if (key.equals(FEATURE_PI)) {
                    this.isPI = true;
                }
                if (key.equals(FEATURE_DTD)) {
                    this.isDTD = true;
                }
                if (key.equals(FEATURE_PREFIX)) {
                    this.isPrefix = true;
                }
                if (key.equals(FEATURE_SC)) {
                    this.isSC = true;
                }
            } else {
                this.options.remove(key);
                if (key.equals(FEATURE_COMMENT)) {
                    this.isComment = false;
                }
                if (key.equals(FEATURE_PI)) {
                    this.isPI = false;
                }
                if (key.equals(FEATURE_DTD)) {
                    this.isDTD = false;
                }
                if (key.equals(FEATURE_PREFIX)) {
                    this.isPrefix = false;
                }
                if (key.equals(FEATURE_SC)) {
                    this.isSC = false;
                }
            }
        } else {
            throw new UnsupportedOption("FidelityOption '" + key + "' is unknown!");
        }
    }

    public boolean isFidelityEnabled(String key) {
        return this.options.contains(key);
    }

    public final boolean isStrict() {
        return this.isStrict;
    }

    public boolean equals(Object o) {
        if (o instanceof FidelityOptions) {
            FidelityOptions other = (FidelityOptions)o;
            return this.options.equals(other.options);
        }
        return false;
    }

    public int hashCode() {
        return this.options.hashCode();
    }

    public String toString() {
        return this.options.toString();
    }

    public int get1stLevelEventCodeLength(Grammar grammar) {
        int cl1;
        switch (grammar.getGrammarType()) {
            case DOCUMENT: 
            case FRAGMENT: {
                cl1 = 0;
                break;
            }
            case DOC_END: {
                if (this.isComment || this.isPI) {
                    cl1 = 1;
                    break;
                }
                cl1 = 0;
                break;
            }
            case SCHEMA_INFORMED_DOC_CONTENT: 
            case BUILT_IN_DOC_CONTENT: {
                cl1 = grammar.get1stLevelEventCodeLength(this.isDTD || this.isComment || this.isPI);
                break;
            }
            case SCHEMA_INFORMED_FRAGMENT_CONTENT: 
            case BUILT_IN_FRAGMENT_CONTENT: {
                cl1 = grammar.get1stLevelEventCodeLength(this.isComment || this.isPI);
                break;
            }
            case SCHEMA_INFORMED_FIRST_START_TAG_CONTENT: 
            case SCHEMA_INFORMED_START_TAG_CONTENT: 
            case SCHEMA_INFORMED_ELEMENT_CONTENT: {
                cl1 = grammar.get1stLevelEventCodeLength(this.get2ndLevelCharacteristics(grammar) > 0);
                break;
            }
            case BUILT_IN_START_TAG_CONTENT: 
            case BUILT_IN_ELEMENT_CONTENT: {
                cl1 = grammar.get1stLevelEventCodeLength(false);
                break;
            }
            default: {
                cl1 = -1;
            }
        }
        return cl1;
    }

    public EventType get2ndLevelEventType(int ec2, Grammar grammar) {
        EventType eventType = null;
        switch (grammar.getGrammarType()) {
            case DOCUMENT: 
            case FRAGMENT: 
            case DOC_END: 
            case SCHEMA_INFORMED_FRAGMENT_CONTENT: 
            case BUILT_IN_FRAGMENT_CONTENT: {
                break;
            }
            case SCHEMA_INFORMED_DOC_CONTENT: 
            case BUILT_IN_DOC_CONTENT: {
                if (!this.isDTD || ec2 != 0) break;
                eventType = EventType.DOC_TYPE;
                break;
            }
            case SCHEMA_INFORMED_FIRST_START_TAG_CONTENT: {
                SchemaInformedFirstStartTagGrammar sifst = (SchemaInformedFirstStartTagGrammar)grammar;
                if (this.isStrict) {
                    if (sifst.isTypeCastable()) {
                        if (ec2 == 0) {
                            eventType = EventType.ATTRIBUTE_XSI_TYPE;
                            break;
                        }
                        if (ec2 != 1) break;
                        eventType = EventType.ATTRIBUTE_XSI_NIL;
                        break;
                    }
                    if (!sifst.isNillable() || ec2 != 0) break;
                    eventType = EventType.ATTRIBUTE_XSI_NIL;
                    break;
                }
                int dec = 0;
                if (sifst.hasEndElement()) {
                    ++dec;
                }
                if (ec2 == 0 - dec) {
                    eventType = EventType.END_ELEMENT_UNDECLARED;
                    break;
                }
                if (ec2 == 1 - dec) {
                    eventType = EventType.ATTRIBUTE_XSI_TYPE;
                    break;
                }
                if (ec2 == 2 - dec) {
                    eventType = EventType.ATTRIBUTE_XSI_NIL;
                    break;
                }
                if (ec2 == 3 - dec) {
                    eventType = EventType.ATTRIBUTE_GENERIC_UNDECLARED;
                    break;
                }
                if (ec2 == 4 - dec) {
                    eventType = EventType.ATTRIBUTE_INVALID_VALUE;
                    break;
                }
                if (!this.isPrefix) {
                    ++dec;
                }
                if (ec2 == 5 - dec) {
                    eventType = EventType.NAMESPACE_DECLARATION;
                    break;
                }
                if (!this.isSC) {
                    ++dec;
                }
                if (ec2 == 6 - dec) {
                    eventType = EventType.SELF_CONTAINED;
                    break;
                }
                if (ec2 == 7 - dec) {
                    eventType = EventType.START_ELEMENT_GENERIC_UNDECLARED;
                    break;
                }
                if (ec2 == 8 - dec) {
                    eventType = EventType.CHARACTERS_GENERIC_UNDECLARED;
                    break;
                }
                if (!this.isDTD) {
                    ++dec;
                }
                if (ec2 != 9 - dec) break;
                eventType = EventType.ENTITY_REFERENCE;
                break;
            }
            case SCHEMA_INFORMED_START_TAG_CONTENT: {
                SchemaInformedStartTagGrammar sist = (SchemaInformedStartTagGrammar)grammar;
                if (this.isStrict) break;
                int dec = 0;
                if (sist.hasEndElement()) {
                    ++dec;
                }
                if (ec2 == 0 - dec) {
                    eventType = EventType.END_ELEMENT_UNDECLARED;
                    break;
                }
                if (ec2 == 1 - dec) {
                    eventType = EventType.ATTRIBUTE_GENERIC_UNDECLARED;
                    break;
                }
                if (ec2 == 2 - dec) {
                    eventType = EventType.ATTRIBUTE_INVALID_VALUE;
                    break;
                }
                if (ec2 == 3 - dec) {
                    eventType = EventType.START_ELEMENT_GENERIC_UNDECLARED;
                    break;
                }
                if (ec2 == 4 - dec) {
                    eventType = EventType.CHARACTERS_GENERIC_UNDECLARED;
                    break;
                }
                if (!this.isDTD) {
                    ++dec;
                }
                if (ec2 != 5 - dec) break;
                eventType = EventType.ENTITY_REFERENCE;
                break;
            }
            case SCHEMA_INFORMED_ELEMENT_CONTENT: {
                SchemaInformedGrammar sig = (SchemaInformedGrammar)grammar;
                if (this.isStrict) break;
                int dec = 0;
                if (sig.hasEndElement()) {
                    ++dec;
                }
                if (ec2 == 0 - dec) {
                    eventType = EventType.END_ELEMENT_UNDECLARED;
                    break;
                }
                if (ec2 == 1 - dec) {
                    eventType = EventType.START_ELEMENT_GENERIC_UNDECLARED;
                    break;
                }
                if (ec2 == 2 - dec) {
                    eventType = EventType.CHARACTERS_GENERIC_UNDECLARED;
                    break;
                }
                if (!this.isDTD) {
                    ++dec;
                }
                if (ec2 != 3 - dec) break;
                eventType = EventType.ENTITY_REFERENCE;
                break;
            }
            case BUILT_IN_START_TAG_CONTENT: {
                if (ec2 == 0) {
                    eventType = EventType.END_ELEMENT_UNDECLARED;
                    break;
                }
                if (ec2 == 1) {
                    eventType = EventType.ATTRIBUTE_GENERIC_UNDECLARED;
                    break;
                }
                int dec = 0;
                if (!this.isPrefix) {
                    ++dec;
                }
                if (ec2 == 2 - dec) {
                    eventType = EventType.NAMESPACE_DECLARATION;
                    break;
                }
                if (!this.isSC) {
                    ++dec;
                }
                if (ec2 == 3 - dec) {
                    eventType = EventType.SELF_CONTAINED;
                    break;
                }
                if (ec2 == 4 - dec) {
                    eventType = EventType.START_ELEMENT_GENERIC_UNDECLARED;
                    break;
                }
                if (ec2 == 5 - dec) {
                    eventType = EventType.CHARACTERS_GENERIC_UNDECLARED;
                    break;
                }
                if (!this.isDTD) {
                    ++dec;
                }
                if (ec2 != 6 - dec) break;
                eventType = EventType.ENTITY_REFERENCE;
                break;
            }
            case BUILT_IN_ELEMENT_CONTENT: {
                if (ec2 == 0) {
                    eventType = EventType.START_ELEMENT_GENERIC_UNDECLARED;
                    break;
                }
                if (ec2 == 1) {
                    eventType = EventType.CHARACTERS_GENERIC_UNDECLARED;
                    break;
                }
                if (!this.isDTD || ec2 != 2) break;
                eventType = EventType.ENTITY_REFERENCE;
            }
        }
        return eventType;
    }

    public int get2ndLevelEventCode(EventType eventType, Grammar grammar) {
        int ec2 = -1;
        switch (grammar.getGrammarType()) {
            case DOCUMENT: 
            case FRAGMENT: 
            case DOC_END: 
            case SCHEMA_INFORMED_FRAGMENT_CONTENT: 
            case BUILT_IN_FRAGMENT_CONTENT: {
                break;
            }
            case SCHEMA_INFORMED_DOC_CONTENT: 
            case BUILT_IN_DOC_CONTENT: {
                if (!this.isDTD || eventType != EventType.DOC_TYPE) break;
                ec2 = 0;
                break;
            }
            case SCHEMA_INFORMED_FIRST_START_TAG_CONTENT: {
                SchemaInformedFirstStartTagGrammar sifst = (SchemaInformedFirstStartTagGrammar)grammar;
                if (this.isStrict) {
                    if (sifst.isTypeCastable()) {
                        if (eventType == EventType.ATTRIBUTE_XSI_TYPE) {
                            ec2 = 0;
                            break;
                        }
                        if (eventType != EventType.ATTRIBUTE_XSI_NIL) break;
                        ec2 = 1;
                        break;
                    }
                    if (!sifst.isNillable() || eventType != EventType.ATTRIBUTE_XSI_NIL) break;
                    ec2 = 0;
                    break;
                }
                int dec = 0;
                if (sifst.hasEndElement()) {
                    ++dec;
                }
                if (eventType == EventType.END_ELEMENT_UNDECLARED) {
                    ec2 = 0 - dec;
                    break;
                }
                if (eventType == EventType.ATTRIBUTE_XSI_TYPE) {
                    ec2 = 1 - dec;
                    break;
                }
                if (eventType == EventType.ATTRIBUTE_XSI_NIL) {
                    ec2 = 2 - dec;
                    break;
                }
                if (eventType == EventType.ATTRIBUTE_GENERIC_UNDECLARED) {
                    ec2 = 3 - dec;
                    break;
                }
                if (eventType == EventType.ATTRIBUTE_INVALID_VALUE) {
                    ec2 = 4 - dec;
                    break;
                }
                if (!this.isPrefix) {
                    ++dec;
                }
                if (eventType == EventType.NAMESPACE_DECLARATION) {
                    ec2 = 5 - dec;
                    break;
                }
                if (!this.isSC) {
                    ++dec;
                }
                if (eventType == EventType.SELF_CONTAINED) {
                    ec2 = 6 - dec;
                    break;
                }
                if (eventType == EventType.START_ELEMENT_GENERIC_UNDECLARED) {
                    ec2 = 7 - dec;
                    break;
                }
                if (eventType == EventType.CHARACTERS_GENERIC_UNDECLARED) {
                    ec2 = 8 - dec;
                    break;
                }
                if (!this.isDTD) {
                    ++dec;
                }
                if (eventType != EventType.ENTITY_REFERENCE) break;
                ec2 = 9 - dec;
                break;
            }
            case SCHEMA_INFORMED_START_TAG_CONTENT: {
                SchemaInformedStartTagGrammar sist = (SchemaInformedStartTagGrammar)grammar;
                if (this.isStrict) break;
                int dec = 0;
                if (sist.hasEndElement()) {
                    ++dec;
                }
                if (eventType == EventType.END_ELEMENT_UNDECLARED) {
                    ec2 = 0 - dec;
                    break;
                }
                if (eventType == EventType.ATTRIBUTE_GENERIC_UNDECLARED) {
                    ec2 = 1 - dec;
                    break;
                }
                if (eventType == EventType.ATTRIBUTE_INVALID_VALUE) {
                    ec2 = 2 - dec;
                    break;
                }
                if (eventType == EventType.START_ELEMENT_GENERIC_UNDECLARED) {
                    ec2 = 3 - dec;
                    break;
                }
                if (eventType == EventType.CHARACTERS_GENERIC_UNDECLARED) {
                    ec2 = 4 - dec;
                    break;
                }
                if (!this.isDTD) {
                    ++dec;
                }
                if (eventType != EventType.ENTITY_REFERENCE) break;
                ec2 = 5 - dec;
                break;
            }
            case SCHEMA_INFORMED_ELEMENT_CONTENT: {
                SchemaInformedGrammar sig = (SchemaInformedGrammar)grammar;
                if (this.isStrict) break;
                int dec = 0;
                if (sig.hasEndElement()) {
                    ++dec;
                }
                if (eventType == EventType.END_ELEMENT_UNDECLARED) {
                    ec2 = 0 - dec;
                    break;
                }
                if (eventType == EventType.START_ELEMENT_GENERIC_UNDECLARED) {
                    ec2 = 1 - dec;
                    break;
                }
                if (eventType == EventType.CHARACTERS_GENERIC_UNDECLARED) {
                    ec2 = 2 - dec;
                    break;
                }
                if (!this.isDTD) {
                    ++dec;
                }
                if (eventType != EventType.ENTITY_REFERENCE) break;
                ec2 = 3 - dec;
                break;
            }
            case BUILT_IN_START_TAG_CONTENT: {
                if (eventType == EventType.END_ELEMENT_UNDECLARED) {
                    ec2 = 0;
                    break;
                }
                if (eventType == EventType.ATTRIBUTE_GENERIC_UNDECLARED) {
                    ec2 = 1;
                    break;
                }
                int dec = 0;
                if (!this.isPrefix) {
                    ++dec;
                }
                if (eventType == EventType.NAMESPACE_DECLARATION) {
                    ec2 = 2 - dec;
                    break;
                }
                if (!this.isSC) {
                    ++dec;
                }
                if (eventType == EventType.SELF_CONTAINED) {
                    ec2 = 3 - dec;
                    break;
                }
                if (eventType == EventType.START_ELEMENT_GENERIC_UNDECLARED) {
                    ec2 = 4 - dec;
                    break;
                }
                if (eventType == EventType.CHARACTERS_GENERIC_UNDECLARED) {
                    ec2 = 5 - dec;
                    break;
                }
                if (!this.isDTD) {
                    ++dec;
                }
                if (eventType != EventType.ENTITY_REFERENCE) break;
                ec2 = 6 - dec;
                break;
            }
            case BUILT_IN_ELEMENT_CONTENT: {
                if (eventType == EventType.START_ELEMENT_GENERIC_UNDECLARED) {
                    ec2 = 0;
                    break;
                }
                if (eventType == EventType.CHARACTERS_GENERIC_UNDECLARED) {
                    ec2 = 1;
                    break;
                }
                if (!this.isDTD || eventType != EventType.ENTITY_REFERENCE) break;
                ec2 = 2;
            }
        }
        return ec2;
    }

    public int get2ndLevelCharacteristics(Grammar grammar) {
        int ch2 = 0;
        switch (grammar.getGrammarType()) {
            case DOCUMENT: 
            case FRAGMENT: {
                break;
            }
            case DOC_END: {
                if (this.get3rdLevelCharacteristics() <= 0) break;
                ++ch2;
                break;
            }
            case SCHEMA_INFORMED_DOC_CONTENT: 
            case BUILT_IN_DOC_CONTENT: {
                if (this.isDTD) {
                    ++ch2;
                }
                if (this.get3rdLevelCharacteristics() <= 0) break;
                ++ch2;
                break;
            }
            case SCHEMA_INFORMED_FRAGMENT_CONTENT: 
            case BUILT_IN_FRAGMENT_CONTENT: {
                if (this.get3rdLevelCharacteristics() <= 0) break;
                ++ch2;
                break;
            }
            case SCHEMA_INFORMED_FIRST_START_TAG_CONTENT: {
                SchemaInformedFirstStartTagGrammar sifst = (SchemaInformedFirstStartTagGrammar)grammar;
                if (this.isStrict) {
                    ch2 = (sifst.isTypeCastable() ? 1 : 0) + (sifst.isNillable() ? 1 : 0);
                    break;
                }
                if (!sifst.hasEndElement()) {
                    ++ch2;
                }
                ch2 += 4;
                if (this.isPrefix) {
                    ++ch2;
                }
                if (this.isSC) {
                    ++ch2;
                }
                ch2 += 2;
                if (this.isDTD) {
                    ++ch2;
                }
                if (this.get3rdLevelCharacteristics() <= 0) break;
                ++ch2;
                break;
            }
            case SCHEMA_INFORMED_START_TAG_CONTENT: {
                SchemaInformedStartTagGrammar sist = (SchemaInformedStartTagGrammar)grammar;
                if (this.isStrict) break;
                if (!sist.hasEndElement()) {
                    ++ch2;
                }
                ch2 += 4;
                if (this.isDTD) {
                    ++ch2;
                }
                if (this.get3rdLevelCharacteristics() <= 0) break;
                ++ch2;
                break;
            }
            case SCHEMA_INFORMED_ELEMENT_CONTENT: {
                SchemaInformedGrammar sig = (SchemaInformedGrammar)grammar;
                if (this.isStrict) break;
                if (!sig.hasEndElement()) {
                    ++ch2;
                }
                ch2 += 2;
                if (this.isDTD) {
                    ++ch2;
                }
                if (this.get3rdLevelCharacteristics() <= 0) break;
                ++ch2;
                break;
            }
            case BUILT_IN_START_TAG_CONTENT: {
                ch2 += 2;
                if (this.isPrefix) {
                    ++ch2;
                }
                if (this.isSC) {
                    ++ch2;
                }
                ch2 += 2;
                if (this.isDTD) {
                    ++ch2;
                }
                if (this.get3rdLevelCharacteristics() <= 0) break;
                ++ch2;
                break;
            }
            case BUILT_IN_ELEMENT_CONTENT: {
                ch2 += 2;
                if (this.isDTD) {
                    ++ch2;
                }
                if (this.get3rdLevelCharacteristics() <= 0) break;
                ++ch2;
            }
        }
        return ch2;
    }

    public EventType get3rdLevelEventType(int ec3) {
        EventType eventType = null;
        if (ec3 == 0) {
            if (this.isComment) {
                return EventType.COMMENT;
            }
            if (this.isPI) {
                eventType = EventType.PROCESSING_INSTRUCTION;
            }
        } else if (ec3 == 1) {
            assert (this.isFidelityEnabled(FEATURE_COMMENT));
            assert (this.isComment);
            assert (this.isFidelityEnabled(FEATURE_PI));
            assert (this.isPI);
            eventType = EventType.PROCESSING_INSTRUCTION;
        }
        return eventType;
    }

    public int get3rdLevelEventCode(EventType eventType) {
        int ec3 = -1;
        if (!this.isStrict) {
            if (this.isComment) {
                if (EventType.COMMENT == eventType) {
                    ec3 = 0;
                } else if (EventType.PROCESSING_INSTRUCTION == eventType) {
                    ec3 = 1;
                }
            } else if (this.isPI && EventType.PROCESSING_INSTRUCTION == eventType) {
                ec3 = 0;
            }
        }
        return ec3;
    }

    public int get3rdLevelCharacteristics() {
        int ch = 0;
        if (this.isComment) {
            ++ch;
        }
        if (this.isPI) {
            ++ch;
        }
        return ch;
    }
}

