/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.DatatypeID;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.types.DateTimeType;
import com.siemens.ct.exi.values.DateTimeValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;

public class DatetimeDatatype
extends AbstractDatatype {
    private static final long serialVersionUID = -3235729895220215225L;
    DateTimeType datetimeType;
    private DateTimeValue lastValidDatetime;

    public DatetimeDatatype(DateTimeType dateType, QNameContext schemaType) {
        super(BuiltInType.DATETIME, schemaType);
        this.datetimeType = dateType;
    }

    public DatatypeID getDatatypeID() {
        DatatypeID dtID;
        switch (this.datetimeType) {
            case dateTime: {
                dtID = DatatypeID.exi_dateTime;
                break;
            }
            case time: {
                dtID = DatatypeID.exi_time;
                break;
            }
            case date: {
                dtID = DatatypeID.exi_date;
                break;
            }
            case gYearMonth: {
                dtID = DatatypeID.exi_gYearMonth;
                break;
            }
            case gYear: {
                dtID = DatatypeID.exi_gYear;
                break;
            }
            case gMonthDay: {
                dtID = DatatypeID.exi_gMonthDay;
                break;
            }
            case gDay: {
                dtID = DatatypeID.exi_gDay;
                break;
            }
            case gMonth: {
                dtID = DatatypeID.exi_gMonth;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return dtID;
    }

    public DateTimeType getDatetimeType() {
        return this.datetimeType;
    }

    protected boolean isValidString(String value) {
        this.lastValidDatetime = DateTimeValue.parse(value, this.datetimeType);
        return this.lastValidDatetime != null;
    }

    public boolean isValid(Value value) {
        if (value instanceof DateTimeValue) {
            this.lastValidDatetime = (DateTimeValue)value;
            return true;
        }
        return this.isValidString(value.toString());
    }

    public void writeValue(QNameContext qnContext, EncoderChannel valueChannel, StringEncoder stringEncoder) throws IOException {
        valueChannel.encodeDateTime(this.lastValidDatetime);
    }

    public Value readValue(QNameContext qnContext, DecoderChannel valueChannel, StringDecoder stringDecoder) throws IOException {
        return valueChannel.decodeDateTimeValue(this.datetimeType);
    }

    public boolean equals(Object o) {
        if (super.equals(o) && o instanceof DatetimeDatatype) {
            DatetimeDatatype dt = (DatetimeDatatype)o;
            return this.datetimeType == dt.getDatetimeType();
        }
        return false;
    }
}

