/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.values;

import com.siemens.ct.exi.values.AbstractBinaryValue;
import com.siemens.ct.exi.values.ValueType;

public class BinaryHexValue
extends AbstractBinaryValue {
    private static final long serialVersionUID = 4914135099644891193L;
    private int lengthData;
    private static final int BASELENGTH = 128;
    private static final int LOOKUPLENGTH = 16;
    private static final byte[] hexNumberTable;
    private static final char[] lookUpHexAlphabet;

    public BinaryHexValue(byte[] bytes) {
        super(ValueType.BINARY_HEX, bytes);
    }

    public static BinaryHexValue parse(String val) {
        byte[] bytes = BinaryHexValue.decode(val);
        if (bytes == null) {
            return null;
        }
        return new BinaryHexValue(bytes);
    }

    public int getCharactersLength() {
        if (this.slen == -1) {
            this.lengthData = this.bytes.length;
            this.slen = this.lengthData * 2;
        }
        return this.slen;
    }

    public void getCharacters(char[] cbuffer, int offset) {
        this.getCharactersLength();
        for (int i = 0; i < this.lengthData; ++i) {
            int temp = this.bytes[i];
            if (temp < 0) {
                temp += 256;
            }
            cbuffer[offset + i * 2] = lookUpHexAlphabet[temp >> 4];
            cbuffer[offset + i * 2 + 1] = lookUpHexAlphabet[temp & 0xF];
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof BinaryHexValue) {
            return this._equals(((BinaryHexValue)o).bytes);
        }
        BinaryHexValue bv = BinaryHexValue.parse(o.toString());
        return bv == null ? false : this._equals(bv.bytes);
    }

    public int hashCode() {
        int hc = 0;
        for (int i = 0; i < this.bytes.length; ++i) {
            hc = hc * 31 ^ this.bytes[i];
        }
        return hc;
    }

    public static byte[] decode(String encoded) {
        if (encoded == null) {
            return null;
        }
        int lengthData = encoded.length();
        if (lengthData % 2 != 0) {
            return null;
        }
        char[] binaryData = encoded.toCharArray();
        int lengthDecode = lengthData / 2;
        byte[] decodedData = new byte[lengthDecode];
        for (int i = 0; i < lengthDecode; ++i) {
            int temp2;
            int temp1;
            char tempChar = binaryData[i * 2];
            int n = temp1 = tempChar < '\u0080' ? hexNumberTable[tempChar] : -1;
            if (temp1 == -1) {
                return null;
            }
            tempChar = binaryData[i * 2 + 1];
            int n2 = temp2 = tempChar < '\u0080' ? hexNumberTable[tempChar] : -1;
            if (temp2 == -1) {
                return null;
            }
            decodedData[i] = (byte)(temp1 << 4 | temp2);
        }
        return decodedData;
    }

    static {
        int i;
        hexNumberTable = new byte[128];
        lookUpHexAlphabet = new char[16];
        for (i = 0; i < 128; ++i) {
            BinaryHexValue.hexNumberTable[i] = -1;
        }
        for (i = 57; i >= 48; --i) {
            BinaryHexValue.hexNumberTable[i] = (byte)(i - 48);
        }
        for (i = 70; i >= 65; --i) {
            BinaryHexValue.hexNumberTable[i] = (byte)(i - 65 + 10);
        }
        for (i = 102; i >= 97; --i) {
            BinaryHexValue.hexNumberTable[i] = (byte)(i - 97 + 10);
        }
        for (i = 0; i < 10; ++i) {
            BinaryHexValue.lookUpHexAlphabet[i] = (char)(48 + i);
        }
        for (i = 10; i <= 15; ++i) {
            BinaryHexValue.lookUpHexAlphabet[i] = (char)(65 + i - 10);
        }
    }
}

