/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io.compression;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

final class EXIInflaterInputStream
extends InputStream {
    private final InputStream m_inputStream;
    private final Inflater m_inflater;
    private final byte[] outputBuffer;
    private int outputOffset;
    private int outputLimit;
    private final byte[] inputBuffer;
    private int inputLength;

    public EXIInflaterInputStream(InputStream inputStream, Inflater inflater, int n) {
        this.m_inputStream = inputStream;
        this.m_inflater = inflater;
        this.inputBuffer = new byte[n];
        this.inputLength = 0;
        this.outputBuffer = new byte[n];
        this.outputLimit = 0;
        this.outputOffset = 0;
    }

    public int read() throws IOException {
        while (this.outputOffset == this.outputLimit && !this.m_inflater.finished()) {
            this.outputOffset = 0;
            try {
                this.m_inflater.setInput(this.inputBuffer, 0, this.inputLength);
                this.outputLimit = this.m_inflater.inflate(this.outputBuffer);
                int n = this.m_inflater.getRemaining();
                if (n != 0 && n != this.inputLength) {
                    int n2 = this.inputLength - n;
                    this.inputLength = n;
                    int n3 = 0;
                    int n4 = n2;
                    while (n3 < this.inputLength) {
                        this.inputBuffer[n3] = this.inputBuffer[n4];
                        ++n3;
                        ++n4;
                    }
                    continue;
                }
                if (this.outputLimit == 0 && n == 0) {
                    assert (!this.m_inflater.finished());
                    this.inputLength = this.m_inputStream.read(this.inputBuffer, 0, this.inputBuffer.length);
                    if (this.inputLength >= 0) continue;
                    this.inputLength = 0;
                    return -1;
                }
                this.inputLength = n;
            }
            catch (DataFormatException dataFormatException) {
                throw new IOException(dataFormatException.getMessage());
            }
        }
        return this.outputOffset != this.outputLimit ? this.outputBuffer[this.outputOffset++] & 0xFF : -1;
    }

    void resetInflator() throws IOException {
        int n = 0;
        while (!this.m_inflater.finished() && n != -1) {
            n = this.read();
        }
        this.m_inflater.reset();
    }

    void end() {
    }
}

