/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.sax;

import java.io.IOException;
import java.io.InputStream;
import org.openexi.proc.EXIDecoder;
import org.openexi.proc.common.EXIOptionsException;
import org.openexi.proc.common.EventDescription;
import org.openexi.proc.grammars.GrammarCache;
import org.openexi.proc.io.Scanner;
import org.openexi.schema.Characters;
import org.openexi.schema.EXISchema;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class ReaderSupport
implements Attributes {
    protected final EXIDecoder m_decoder = new EXIDecoder();
    protected ContentHandler m_contentHandler;
    protected String[] m_namespaceDeclarationsLocus = new String[PREFIXES.length * 2];
    protected int m_n_namespaceDeclarations;
    protected int m_attrLength;
    private String[] m_attrData = new String[128];
    private Characters[] m_attrValue = new Characters[32];
    protected static final String[] PREFIXES = new String[]{"xml", "p0", "p1", "p2", "p3", "p4", "p5", "p6", "p7", "p8", "p9", "p10", "p11", "p12", "p13", "p14", "p15", "p16", "p17", "p18", "p19", "p20", "p21", "p22", "p23", "p24", "p25", "p26", "p27", "p28", "p29", "p30", "p31", "p32", "p33", "p34", "p35", "p36", "p37", "p38", "p39", "p40", "p41", "p42", "p43", "p44", "p45", "p46", "p47", "p48", "p49", "p50", "p51", "p52", "p53", "p54", "p55", "p56", "p57", "p58", "p59", "p60", "p61", "p62"};
    protected boolean m_preserveNS;
    protected boolean m_preserveLexicalValues;
    protected int m_n_prefixes;
    protected String[] m_prefixes;
    protected String[] m_prefixesColon;
    protected String[] m_uris;
    protected int[] m_n_qualifiedNames;
    protected String[][] m_qualifiedNames;
    private static final int ATTRIBUTE_URI_OFFSET = 0;
    private static final int ATTRIBUTE_LOCALNAME_OFFSET = 1;
    private static final int ATTRIBUTE_QNAME_OFFSET = 2;
    private static final int ATTRIBUTE_TYPE_OFFSET = 3;
    private static final int ATTRIBUTE_SZ = 4;
    protected final StringBuilder stringBuilder = new StringBuilder();

    protected ReaderSupport() {
        this.populatePrefixes(null);
    }

    protected void reset() {
        this.m_n_namespaceDeclarations = 0;
        this.pushNamespaceDeclaration(PREFIXES[0], "http://www.w3.org/XML/1998/namespace");
    }

    public final void setContentHandler(ContentHandler contentHandler) {
        this.m_contentHandler = contentHandler;
    }

    public final ContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    public void setGrammarCache(GrammarCache grammarCache) throws EXIOptionsException {
        this.populatePrefixes(grammarCache.getEXISchema());
        this.m_decoder.setGrammarCache(grammarCache);
    }

    protected final Scanner processHeader(InputStream inputStream) throws IOException, SAXException {
        Scanner scanner;
        this.m_decoder.setInputStream(inputStream);
        try {
            scanner = this.m_decoder.processHeader();
        }
        catch (EXIOptionsException eXIOptionsException) {
            throw new SAXException(eXIOptionsException.getMessage(), eXIOptionsException);
        }
        this.m_preserveNS = scanner.getPreserveNS();
        this.m_preserveLexicalValues = scanner.getPreserveLexicalValues();
        return scanner;
    }

    protected final boolean doAttribute(EventDescription eventDescription, Scanner scanner) throws IOException, SAXException {
        String string;
        boolean bl = false;
        String string2 = eventDescription.getURI();
        String string3 = eventDescription.getName();
        if (this.m_preserveNS) {
            String string4 = eventDescription.getPrefix();
            if (string4.length() != 0) {
                this.stringBuilder.setLength(0);
                string = this.stringBuilder.append(string4).append(':').append(string3).toString();
            } else {
                string = string3;
            }
        } else {
            int n = eventDescription.getURIId();
            if (n < this.m_n_prefixes) {
                int n2 = eventDescription.getNameId();
                if (n2 < this.m_n_qualifiedNames[n]) {
                    string = this.m_qualifiedNames[n][n2];
                } else {
                    this.stringBuilder.setLength(0);
                    string = this.stringBuilder.append(this.m_prefixesColon[n]).append(string3).toString();
                }
            } else if (string2.length() != 0) {
                int n3;
                String string5 = "";
                for (n3 = this.m_n_namespaceDeclarations - 1; n3 > -1; --n3) {
                    if (!string2.equals(this.m_namespaceDeclarationsLocus[n3 << 1 | 1])) continue;
                    string5 = this.m_namespaceDeclarationsLocus[n3 << 1];
                    break;
                }
                if (n3 == -1) {
                    if (this.m_n_namespaceDeclarations < PREFIXES.length) {
                        string5 = PREFIXES[this.m_n_namespaceDeclarations];
                    } else {
                        this.stringBuilder.setLength(0);
                        string5 = this.stringBuilder.append('p').append(this.m_n_namespaceDeclarations).toString();
                    }
                    if (this.m_contentHandler != null) {
                        this.m_contentHandler.startPrefixMapping(string5, string2);
                    }
                    this.pushNamespaceDeclaration(string5, string2);
                    bl = true;
                }
                if (string5.length() != 0) {
                    this.stringBuilder.setLength(0);
                    string = this.stringBuilder.append(string5).append(':').append(string3).toString();
                } else {
                    string = string3;
                }
            } else {
                string = string3;
            }
        }
        this.addAttribute(string2, string3, string, "", eventDescription.getCharacters());
        return bl;
    }

    public final int getLength() {
        return this.m_attrLength;
    }

    public final String getURI(int n) {
        if (-1 < n && n < this.m_attrLength) {
            return this.m_attrData[4 * n + 0];
        }
        return null;
    }

    public final String getLocalName(int n) {
        if (-1 < n && n < this.m_attrLength) {
            return this.m_attrData[4 * n + 1];
        }
        return null;
    }

    public final String getQName(int n) {
        if (-1 < n && n < this.m_attrLength) {
            return this.m_attrData[4 * n + 2];
        }
        return null;
    }

    public final String getType(int n) {
        if (-1 < n && n < this.m_attrLength) {
            return this.m_attrData[4 * n + 3];
        }
        return null;
    }

    public final String getValue(int n) {
        if (-1 < n && n < this.m_attrLength) {
            return this.m_attrValue[n].makeString();
        }
        return null;
    }

    public final int getIndex(String string, String string2) {
        int n = this.m_attrLength * 4;
        for (int i = 0; i < n; i += 4) {
            if (!this.m_attrData[i + 0].equals(string) || !this.m_attrData[i + 1].equals(string2)) continue;
            return i / 4;
        }
        return -1;
    }

    public final int getIndex(String string) {
        int n = this.m_attrLength * 4;
        for (int i = 0; i < n; i += 4) {
            if (!this.m_attrData[i + 2].equals(string)) continue;
            return i / 4;
        }
        return -1;
    }

    public final String getType(String string, String string2) {
        int n = this.m_attrLength * 4;
        for (int i = 0; i < n; i += 4) {
            if (!this.m_attrData[i + 0].equals(string) || !this.m_attrData[i + 1].equals(string2)) continue;
            return this.m_attrData[i + 3];
        }
        return null;
    }

    public final String getType(String string) {
        int n = this.m_attrLength * 4;
        for (int i = 0; i < n; i += 4) {
            if (!this.m_attrData[i + 2].equals(string)) continue;
            return this.m_attrData[i + 3];
        }
        return null;
    }

    public final String getValue(String string, String string2) {
        int n = 4 * this.m_attrLength;
        for (int i = 0; i < n; i += 4) {
            if (!this.m_attrData[i + 0].equals(string) || !this.m_attrData[i + 1].equals(string2)) continue;
            return this.m_attrValue[i / 4].makeString();
        }
        return null;
    }

    public final String getValue(String string) {
        int n = 4 * this.m_attrLength;
        for (int i = 0; i < n; i += 4) {
            if (!this.m_attrData[i + 2].equals(string)) continue;
            return this.m_attrValue[i / 4].makeString();
        }
        return null;
    }

    protected final void addAttribute(String string, String string2, String string3, String string4, Characters characters) {
        assert (characters != null);
        int n = this.m_attrLength + 1;
        if (this.m_attrData.length < 4 * n) {
            String[] stringArray = new String[this.m_attrData.length + 128];
            System.arraycopy(this.m_attrData, 0, stringArray, 0, 4 * this.m_attrLength);
            this.m_attrData = stringArray;
            Characters[] charactersArray = new Characters[this.m_attrValue.length + 32];
            System.arraycopy(this.m_attrValue, 0, charactersArray, 0, this.m_attrLength);
            this.m_attrValue = charactersArray;
        }
        this.m_attrData[this.m_attrLength * 4 + 0] = string;
        this.m_attrData[this.m_attrLength * 4 + 1] = string2;
        this.m_attrData[this.m_attrLength * 4 + 2] = string3;
        this.m_attrData[this.m_attrLength * 4 + 3] = string4;
        this.m_attrValue[this.m_attrLength] = characters;
        this.m_attrLength = n;
    }

    protected final void pushNamespaceDeclaration(String string, String string2) {
        if (2 * this.m_n_namespaceDeclarations == this.m_namespaceDeclarationsLocus.length) {
            String[] stringArray = new String[this.m_namespaceDeclarationsLocus.length + 16];
            System.arraycopy(this.m_namespaceDeclarationsLocus, 0, stringArray, 0, this.m_namespaceDeclarationsLocus.length);
            this.m_namespaceDeclarationsLocus = stringArray;
        }
        int n = this.m_n_namespaceDeclarations++ << 1;
        this.m_namespaceDeclarationsLocus[n] = string;
        this.m_namespaceDeclarationsLocus[n | 1] = string2;
    }

    private void populatePrefixes(EXISchema eXISchema) {
        int n;
        String[][] stringArray;
        if (eXISchema != null) {
            this.m_uris = eXISchema.uris;
            stringArray = eXISchema.localNames;
        } else {
            this.m_uris = new String[]{"", "http://www.w3.org/XML/1998/namespace", "http://www.w3.org/2001/XMLSchema-instance"};
            stringArray = new String[][]{null, {"base", "id", "lang", "space"}, {"nil", "type"}};
        }
        this.m_n_prefixes = this.m_uris.length;
        this.m_prefixes = new String[this.m_n_prefixes];
        this.m_prefixesColon = new String[this.m_n_prefixes];
        this.m_prefixes[0] = "";
        this.m_prefixesColon[0] = "";
        this.m_prefixes[1] = "xml";
        this.m_prefixesColon[1] = "xml:";
        this.m_prefixes[2] = "xsi";
        this.m_prefixesColon[2] = "xsi:";
        if (this.m_n_prefixes > 3) {
            this.m_prefixes[3] = "xsd";
            this.m_prefixesColon[3] = "xsd:";
            for (n = 4; n < this.m_n_prefixes; ++n) {
                this.stringBuilder.setLength(0);
                this.m_prefixes[n] = this.stringBuilder.append('s').append(n - 4).toString();
                this.stringBuilder.setLength(0);
                this.m_prefixesColon[n] = this.stringBuilder.append(this.m_prefixes[n]).append(':').toString();
            }
        }
        this.m_n_qualifiedNames = new int[this.m_uris.length];
        this.m_n_qualifiedNames[0] = 0;
        this.m_qualifiedNames = new String[this.m_uris.length][];
        for (n = 1; n < this.m_uris.length; ++n) {
            String[] stringArray2 = stringArray[n];
            this.m_n_qualifiedNames[n] = stringArray2.length;
            this.m_qualifiedNames[n] = new String[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                this.stringBuilder.setLength(0);
                this.m_qualifiedNames[n][i] = this.stringBuilder.append(this.m_prefixesColon[n]).append(stringArray2[i]).toString();
            }
        }
    }
}

