/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.openexi.proc.common.QName;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.Scriber;
import org.openexi.proc.io.ValueScriberBase;
import org.openexi.schema.XSDateTime;

abstract class DateTimeValueScriberBase
extends ValueScriberBase {
    protected int nextPosition;

    protected DateTimeValueScriberBase(QName qName) {
        super(qName);
    }

    public final Object toValue(String string, Scribble scribble, Scriber scriber) {
        return scribble.dateTime;
    }

    public final void doScribe(Object object, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        this.scribeDateTimeValue((XSDateTime)object, outputStream, scriber);
    }

    public final void scribe(String string, Scribble scribble, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        this.scribeDateTimeValue(scribble.dateTime, outputStream, scriber);
    }

    abstract void scribeDateTimeValue(XSDateTime var1, OutputStream var2, Scriber var3) throws IOException;

    public static final void canonicalizeValue(Scribble scribble) {
        scribble.dateTime.normalize();
    }

    protected final void writeYear(int n, OutputStream outputStream, Scriber scriber) throws IOException {
        if ((n -= 2000) < 0) {
            scriber.writeBoolean(true, outputStream);
            n = -1 - n;
        } else {
            scriber.writeBoolean(false, outputStream);
        }
        scriber.writeUnsignedInteger32(n, outputStream);
    }

    protected final void writeMonthDay(int n, int n2, OutputStream outputStream, Scriber scriber) throws IOException {
        int n3 = n * 32 + n2;
        scriber.writeNBitUnsigned(n3, 9, outputStream);
    }

    protected final void writeTime(int n, int n2, int n3, BigInteger bigInteger, OutputStream outputStream, Scriber scriber) throws IOException {
        int n4 = (n * 64 + n2) * 64 + n3;
        scriber.writeNBitUnsigned(n4, 17, outputStream);
        if (bigInteger != null) {
            scriber.writeBoolean(true, outputStream);
            assert (bigInteger.signum() == 1);
            scriber.writeUnsignedInteger(bigInteger, outputStream);
        } else {
            scriber.writeBoolean(false, outputStream);
        }
    }

    protected final void writeTimeZone(int n, OutputStream outputStream, Scriber scriber) throws IOException {
        if (n != Integer.MIN_VALUE) {
            scriber.writeBoolean(true, outputStream);
            int n2 = n / 60;
            int n3 = n % 60;
            scriber.writeNBitUnsigned((n2 + 14) * 64 + n3, 11, outputStream);
        } else {
            scriber.writeBoolean(false, outputStream);
        }
    }

    protected final boolean parseYearField(String string, Scribble scribble) {
        char c;
        boolean bl = string.charAt(this.nextPosition) == '-';
        if (bl) {
            ++this.nextPosition;
        }
        int n = 0;
        int n2 = 0;
        while (this.nextPosition < this.limitPosition && (c = string.charAt(this.nextPosition)) >= '0' && '9' >= c) {
            n2 = 10 * n2 + (c - 48);
            ++n;
            ++this.nextPosition;
        }
        if (n < 4 || n2 == 0) {
            return false;
        }
        scribble.intValue1 = bl ? 0 - n2 : n2;
        return true;
    }

    protected final boolean parseMonthField(String string, Scribble scribble) {
        char c;
        int n = 0;
        int n2 = 0;
        while (this.nextPosition < this.limitPosition && (c = string.charAt(this.nextPosition)) >= '0' && '9' >= c) {
            n2 = 10 * n2 + (c - 48);
            ++n;
            ++this.nextPosition;
        }
        if (n != 2 || n2 == 0 || 12 < n2) {
            return false;
        }
        scribble.intValue1 = n2;
        return true;
    }

    protected final boolean parseDayField(String string, int n, int n2, Scribble scribble) {
        char c;
        int n3 = 0;
        int n4 = 0;
        while (this.nextPosition < this.limitPosition && (c = string.charAt(this.nextPosition)) >= '0' && '9' >= c) {
            n4 = 10 * n4 + (c - 48);
            ++n3;
            ++this.nextPosition;
        }
        if (n3 != 2 || n4 == 0 || XSDateTime.getLastDayOfMonth(n, n2) < n4) {
            return false;
        }
        scribble.intValue1 = n4;
        return true;
    }

    protected final boolean parseHourField(String string, Scribble scribble) {
        char c;
        int n = 0;
        int n2 = 0;
        while (this.nextPosition < this.limitPosition && (c = string.charAt(this.nextPosition)) >= '0' && '9' >= c) {
            n2 = 10 * n2 + (c - 48);
            ++n;
            ++this.nextPosition;
        }
        if (n != 2 || 24 < n2) {
            return false;
        }
        scribble.intValue1 = n2;
        return true;
    }

    protected final boolean parseMinuteField(String string, Scribble scribble) {
        char c;
        int n = 0;
        int n2 = 0;
        while (this.nextPosition < this.limitPosition && (c = string.charAt(this.nextPosition)) >= '0' && '9' >= c) {
            n2 = 10 * n2 + (c - 48);
            ++n;
            ++this.nextPosition;
        }
        if (n != 2 || 59 < n2) {
            return false;
        }
        scribble.intValue1 = n2;
        return true;
    }

    protected final boolean parseSecondField(String string, Scribble scribble) {
        char c;
        int n = 0;
        int n2 = 0;
        while (this.nextPosition < this.limitPosition && (c = string.charAt(this.nextPosition)) >= '0' && '9' >= c) {
            n2 = 10 * n2 + (c - 48);
            ++n;
            ++this.nextPosition;
        }
        if (n != 2) {
            return false;
        }
        scribble.intValue1 = n2;
        return true;
    }

    protected final BigInteger parseFractionalSecondField(String string) {
        char c;
        BigInteger bigInteger = BigInteger.ONE;
        BigInteger bigInteger2 = BigInteger.ZERO;
        int n = 0;
        while (this.nextPosition < this.limitPosition && (c = string.charAt(this.nextPosition)) >= '0' && '9' >= c) {
            bigInteger2 = bigInteger2.add(bigInteger.multiply(BigInteger.valueOf(c - 48)));
            ++n;
            ++this.nextPosition;
            bigInteger = BigInteger.TEN.multiply(bigInteger);
        }
        if (n == 0) {
            return null;
        }
        return bigInteger2;
    }

    protected final boolean parseTimezoneField(String string, Scribble scribble) {
        char c;
        int n = 0;
        boolean bl = false;
        if ((c = string.charAt(this.nextPosition++)) == 'Z') {
            n = 0;
        } else {
            if (c == '-') {
                bl = true;
            } else if (c != '+') {
                return false;
            }
            if (this.nextPosition == this.limitPosition) {
                return false;
            }
            if (!this.parseHourField(string, scribble) || this.nextPosition == this.limitPosition) {
                return false;
            }
            int n2 = scribble.intValue1;
            if (string.charAt(this.nextPosition++) != ':' || this.nextPosition == this.limitPosition) {
                return false;
            }
            if (!this.parseMinuteField(string, scribble)) {
                return false;
            }
            int n3 = scribble.intValue1;
            n = 60 * n2 + n3;
        }
        if (bl) {
            n = 0 - n;
        }
        scribble.intValue1 = n;
        return true;
    }
}

