/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.lang.reflect.Constructor;
import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.io.BitPackedScriber;
import org.openexi.proc.io.ByteAlignedScriber;
import org.openexi.proc.io.Scriber;

public final class ScriberFactory {
    private static final Constructor<?> m_channellingScriberConstructor;
    private static final Object[] ARGS_PRECOMPRESS;
    private static final Object[] ARGS_COMPRESS;

    public static Scriber createScriber(AlignmentType alignmentType) {
        switch (alignmentType) {
            case bitPacked: {
                return new BitPackedScriber(false);
            }
            case byteAligned: {
                return new ByteAlignedScriber();
            }
            case preCompress: {
                if (m_channellingScriberConstructor == null) break;
                try {
                    return (Scriber)m_channellingScriberConstructor.newInstance(ARGS_PRECOMPRESS);
                }
                catch (Exception exception) {
                    break;
                }
            }
            case compress: {
                if (m_channellingScriberConstructor == null) break;
                try {
                    return (Scriber)m_channellingScriberConstructor.newInstance(ARGS_COMPRESS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static BitPackedScriber createHeaderOptionsScriber() {
        return new BitPackedScriber(true);
    }

    static {
        Constructor<?> constructor;
        block3: {
            ARGS_PRECOMPRESS = new Object[]{Boolean.FALSE};
            ARGS_COMPRESS = new Object[]{Boolean.TRUE};
            ClassLoader classLoader = ScriberFactory.class.getClassLoader();
            constructor = null;
            try {
                Class<?> clazz = classLoader.loadClass("org.openexi.proc.io.compression.ChannellingScriber");
                constructor = clazz.getDeclaredConstructor(Boolean.TYPE);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        m_channellingScriberConstructor = constructor;
    }
}

