/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io.compression;

import java.io.IOException;
import java.io.OutputStream;
import org.openexi.proc.common.QName;
import org.openexi.proc.common.StringTable;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.Scriber;
import org.openexi.proc.io.ValueScriber;
import org.openexi.proc.io.compression.ChannelKeeper;
import org.openexi.proc.io.compression.ChannellingScriber;
import org.openexi.proc.io.compression.ScriberChannel;
import org.openexi.proc.io.compression.ScriberValueHolder;
import org.openexi.schema.EXISchema;

class ChannellingValueScriberProxy
extends ValueScriber {
    protected final ChannelKeeper m_channelKeeper;
    protected final ValueScriber m_valueScriber;

    ChannellingValueScriberProxy(ChannelKeeper channelKeeper, ValueScriber valueScriber) {
        this.m_channelKeeper = channelKeeper;
        this.m_valueScriber = valueScriber;
    }

    public final void scribe(String string, Scribble scribble, int n, int n2, int n3, Scriber scriber) throws IOException {
        StringTable stringTable = scriber.stringTable;
        ScriberChannel scriberChannel = (ScriberChannel)this.m_channelKeeper.getChannel(n, n2, stringTable);
        boolean bl = this.m_channelKeeper.incrementValueCount(scriberChannel);
        scriberChannel.values.add(new ScriberValueHolder(n, n2, n3, this.toValue(string, scribble, scriber), this));
        if (bl) {
            ((ChannellingScriber)scriber).finishBlock();
        }
    }

    public final QName getName() {
        return this.m_valueScriber.getName();
    }

    public final short getCodecID() {
        return this.m_valueScriber.getCodecID();
    }

    public final int getBuiltinRCS(int n, Scriber scriber) {
        return this.m_valueScriber.getBuiltinRCS(n, scriber);
    }

    public final boolean process(String string, int n, EXISchema eXISchema, Scribble scribble, Scriber scriber) {
        return this.m_valueScriber.process(string, n, eXISchema, scribble, scriber);
    }

    public final Object toValue(String string, Scribble scribble, Scriber scriber) {
        return this.m_valueScriber.toValue(string, scribble, scriber);
    }

    public final void doScribe(Object object, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        this.m_valueScriber.doScribe(object, n, n2, n3, outputStream, scriber);
    }

    public final void scribe(String string, Scribble scribble, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        this.m_valueScriber.scribe(string, scribble, n, n2, n3, outputStream, scriber);
    }
}

