/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.scomp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.openexi.proc.HeaderOptionsOutputType;
import org.openexi.proc.common.EXIOptionsException;
import org.openexi.proc.common.SchemaId;
import org.openexi.sax.Transmogrifier;
import org.openexi.sax.TransmogrifierException;
import org.openexi.schema.EXISchema;
import org.openexi.scomp.GrammarCache4Grammar;
import org.xml.sax.InputSource;

public class EXISchemaWriter {
    final Transmogrifier m_transmogrifier = new Transmogrifier();

    public EXISchemaWriter() {
        try {
            this.m_transmogrifier.setGrammarCache(GrammarCache4Grammar.getGrammarCache(), new SchemaId("nagasena:grammar"));
            this.m_transmogrifier.setOutputOptions(HeaderOptionsOutputType.all);
        }
        catch (EXIOptionsException eXIOptionsException) {
            assert (false);
            throw new RuntimeException(eXIOptionsException);
        }
    }

    public void serialize(EXISchema eXISchema, OutputStream outputStream) throws IOException {
        this.serialize(eXISchema, outputStream, null);
    }

    public void serialize(EXISchema eXISchema, OutputStream outputStream, StringBuilder stringBuilder) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        eXISchema.writeXml((OutputStream)byteArrayOutputStream, false);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (stringBuilder != null) {
            stringBuilder.delete(0, stringBuilder.length());
            stringBuilder.append(new String(byArray, "UTF-8"));
        }
        byteArrayOutputStream.close();
        this.m_transmogrifier.setOutputStream(outputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            this.m_transmogrifier.encode(new InputSource(byteArrayInputStream));
        }
        catch (TransmogrifierException transmogrifierException) {
            throw new RuntimeException(transmogrifierException);
        }
        finally {
            byteArrayInputStream.close();
            outputStream.close();
        }
    }
}

