/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.InputStream;
import org.openexi.proc.common.QName;
import org.openexi.proc.io.Scanner;
import org.openexi.proc.io.ValueScannerBase;

abstract class DateTimeValueScannerBase
extends ValueScannerBase {
    protected final char[] m_dateTimeCharacters;
    protected int m_n_dateTimeCharacters;
    private final char[] m_transientCharacters;
    private final StringBuilder m_stringBuffer2;
    protected final Scanner m_scanner;

    protected DateTimeValueScannerBase(QName qName, Scanner scanner) {
        super(qName);
        this.m_scanner = scanner;
        this.m_dateTimeCharacters = new char[256];
        this.m_n_dateTimeCharacters = 0;
        this.m_transientCharacters = new char[64];
        this.m_stringBuffer2 = new StringBuilder();
    }

    public final int getBuiltinRCS(int n) {
        return -5;
    }

    protected final void readYear(InputStream inputStream) throws IOException {
        boolean bl = this.m_scanner.readBoolean(inputStream);
        int n = this.m_scanner.readUnsignedInteger(inputStream);
        int n2 = n = bl ? 1999 - n : n + 2000;
        if (n < 0) {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 45;
            n = 0 - n;
        }
        if (n < 10) {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
        } else if (n < 100) {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
        } else if (n < 1000) {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
        }
        int n3 = 0;
        while (n != 0) {
            char c = (char)(48 + n % 10);
            this.m_transientCharacters[n3++] = c;
            n /= 10;
        }
        --n3;
        while (n3 != -1) {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = this.m_transientCharacters[n3];
            --n3;
        }
    }

    protected final void readGDay(InputStream inputStream) throws IOException {
        int n = this.m_scanner.readNBitUnsigned(9, inputStream);
        this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 45;
        this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 45;
        this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 45;
        if (n < 10) {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n);
        } else {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n / 10);
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n % 10);
        }
    }

    protected final void readGMonth(InputStream inputStream) throws IOException {
        int n = this.m_scanner.readNBitUnsigned(9, inputStream);
        int n2 = n >>> 5;
        assert (n % 32 == 0);
        this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 45;
        this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 45;
        if (n2 < 10) {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2);
        } else {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2 / 10);
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2 % 10);
        }
    }

    protected final void readGMonthDay(InputStream inputStream) throws IOException {
        int n = this.m_scanner.readNBitUnsigned(9, inputStream);
        int n2 = n >>> 5;
        int n3 = n & 0x1F;
        this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 45;
        this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 45;
        if (n2 < 10) {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2);
        } else {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2 / 10);
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2 % 10);
        }
        this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 45;
        if (n3 < 10) {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n3);
        } else {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n3 / 10);
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n3 % 10);
        }
    }

    protected final void readGYearMonth(InputStream inputStream) throws IOException {
        this.readYear(inputStream);
        this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 45;
        int n = this.m_scanner.readNBitUnsigned(9, inputStream);
        int n2 = n >>> 5;
        assert (n % 32 == 0);
        if (n2 < 10) {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2);
        } else {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2 / 10);
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2 % 10);
        }
    }

    protected final void readMonthDay(InputStream inputStream) throws IOException {
        int n = this.m_scanner.readNBitUnsigned(9, inputStream);
        int n2 = n >>> 5;
        int n3 = n & 0x1F;
        this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 45;
        if (n2 < 10) {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2);
        } else {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2 / 10);
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2 % 10);
        }
        this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 45;
        if (n3 < 10) {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n3);
        } else {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n3 / 10);
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n3 % 10);
        }
    }

    protected final void readTime(InputStream inputStream) throws IOException {
        int n = this.m_scanner.readNBitUnsigned(17, inputStream);
        int n2 = n >> 12;
        int n3 = (n &= 0xFFF) / 64;
        int n4 = n % 64;
        if (n2 < 10) {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2);
        } else {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2 / 10);
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2 % 10);
        }
        if (n3 < 10) {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 58;
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n3);
        } else {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 58;
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n3 / 10);
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n3 % 10);
        }
        if (n4 < 10) {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 58;
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n4);
        } else {
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 58;
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n4 / 10);
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n4 % 10);
        }
        if (this.m_scanner.readBoolean(inputStream)) {
            n = this.m_scanner.readUnsignedInteger(inputStream);
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 46;
            this.m_stringBuffer2.setLength(0);
            this.m_stringBuffer2.append(Integer.toString(n)).reverse();
            for (int i = 0; i < this.m_stringBuffer2.length(); ++i) {
                this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = this.m_stringBuffer2.charAt(i);
            }
        }
    }

    protected final void readTimeZone(InputStream inputStream) throws IOException {
        if (this.m_scanner.readBoolean(inputStream)) {
            int n = this.m_scanner.readNBitUnsigned(11, inputStream);
            if ((n -= 896) != 0) {
                if (n < 0) {
                    this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 45;
                    n = 0 - n;
                } else {
                    this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 43;
                }
                int n2 = n / 64;
                int n3 = n % 64;
                if (n2 < 10) {
                    this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
                    this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2);
                } else {
                    this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2 / 10);
                    this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n2 % 10);
                }
                if (n3 < 10) {
                    this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 58;
                    this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 48;
                    this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n3);
                } else {
                    this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 58;
                    this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n3 / 10);
                    this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = (char)(48 + n3 % 10);
                }
            } else {
                this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 90;
            }
        }
    }
}

