/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.scomp;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;

public final class URIHelper {
    private static final String URIC_ALPHANUM = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final String URIC_MARK = "-_.!~*'()";
    private static final String URIC_RESERVED = ";/?:@&=+$,[]#%";
    private static final String URIC_UNRESERVED = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()";
    private static final String URIC = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'();/?:@&=+$,[]#%";
    private static final byte[] ASCIITABLE;
    private static final byte ASCII_IS_URIC = 1;
    private static final byte ASCII_IS_URIC_RESERVED = 2;
    private static final String URIC_HEX = "0123456789ABCDEF";

    public static final String escapeURI(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new URIHelperConfigurationException("System needs to support UTF8 encoding.", unsupportedEncodingException);
        }
        for (byte by : byArray) {
            char c;
            char c2 = c = by >= 0 ? (char)by : (char)(256 + by);
            if (URIHelper.isURIChar(c)) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('%');
            byte by2 = (byte)(c >> 4);
            byte by3 = (byte)(c & 0xF);
            stringBuffer.append(URIC_HEX.charAt(by2));
            stringBuffer.append(URIC_HEX.charAt(by3));
        }
        return stringBuffer.toString();
    }

    public static final String unescapeURI(String string) {
        int n = 0;
        byte[] byArray = new byte[string.length()];
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            byte by;
            byte by2;
            byte by3;
            char c;
            if ((c = string.charAt(n2++)) != '%' || n2 == n3 || n2 + 1 == n3) {
                byArray[n++] = (byte)c;
                continue;
            }
            if (URIC_RESERVED.indexOf((char)(by3 = (byte)(((by2 = (byte)URIC_HEX.indexOf(string.charAt(n2++))) << 4) + (by = (byte)URIC_HEX.indexOf(string.charAt(n2++)))))) < 0) {
                byArray[n++] = by3;
                continue;
            }
            byArray[n++] = 37;
            byArray[n++] = (byte)URIC_HEX.charAt(by2);
            byArray[n++] = (byte)URIC_HEX.charAt(by);
        }
        String string2 = null;
        try {
            string2 = new String(byArray, 0, n, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new URIHelperConfigurationException("System needs to support UTF8 encoding.", unsupportedEncodingException);
        }
        return string2;
    }

    public static URI resolveURI(String string, URI uRI) throws URISyntaxException {
        URI uRI2 = null;
        if (string != null) {
            int n = string.indexOf(58);
            if (n <= 1) {
                if (n == 1) {
                    char c = string.charAt(0);
                    if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                        uRI2 = new File(string).toURI();
                    }
                } else if (uRI != null) {
                    uRI2 = uRI.resolve(string);
                } else {
                    return null;
                }
            }
            if (uRI2 == null) {
                uRI2 = new URI(string);
            }
        }
        return uRI2;
    }

    private static boolean isURIChar(char c) {
        if (c < '\u0000' || c > '\u007f') {
            return false;
        }
        return (ASCIITABLE[c] & 1) != 0;
    }

    static {
        int n;
        ASCIITABLE = new byte[256];
        int n2 = URIC.length();
        for (n = 0; n < n2; ++n) {
            char c = URIC.charAt(n);
            ASCIITABLE[c] = (byte)(ASCIITABLE[c] | 1);
        }
        n2 = URIC_RESERVED.length();
        for (n = 0; n < n2; ++n) {
            char c = URIC.charAt(n);
            ASCIITABLE[c] = (byte)(ASCIITABLE[c] | 2);
        }
    }

    public static final class URIHelperConfigurationException
    extends RuntimeException {
        private static final long serialVersionUID = -1582064518022751291L;
        private Exception m_exception;

        private URIHelperConfigurationException(String string, Exception exception) {
            super(string);
            this.m_exception = exception;
        }

        public Exception getException() {
            return this.m_exception;
        }
    }
}

