/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.api.dom;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.DTDHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

class SaxToDomHandler
extends DefaultHandler
implements LexicalHandler,
DTDHandler,
DeclHandler {
    protected Document document;
    protected DocumentFragment docFragment;
    protected DOMImplementation domImplementation;
    protected boolean fragment;
    protected Node currentNode;
    protected DocumentType dt;
    protected List<PrefixMapping> prefixes;

    public SaxToDomHandler(DOMImplementation domImplementation, boolean fragment) {
        this.domImplementation = domImplementation;
        this.fragment = fragment;
        this.prefixes = new ArrayList<PrefixMapping>();
    }

    protected Document checkDocument() {
        if (this.document == null) {
            this.document = this.domImplementation.createDocument(null, null, this.dt);
            if (this.fragment) {
                this.docFragment = this.document.createDocumentFragment();
                this.currentNode = this.docFragment;
            } else {
                this.currentNode = this.document;
            }
        }
        return this.document;
    }

    public Document getDocument() {
        return this.document;
    }

    public DocumentFragment getDocumentFragment() {
        return this.docFragment;
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) throws SAXException {
        int i;
        Element element = this.checkDocument().createElementNS(uri, qName);
        for (i = 0; i < this.prefixes.size(); ++i) {
            PrefixMapping pm = this.prefixes.get(i);
            String qname = pm.prefix.length() == 0 ? "xmlns" : "xmlns:" + pm.prefix;
            Attr attr = this.checkDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", qname);
            attr.setValue(pm.uri);
            element.setAttributeNodeNS(attr);
        }
        this.prefixes.clear();
        for (i = 0; i < attrs.getLength(); ++i) {
            String value = attrs.getValue(i);
            String ns_uri = attrs.getURI(i);
            String qname = attrs.getQName(i);
            Attr attr = this.checkDocument().createAttributeNS(ns_uri, qname);
            attr.setValue(value);
            element.setAttributeNodeNS(attr);
        }
        this.currentNode.appendChild(element);
        this.currentNode = element;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixes.add(new PrefixMapping(prefix, uri));
    }

    public void endElement(String uri, String name, String qName) {
        this.currentNode = this.currentNode.getParentNode();
    }

    public void characters(char[] ch, int start, int length) {
        if (length > 0) {
            String ss = new String(ch, start, length);
            Text text = this.checkDocument().createTextNode(ss);
            this.currentNode.appendChild(text);
        }
    }

    public void processingInstruction(String target, String data) {
        ProcessingInstruction pi = this.checkDocument().createProcessingInstruction(target, data);
        this.currentNode.appendChild(pi);
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        Comment cm = this.checkDocument().createComment(new String(ch, start, length));
        this.currentNode.appendChild(cm);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.dt = this.domImplementation.createDocumentType(name, publicId, systemId);
        this.checkDocument();
    }

    public void endDTD() throws SAXException {
        this.dt = null;
    }

    public void endCDATA() throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
    }

    public void elementDecl(String name, String model) throws SAXException {
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        if (this.dt != null) {
            EntityReference er = this.checkDocument().createEntityReference(name);
            er.setNodeValue(value);
        }
    }

    static class PrefixMapping {
        public final String prefix;
        public final String uri;

        public PrefixMapping(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }
    }
}

