/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.CodingMode;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.core.AbstractEXIBodyEncoder;
import com.siemens.ct.exi.core.container.ValueAndDatatype;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.io.channel.ByteEncoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class EXIBodyEncoderReordered
extends AbstractEXIBodyEncoder {
    protected OutputStream os;
    protected Deflater deflater;
    protected DeflaterOutputStream deflaterOS;
    protected CodingMode codingMode;
    protected int blockValues;
    protected Value lastValue;
    protected Datatype lastDatatype;
    protected Map<QNameContext, List<ValueAndDatatype>> channelValuesAndDatatypes;

    public EXIBodyEncoderReordered(EXIFactory exiFactory) throws EXIException {
        super(exiFactory);
        this.codingMode = exiFactory.getCodingMode();
        this.channelValuesAndDatatypes = new LinkedHashMap<QNameContext, List<ValueAndDatatype>>();
    }

    protected void initForEachRun() throws EXIException, IOException {
        super.initForEachRun();
        this.blockValues = 0;
        this.channelValuesAndDatatypes.clear();
    }

    protected void initBlock() {
        this.blockValues = 0;
        this.channelValuesAndDatatypes.clear();
    }

    protected void addValueAndDatatype(QNameContext qnc, ValueAndDatatype vd) {
        List<ValueAndDatatype> vds = this.channelValuesAndDatatypes.get(qnc);
        if (vds == null) {
            vds = new ArrayList<ValueAndDatatype>();
            this.channelValuesAndDatatypes.put(qnc, vds);
        }
        vds.add(vd);
    }

    public void setOutputStream(OutputStream os) throws EXIException, IOException {
        this.os = os;
        this.channel = new ByteEncoderChannel(this.getStream());
    }

    public void setOutputChannel(EncoderChannel encoderChannel) {
        this.channel = encoderChannel;
        this.os = this.channel.getOutputStream();
    }

    protected boolean isTypeValid(Datatype datatype, Value value) {
        this.lastDatatype = datatype;
        this.lastValue = value;
        return super.isTypeValid(datatype, value);
    }

    protected void writeValue(QNameContext valueContext) throws IOException {
        this.addValueAndDatatype(valueContext, new ValueAndDatatype(this.lastValue, this.lastDatatype));
        if (++this.blockValues == this.exiFactory.getBlockSize()) {
            this.closeBlock();
            this.initBlock();
            this.channel = new ByteEncoderChannel(this.getStream());
        }
    }

    protected OutputStream getStream() {
        if (this.codingMode == CodingMode.COMPRESSION) {
            if (this.deflater == null) {
                this.deflater = new Deflater(this.codingMode.getDeflateLevel(), true);
            } else {
                this.deflater.reset();
            }
            this.deflaterOS = new DeflaterOutputStream(this.os, this.deflater);
            return this.deflaterOS;
        }
        assert (this.codingMode == CodingMode.PRE_COMPRESSION);
        return this.os;
    }

    protected void closeBlock() throws IOException {
        if (this.channel.getLength() != 0) {
            if (this.blockValues <= 100) {
                for (QNameContext contextOrder : this.channelValuesAndDatatypes.keySet()) {
                    List<ValueAndDatatype> lvd = this.channelValuesAndDatatypes.get(contextOrder);
                    for (int i = 0; i < lvd.size(); ++i) {
                        ValueAndDatatype vd = lvd.get(i);
                        this.typeEncoder.isValid(vd.datatype, vd.value);
                        this.typeEncoder.writeValue(contextOrder, this.channel, this.stringEncoder);
                    }
                }
                this.finalizeStream();
            } else {
                List<ValueAndDatatype> lvd;
                this.finalizeStream();
                ByteEncoderChannel leq100 = new ByteEncoderChannel(this.getStream());
                boolean wasThereLeq100 = false;
                for (QNameContext contextOrder : this.channelValuesAndDatatypes.keySet()) {
                    lvd = this.channelValuesAndDatatypes.get(contextOrder);
                    if (lvd.size() > 100) continue;
                    for (int i = 0; i < lvd.size(); ++i) {
                        ValueAndDatatype vd = lvd.get(i);
                        this.typeEncoder.isValid(vd.datatype, vd.value);
                        this.typeEncoder.writeValue(contextOrder, leq100, this.stringEncoder);
                    }
                    wasThereLeq100 = true;
                }
                if (wasThereLeq100) {
                    this.finalizeStream();
                }
                for (QNameContext contextOrder : this.channelValuesAndDatatypes.keySet()) {
                    lvd = this.channelValuesAndDatatypes.get(contextOrder);
                    if (lvd.size() <= 100) continue;
                    ByteEncoderChannel gre100 = new ByteEncoderChannel(this.getStream());
                    for (int i = 0; i < lvd.size(); ++i) {
                        ValueAndDatatype vd = lvd.get(i);
                        this.typeEncoder.isValid(vd.datatype, vd.value);
                        this.typeEncoder.writeValue(contextOrder, gre100, this.stringEncoder);
                    }
                    this.finalizeStream();
                }
            }
        }
    }

    protected void finalizeStream() throws IOException {
        if (this.codingMode == CodingMode.COMPRESSION) {
            this.deflaterOS.finish();
        }
    }

    public void flush() throws IOException {
        this.closeBlock();
        this.os.flush();
    }
}

