/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.strings;

import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.strings.AbstractStringCoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.values.StringValue;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class StringEncoderImpl
extends AbstractStringCoder
implements StringEncoder {
    protected Map<String, ValueContainer> stringValues = new HashMap<String, ValueContainer>();

    public StringEncoderImpl(boolean localValuePartitions) {
        this(localValuePartitions, 60);
    }

    public StringEncoderImpl(boolean localValuePartitions, int initialQNameLists) {
        super(localValuePartitions, initialQNameLists);
    }

    public void writeValue(QNameContext context, EncoderChannel valueChannel, String value) throws IOException {
        ValueContainer vc = this.stringValues.get(value);
        if (vc != null) {
            if (this.localValuePartitions && vc.context.equals(context)) {
                valueChannel.encodeUnsignedInteger(0);
                int numberBitsLocal = MethodsBag.getCodingLength(this.getNumberOfStringValues(context));
                valueChannel.encodeNBitUnsignedInteger(vc.localValueID, numberBitsLocal);
            } else {
                valueChannel.encodeUnsignedInteger(1);
                int numberBitsGlobal = MethodsBag.getCodingLength(this.stringValues.size());
                valueChannel.encodeNBitUnsignedInteger(vc.globalValueID, numberBitsGlobal);
            }
        } else {
            int L = value.codePointCount(0, value.length());
            valueChannel.encodeUnsignedInteger(L + 2);
            if (L > 0) {
                valueChannel.encodeStringOnly(value);
                this.addValue(context, value);
            }
        }
    }

    public boolean isStringHit(String value) throws IOException {
        return this.stringValues.get(value) != null;
    }

    public void addValue(QNameContext qnc, String value) {
        assert (!this.stringValues.containsKey(value));
        ValueContainer vc = new ValueContainer(value, qnc, this.getNumberOfStringValues(qnc), this.stringValues.size());
        this.stringValues.put(value, vc);
        this.addLocalValue(qnc, new StringValue(value));
    }

    public void clear() {
        super.clear();
        this.stringValues.clear();
    }

    static class ValueContainer {
        public final String value;
        public final QNameContext context;
        public final int localValueID;
        public final int globalValueID;

        public ValueContainer(String value, QNameContext context, int localValueID, int globalValueID) {
            this.value = value;
            this.context = context;
            this.localValueID = localValueID;
            this.globalValueID = globalValueID;
        }

        public String toString() {
            return "['" + this.value + "', " + this.context + "," + this.localValueID + "," + this.globalValueID + "]";
        }
    }
}

