/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.types;

import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.RestrictedCharacterSetDatatype;
import com.siemens.ct.exi.datatype.charset.XSDBase64CharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDBooleanCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDDateTimeCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDDecimalCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDDoubleCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDHexBinaryCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDIntegerCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDStringCharacterSet;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.types.AbstractTypeDecoder;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class LexicalTypeDecoder
extends AbstractTypeDecoder {
    protected RestrictedCharacterSetDatatype rcsBase64Binary = new RestrictedCharacterSetDatatype(new XSDBase64CharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsHexBinary = new RestrictedCharacterSetDatatype(new XSDHexBinaryCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsBoolean = new RestrictedCharacterSetDatatype(new XSDBooleanCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsDateTime = new RestrictedCharacterSetDatatype(new XSDDateTimeCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsDecimal = new RestrictedCharacterSetDatatype(new XSDDecimalCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsDouble = new RestrictedCharacterSetDatatype(new XSDDoubleCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsInteger = new RestrictedCharacterSetDatatype(new XSDIntegerCharacterSet(), null);
    protected RestrictedCharacterSetDatatype rcsString = new RestrictedCharacterSetDatatype(new XSDStringCharacterSet(), null);

    public LexicalTypeDecoder() throws EXIException {
        this(null, null);
    }

    public LexicalTypeDecoder(QName[] dtrMapTypes, QName[] dtrMapRepresentations) throws EXIException {
        super(dtrMapTypes, dtrMapRepresentations);
    }

    public Value readValue(Datatype datatype, QNameContext qnContext, DecoderChannel valueChannel, StringDecoder stringDecoder) throws IOException {
        Value val;
        if (this.dtrMapInUse) {
            datatype = this.getDtrDatatype(datatype);
        }
        switch (datatype.getDatatypeID()) {
            case exi_base64Binary: {
                val = this.rcsBase64Binary.readValue(qnContext, valueChannel, stringDecoder);
                break;
            }
            case exi_hexBinary: {
                val = this.rcsHexBinary.readValue(qnContext, valueChannel, stringDecoder);
                break;
            }
            case exi_boolean: {
                val = this.rcsBoolean.readValue(qnContext, valueChannel, stringDecoder);
                break;
            }
            case exi_dateTime: 
            case exi_time: 
            case exi_date: 
            case exi_gYearMonth: 
            case exi_gYear: 
            case exi_gMonthDay: 
            case exi_gDay: 
            case exi_gMonth: {
                val = this.rcsDateTime.readValue(qnContext, valueChannel, stringDecoder);
                break;
            }
            case exi_decimal: {
                val = this.rcsDecimal.readValue(qnContext, valueChannel, stringDecoder);
                break;
            }
            case exi_double: {
                val = this.rcsDouble.readValue(qnContext, valueChannel, stringDecoder);
                break;
            }
            case exi_integer: {
                val = this.rcsInteger.readValue(qnContext, valueChannel, stringDecoder);
                break;
            }
            case exi_string: {
                val = stringDecoder.readValue(qnContext, valueChannel);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return val;
    }
}

