/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.api.stream;

import com.siemens.ct.exi.EXIBodyDecoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.EXIStreamDecoder;
import com.siemens.ct.exi.api.stream.EmptyLocation;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.core.container.DocType;
import com.siemens.ct.exi.core.container.NamespaceDeclaration;
import com.siemens.ct.exi.core.container.ProcessingInstruction;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammars.event.EventType;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StAXDecoder
implements XMLStreamReader {
    protected EXIFactory noOptionsFactory;
    protected EXIStreamDecoder exiStream;
    protected EXIBodyDecoder decoder;
    protected boolean exiBodyOnly = false;
    protected QNameContext element;
    protected List<AttributeContainer> attributes;
    protected Value characters;
    protected DocType docType;
    protected char[] entityReference;
    protected char[] comment;
    protected ProcessingInstruction processingInstruction;
    protected boolean namespacePrefixes = false;
    protected EventType eventType;
    protected EventType preReadEventType;
    protected EXINamespaceContext nsContext;
    String endElementPrefix;

    public StAXDecoder(EXIFactory noOptionsFactory) throws EXIException {
        this.noOptionsFactory = noOptionsFactory;
        this.exiStream = new EXIStreamDecoder(noOptionsFactory);
        this.attributes = new ArrayList<AttributeContainer>();
        this.nsContext = new EXINamespaceContext();
    }

    public void setInputStream(InputStream is) throws EXIException, IOException, XMLStreamException {
        this.parseHeader(is);
    }

    protected void initForEachRun() {
        this.eventType = null;
        this.preReadEventType = null;
        this.attributes.clear();
        if (this.noOptionsFactory.getFidelityOptions().isFidelityEnabled("PRESERVE_PREFIXES")) {
            this.namespacePrefixes = true;
        }
    }

    protected void parseHeader(InputStream is) throws EXIException, IOException, XMLStreamException {
        assert (is != null);
        assert (this.exiStream != null);
        this.decoder = this.exiBodyOnly ? this.exiStream.getBodyOnlyDecoder(is) : this.exiStream.decodeHeader(is);
        this.initForEachRun();
        this.eventType = this.decoder.next();
        assert (this.eventType == EventType.START_DOCUMENT);
        this.decoder.decodeStartDocument();
    }

    public int getEventType() {
        return StAXDecoder.getEventType(this.eventType);
    }

    protected static int getEventType(EventType eventType) {
        assert (eventType != null);
        switch (eventType) {
            case START_DOCUMENT: {
                return 7;
            }
            case ATTRIBUTE_XSI_TYPE: 
            case ATTRIBUTE_XSI_NIL: 
            case ATTRIBUTE: 
            case ATTRIBUTE_NS: 
            case ATTRIBUTE_GENERIC: 
            case ATTRIBUTE_INVALID_VALUE: 
            case ATTRIBUTE_ANY_INVALID_VALUE: 
            case ATTRIBUTE_GENERIC_UNDECLARED: {
                return 10;
            }
            case START_ELEMENT: 
            case START_ELEMENT_NS: 
            case START_ELEMENT_GENERIC: 
            case START_ELEMENT_GENERIC_UNDECLARED: {
                return 1;
            }
            case END_ELEMENT: 
            case END_ELEMENT_UNDECLARED: {
                return 2;
            }
            case CHARACTERS: 
            case CHARACTERS_GENERIC: 
            case CHARACTERS_GENERIC_UNDECLARED: {
                return 4;
            }
            case END_DOCUMENT: {
                return 8;
            }
            case DOC_TYPE: {
                return 11;
            }
            case NAMESPACE_DECLARATION: {
                return 13;
            }
            case SELF_CONTAINED: {
                return -1;
            }
            case ENTITY_REFERENCE: {
                return 9;
            }
            case COMMENT: {
                return 5;
            }
            case PROCESSING_INSTRUCTION: {
                return 3;
            }
        }
        throw new RuntimeException("Unexpected EXI Event '" + (Object)((Object)eventType) + "' ");
    }

    public int next() throws XMLStreamException {
        try {
            if (this.preReadEventType == null) {
                this.eventType = this.decodeEvent(this.decoder.next());
            } else {
                this.eventType = this.preReadEventType;
                this.preReadEventType = null;
                this.decodeEvent(this.eventType);
            }
            int ev = this.getEventType();
            if (ev == 1) {
                this.handleAttributes();
            }
            return ev;
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    protected EventType decodeEvent(EventType nextEventType) throws EXIException, IOException {
        this.endElementPrefix = null;
        switch (nextEventType) {
            case START_DOCUMENT: {
                this.decoder.decodeStartDocument();
                break;
            }
            case END_DOCUMENT: {
                this.decoder.decodeEndDocument();
                break;
            }
            case ATTRIBUTE_XSI_NIL: {
                this.attributes.add(new AttributeContainer(this.decoder.decodeAttributeXsiNil(), this.decoder.getAttributeValue(), this.decoder.getAttributePrefix()));
                break;
            }
            case ATTRIBUTE_XSI_TYPE: {
                this.attributes.add(new AttributeContainer(this.decoder.decodeAttributeXsiType(), this.decoder.getAttributeValue(), this.decoder.getAttributePrefix()));
                break;
            }
            case ATTRIBUTE: 
            case ATTRIBUTE_NS: 
            case ATTRIBUTE_GENERIC: 
            case ATTRIBUTE_INVALID_VALUE: 
            case ATTRIBUTE_ANY_INVALID_VALUE: 
            case ATTRIBUTE_GENERIC_UNDECLARED: {
                this.attributes.add(new AttributeContainer(this.decoder.decodeAttribute(), this.decoder.getAttributeValue(), this.decoder.getAttributePrefix()));
                break;
            }
            case NAMESPACE_DECLARATION: {
                this.decoder.decodeNamespaceDeclaration();
                break;
            }
            case SELF_CONTAINED: {
                this.decoder.decodeStartSelfContainedFragment();
                break;
            }
            case START_ELEMENT: 
            case START_ELEMENT_NS: 
            case START_ELEMENT_GENERIC: 
            case START_ELEMENT_GENERIC_UNDECLARED: {
                this.element = this.decoder.decodeStartElement();
                break;
            }
            case END_ELEMENT: 
            case END_ELEMENT_UNDECLARED: {
                this.endElementPrefix = this.decoder.getElementPrefix();
                this.element = this.decoder.decodeEndElement();
                break;
            }
            case CHARACTERS: 
            case CHARACTERS_GENERIC: 
            case CHARACTERS_GENERIC_UNDECLARED: {
                this.characters = this.decoder.decodeCharacters();
                break;
            }
            case DOC_TYPE: {
                this.docType = this.decoder.decodeDocType();
                break;
            }
            case ENTITY_REFERENCE: {
                this.entityReference = this.decoder.decodeEntityReference();
                break;
            }
            case COMMENT: {
                this.comment = this.decoder.decodeComment();
                break;
            }
            case PROCESSING_INSTRUCTION: {
                this.processingInstruction = this.decoder.decodeProcessingInstruction();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected EXI Event '" + (Object)((Object)this.eventType) + "' ");
            }
        }
        return nextEventType;
    }

    public void close() throws XMLStreamException {
    }

    protected void handleAttributes() throws EXIException, IOException {
        int ev;
        EventType et;
        assert (this.getEventType() == 1);
        this.attributes.clear();
        do {
            et = this.decoder.next();
            ev = StAXDecoder.getEventType(et);
            if (et != EventType.SELF_CONTAINED && ev != 10 && ev != 13) continue;
            this.decodeEvent(et);
        } while (et == EventType.SELF_CONTAINED || ev == 10 || ev == 13);
        this.preReadEventType = et;
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String getAttributeLocalName(int index) {
        return this.attributes.get((int)index).qname.getLocalName();
    }

    public QName getAttributeName(int index) {
        return this.attributes.get((int)index).qname.getQName();
    }

    public String getAttributeNamespace(int index) {
        return this.attributes.get((int)index).qname.getNamespaceUri();
    }

    public String getAttributePrefix(int index) {
        return this.attributes.get((int)index).prefix;
    }

    public String getAttributeType(int index) {
        return "CDATA";
    }

    public String getAttributeValue(int index) {
        return this.attributes.get((int)index).value.toString();
    }

    public String getAttributeValue(String namespaceURI, String localName) {
        for (AttributeContainer ac : this.attributes) {
            if (!ac.qname.getLocalName().equals(localName)) continue;
            if (namespaceURI == null) {
                return ac.value.toString();
            }
            if (!ac.qname.getNamespaceUri().equals(namespaceURI)) continue;
            return ac.value.toString();
        }
        return null;
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public String getElementText() throws XMLStreamException {
        switch (this.getEventType()) {
            case 4: 
            case 6: {
                return this.characters.toString();
            }
        }
        throw new RuntimeException("Unexpected event, id=" + this.getEventType());
    }

    public String getEncoding() {
        return null;
    }

    public String getLocalName() {
        return this.element.getLocalName();
    }

    public Location getLocation() {
        return EmptyLocation.getInstance();
    }

    public QName getName() {
        QName qn = new QName(this.element.getNamespaceUri(), this.element.getLocalName(), this.getPrefix());
        return qn;
    }

    public NamespaceContext getNamespaceContext() {
        this.nsContext.setNamespaceDeclarations(this.decoder.getDeclaredPrefixDeclarations());
        return this.nsContext;
    }

    public int getNamespaceCount() {
        List<NamespaceDeclaration> nsDecls = this.decoder.getDeclaredPrefixDeclarations();
        return nsDecls == null ? 0 : nsDecls.size();
    }

    public String getNamespacePrefix(int index) {
        return this.decoder.getDeclaredPrefixDeclarations().get((int)index).prefix;
    }

    public String getNamespaceURI(int index) {
        return this.decoder.getDeclaredPrefixDeclarations().get((int)index).namespaceURI;
    }

    public String getNamespaceURI(String prefix) {
        List<NamespaceDeclaration> nsDecls = this.decoder.getDeclaredPrefixDeclarations();
        for (int i = 0; i < nsDecls.size(); ++i) {
            NamespaceDeclaration nsDecl = nsDecls.get(i);
            if (!nsDecl.prefix.equals(prefix)) continue;
            return nsDecl.namespaceURI;
        }
        return null;
    }

    public String getNamespaceURI() {
        return this.element.getNamespaceUri();
    }

    public String getPIData() {
        return this.processingInstruction.data;
    }

    public String getPITarget() {
        return this.processingInstruction.target;
    }

    public String getPrefix() {
        if (this.endElementPrefix != null) {
            return this.endElementPrefix;
        }
        if (this.getEventType() == 1 || this.getEventType() == 2) {
            return this.decoder.getElementPrefix();
        }
        assert (this.getEventType() == 10);
        return this.decoder.getAttributePrefix();
    }

    public Object getProperty(String arg0) throws IllegalArgumentException {
        return null;
    }

    public String getText() {
        switch (this.getEventType()) {
            case 4: 
            case 6: {
                return this.characters.toString();
            }
            case 5: {
                return new String(this.comment);
            }
            case 9: {
                return new String(this.entityReference);
            }
            case 11: {
                return this.getDocTypeString();
            }
        }
        throw new RuntimeException("Unexpected event, id=" + this.getEventType());
    }

    private String getDocTypeString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE ");
        sb.append(this.docType.name);
        if (this.docType.publicID.length > 0) {
            sb.append(" PUBLIC ");
            sb.append('\"');
            sb.append(this.docType.publicID);
            sb.append('\"');
        }
        if (this.docType.systemID.length > 0) {
            if (this.docType.publicID.length == 0) {
                sb.append(" SYSTEM ");
            } else {
                sb.append(' ');
            }
            sb.append('\"');
            sb.append(this.docType.systemID);
            sb.append('\"');
        }
        if (this.docType.text.length > 0) {
            sb.append(' ');
            sb.append('[');
            sb.append(this.docType.text);
            sb.append(']');
        }
        sb.append('>');
        return sb.toString();
    }

    public char[] getTextCharacters() {
        switch (this.getEventType()) {
            case 4: 
            case 6: {
                return this.characters.toString().toCharArray();
            }
            case 5: {
                return this.comment;
            }
            case 9: {
                return this.entityReference;
            }
            case 11: {
                return this.getDocTypeString().toCharArray();
            }
        }
        throw new RuntimeException("Unexpected event, id=" + this.getEventType());
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (this.getTextLength() > target.length - targetStart) {
            throw new RuntimeException("Buffer too small!");
        }
        switch (this.getEventType()) {
            case 4: 
            case 6: {
                this.characters.getCharacters(target, targetStart);
                return length;
            }
            case 5: {
                System.arraycopy(this.comment, sourceStart, target, targetStart, length);
                return length;
            }
            case 9: {
                System.arraycopy(this.entityReference, sourceStart, target, targetStart, length);
                return length;
            }
            case 11: {
                char[] dt = this.getDocTypeString().toCharArray();
                System.arraycopy(dt, sourceStart, target, targetStart, length);
                return length;
            }
        }
        throw new RuntimeException("Unexpected event, id=" + this.getEventType());
    }

    public int getTextLength() {
        switch (this.getEventType()) {
            case 4: 
            case 6: {
                return this.characters.getCharactersLength();
            }
            case 5: {
                return this.comment.length;
            }
            case 9: {
                return this.entityReference.length;
            }
        }
        throw new RuntimeException("Unexpected event, id=" + this.getEventType());
    }

    public int getTextStart() {
        return 0;
    }

    public String getVersion() {
        return null;
    }

    public boolean hasName() {
        switch (this.getEventType()) {
            case 1: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.eventType != EventType.END_DOCUMENT;
    }

    public boolean hasText() {
        switch (this.getEventType()) {
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public boolean isAttributeSpecified(int arg0) {
        return false;
    }

    public boolean isCharacters() {
        return this.getEventType() == 4;
    }

    public boolean isEndElement() {
        return this.getEventType() == 2;
    }

    public boolean isStandalone() {
        return true;
    }

    public boolean isStartElement() {
        return this.getEventType() == 1;
    }

    public boolean isWhiteSpace() {
        switch (this.getEventType()) {
            case 4: {
                return this.characters.toString().trim().length() == 0;
            }
            case 12: {
                return false;
            }
            case 5: {
                return false;
            }
            case 6: {
                return true;
            }
        }
        return false;
    }

    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        int eventType = this.getEventType();
        if (eventType == type) {
            switch (eventType) {
                case 1: {
                    if (namespaceURI != null && !this.element.getNamespaceUri().equals(namespaceURI)) {
                        throw new XMLStreamException();
                    }
                    if (localName == null || this.element.getLocalName().equals(localName)) break;
                    throw new XMLStreamException();
                }
                case 10: {
                    throw new XMLStreamException();
                }
            }
        } else {
            throw new XMLStreamException();
        }
    }

    public boolean standaloneSet() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EXINamespaceContext
    implements NamespaceContext {
        List<NamespaceDeclaration> _nsDecls;

        EXINamespaceContext() {
        }

        protected void setNamespaceDeclarations(List<NamespaceDeclaration> nsDecls) {
            this._nsDecls = nsDecls;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (this._nsDecls != null) {
                for (int i = 0; i < this._nsDecls.size(); ++i) {
                    NamespaceDeclaration nsDecl = this._nsDecls.get(i);
                    if (!nsDecl.prefix.equals(prefix)) continue;
                    return nsDecl.namespaceURI;
                }
            }
            return null;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            if (this._nsDecls != null) {
                for (int i = 0; i < this._nsDecls.size(); ++i) {
                    NamespaceDeclaration nsDecl = this._nsDecls.get(i);
                    if (!nsDecl.namespaceURI.equals(namespaceURI)) continue;
                    return nsDecl.prefix;
                }
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            ArrayList<String> prefixes = new ArrayList<String>();
            if (this._nsDecls != null) {
                for (int i = 0; i < this._nsDecls.size(); ++i) {
                    NamespaceDeclaration nsDecl = this._nsDecls.get(i);
                    if (!nsDecl.namespaceURI.equals(namespaceURI)) continue;
                    prefixes.add(nsDecl.prefix);
                }
            }
            return prefixes.iterator();
        }
    }

    static class AttributeContainer {
        final QNameContext qname;
        final Value value;
        final String prefix;

        public AttributeContainer(QNameContext qname, Value value, String prefix) {
            this.qname = qname;
            this.value = value;
            this.prefix = prefix;
        }
    }
}

