/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammars.grammar;

import com.siemens.ct.exi.grammars.event.Attribute;
import com.siemens.ct.exi.grammars.event.AttributeNS;
import com.siemens.ct.exi.grammars.event.Event;
import com.siemens.ct.exi.grammars.event.EventType;
import com.siemens.ct.exi.grammars.event.StartElement;
import com.siemens.ct.exi.grammars.event.StartElementNS;
import com.siemens.ct.exi.grammars.grammar.AbstractGrammar;
import com.siemens.ct.exi.grammars.grammar.Grammar;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedGrammar;
import com.siemens.ct.exi.grammars.production.Production;
import com.siemens.ct.exi.grammars.production.SchemaInformedProduction;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.util.sort.LexicographicSort;
import java.util.ArrayList;

public abstract class AbstractSchemaInformedGrammar
extends AbstractGrammar
implements SchemaInformedGrammar {
    private static final long serialVersionUID = -5145919918050815021L;
    Production[] containers = new Production[0];
    protected int codeLengthA;
    protected int codeLengthB;
    protected boolean hasEndElement = false;
    protected int leastAttributeEventCode = -1;
    protected int numberOfDeclaredAttributes = 0;
    static final LexicographicSort lexSort = new LexicographicSort();

    public boolean hasEndElement() {
        return this.hasEndElement;
    }

    public AbstractSchemaInformedGrammar() {
        this.init();
    }

    public AbstractSchemaInformedGrammar(String label) {
        super(label);
        this.init();
    }

    protected final boolean isTerminalRule() {
        return this == END_RULE;
    }

    private void init() {
        this.containers = new Production[0];
    }

    public final boolean isSchemaInformed() {
        return true;
    }

    public int get1stLevelEventCodeLength(boolean withFidelityOptionsOrNonStrict) {
        return withFidelityOptionsOrNonStrict ? this.codeLengthB : this.codeLengthA;
    }

    public int getNumberOfDeclaredAttributes() {
        return this.numberOfDeclaredAttributes;
    }

    public int getLeastAttributeEventCode() {
        return this.leastAttributeEventCode;
    }

    public final int getNumberOfEvents() {
        return this.containers.length;
    }

    public void addProduction(Event event, Grammar grammar) {
        if (this.isTerminalRule()) {
            throw new IllegalArgumentException("EndGrammar can not have events attached");
        }
        if (!event.isEventType(EventType.END_ELEMENT) && !event.isEventType(EventType.ATTRIBUTE_GENERIC) && !event.isEventType(EventType.START_ELEMENT_GENERIC) || this.getProduction(event.getEventType()) == null) {
            if (event.isEventType(EventType.END_ELEMENT)) {
                this.hasEndElement = true;
            }
            for (int i = 0; i < this.containers.length; ++i) {
                Production ei = this.containers[i];
                if (!ei.getEvent().equals(event) || ei.getNextGrammar() == grammar) continue;
                throw new IllegalArgumentException("Same event " + event + " with indistinguishable 'next' grammar");
            }
            this.updateSortedEvents(event, grammar);
        }
    }

    protected void updateSortedEvents(Event newEvent, Grammar newGrammar) {
        int i;
        ArrayList<Event> sortedEvents = new ArrayList<Event>();
        Event o2 = newEvent;
        boolean added = false;
        for (int i2 = 0; i2 < this.containers.length; ++i2) {
            Production ei = this.containers[i2];
            Event o1 = ei.getEvent();
            if (!added) {
                int diff = o1.getEventType().ordinal() - o2.getEventType().ordinal();
                if (diff == 0) {
                    switch (o1.getEventType()) {
                        case ATTRIBUTE: {
                            int cmpA = lexSort.compare((Attribute)o1, (Attribute)o2);
                            if (cmpA < 0) break;
                            if (cmpA > 0) {
                                sortedEvents.add(o2);
                                added = true;
                                break;
                            }
                            assert (cmpA == 0);
                            throw new RuntimeException("Twice the same attribute name when sorting");
                        }
                        case ATTRIBUTE_NS: {
                            AttributeNS atNS1 = (AttributeNS)o1;
                            AttributeNS atNS2 = (AttributeNS)o2;
                            int cmpNS = atNS1.getNamespaceURI().compareTo(atNS2.getNamespaceURI());
                            if (cmpNS < 0) break;
                            if (cmpNS > 0) {
                                sortedEvents.add(o2);
                                added = true;
                                break;
                            }
                            assert (cmpNS == 0);
                            throw new RuntimeException("Twice the same attribute uri in AT(uri*) when sorting");
                        }
                        case START_ELEMENT: 
                        case START_ELEMENT_NS: {
                            break;
                        }
                        default: {
                            throw new RuntimeException("No valid event type for sorting");
                        }
                    }
                } else if (diff >= 0) {
                    assert (diff > 0);
                    sortedEvents.add(o2);
                    added = true;
                }
            }
            sortedEvents.add(o1);
        }
        if (!added) {
            sortedEvents.add(o2);
        }
        assert (sortedEvents.size() == this.containers.length + 1);
        Production[] newContainers = new Production[sortedEvents.size()];
        int eventCode = 0;
        boolean newOneAdded = false;
        for (i = 0; i < sortedEvents.size(); ++i) {
            Event ev = (Event)sortedEvents.get(i);
            if (ev == newEvent) {
                newContainers[eventCode] = new SchemaInformedProduction(newGrammar, newEvent, eventCode);
                newOneAdded = true;
            } else {
                Production oldEI = this.containers[newOneAdded ? eventCode - 1 : eventCode];
                newContainers[eventCode] = new SchemaInformedProduction(oldEI.getNextGrammar(), oldEI.getEvent(), eventCode);
            }
            ++eventCode;
        }
        this.containers = newContainers;
        this.codeLengthA = MethodsBag.getCodingLength(this.getNumberOfEvents());
        this.codeLengthB = MethodsBag.getCodingLength(this.getNumberOfEvents() + 1);
        this.leastAttributeEventCode = -1;
        this.numberOfDeclaredAttributes = 0;
        for (i = 0; i < this.containers.length; ++i) {
            Production er = this.containers[i];
            if (!er.getEvent().isEventType(EventType.ATTRIBUTE)) continue;
            if (this.leastAttributeEventCode == -1) {
                this.leastAttributeEventCode = i;
            }
            ++this.numberOfDeclaredAttributes;
        }
    }

    public void joinGrammars(Grammar rule) {
        for (int i = 0; i < rule.getNumberOfEvents(); ++i) {
            Production ei = rule.getProduction(i);
            this.addProduction(ei.getEvent(), ei.getNextGrammar());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.getNumberOfEvents(); ++i) {
            sb.append(this.getProduction(i).getEvent().toString());
            if (i >= this.getNumberOfEvents() - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    public SchemaInformedGrammar clone() {
        try {
            return (SchemaInformedGrammar)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public SchemaInformedGrammar duplicate() {
        return this.clone();
    }

    public Production getProduction(EventType eventType) {
        for (int i = 0; i < this.containers.length; ++i) {
            Production ei = this.containers[i];
            if (!ei.getEvent().isEventType(eventType)) continue;
            return ei;
        }
        return null;
    }

    public Production getStartElementProduction(String namespaceURI, String localName) {
        for (int i = 0; i < this.containers.length; ++i) {
            Production ei = this.containers[i];
            if (!ei.getEvent().isEventType(EventType.START_ELEMENT) || !AbstractSchemaInformedGrammar.checkQualifiedName(((StartElement)ei.getEvent()).getQName(), namespaceURI, localName)) continue;
            return ei;
        }
        return null;
    }

    public Production getStartElementNSProduction(String namespaceURI) {
        for (int i = 0; i < this.containers.length; ++i) {
            Production ei = this.containers[i];
            if (!ei.getEvent().isEventType(EventType.START_ELEMENT_NS) || !((StartElementNS)ei.getEvent()).getNamespaceURI().equals(namespaceURI)) continue;
            return ei;
        }
        return null;
    }

    public Production getAttributeProduction(String namespaceURI, String localName) {
        for (int i = 0; i < this.containers.length; ++i) {
            Production ei = this.containers[i];
            if (!ei.getEvent().isEventType(EventType.ATTRIBUTE) || !AbstractSchemaInformedGrammar.checkQualifiedName(((Attribute)ei.getEvent()).getQName(), namespaceURI, localName)) continue;
            return ei;
        }
        return null;
    }

    public Production getAttributeNSProduction(String namespaceURI) {
        for (int i = 0; i < this.containers.length; ++i) {
            Production ei = this.containers[i];
            if (!ei.getEvent().isEventType(EventType.ATTRIBUTE_NS) || !((AttributeNS)ei.getEvent()).getNamespaceURI().equals(namespaceURI)) continue;
            return ei;
        }
        return null;
    }

    public final Production getProduction(int eventCode) {
        assert (eventCode >= 0 && eventCode < this.containers.length);
        return this.containers[eventCode];
    }
}

