/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.grammars;

import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.common.EventType;
import org.openexi.proc.common.EventTypeList;
import org.openexi.proc.common.QName;
import org.openexi.proc.common.StringTable;
import org.openexi.proc.grammars.EventCodeTuple;
import org.openexi.proc.grammars.GrammarState;
import org.openexi.proc.grammars.ValueApparatus;
import org.openexi.schema.EXISchema;

public abstract class Apparatus {
    private static final short INIT_GRAMMARS_DEPTH = 32;
    public GrammarState currentState;
    protected GrammarState[] m_statesStack = new GrammarState[32];
    protected int m_n_stackedStates;
    public final EventType[] eventTypesWorkSpace;
    public StringTable stringTable;
    private static final short CODEC_NOT_A_CODEC = 0;
    public static final short CODEC_BASE64BINARY = 1;
    public static final short CODEC_HEXBINARY = 2;
    public static final short CODEC_BOOLEAN = 3;
    public static final short CODEC_DATETIME = 4;
    public static final short CODEC_TIME = 5;
    public static final short CODEC_DATE = 6;
    public static final short CODEC_GYEARMONTH = 7;
    public static final short CODEC_GYEAR = 8;
    public static final short CODEC_GMONTHDAY = 9;
    public static final short CODEC_GDAY = 10;
    public static final short CODEC_GMONTH = 11;
    public static final short CODEC_DECIMAL = 12;
    public static final short CODEC_DOUBLE = 13;
    public static final short CODEC_INTEGER = 14;
    public static final short CODEC_STRING = 15;
    public static final short CODEC_LIST = 16;
    public static final short CODEC_ENUMERATION = 17;
    protected static final short N_CODECS = 18;
    public static final short CODEC_LEXICAL = 18;
    private static final short[] defaultCodecTable = new short[22];
    public EXISchema schema;
    protected int[] m_types;
    protected short[] m_codecTable;
    protected int[] m_restrictedCharacterCountTable;
    protected boolean m_preserveLexicalValues;

    protected abstract ValueApparatus[] getValueApparatuses();

    public Apparatus() {
        this.currentState = this.m_statesStack[0] = new GrammarState(this);
        for (int i = 1; i < 32; ++i) {
            this.m_statesStack[i] = new GrammarState(this);
        }
        this.m_n_stackedStates = 1;
        this.eventTypesWorkSpace = new EventType[10];
        this.schema = null;
        this.m_types = null;
        this.m_codecTable = null;
        this.m_restrictedCharacterCountTable = null;
    }

    public void reset() {
        this.m_n_stackedStates = 1;
        this.currentState = this.m_statesStack[0];
        this.stringTable.reset();
    }

    public abstract AlignmentType getAlignmentType();

    public void setSchema(EXISchema eXISchema, QName[] qNameArray, int n) {
        this.schema = eXISchema;
        if (this.schema != null) {
            this.m_types = eXISchema.getTypes();
            this.updateCodecTable(qNameArray, n);
            this.updateSimpleTypeData();
        } else {
            this.m_types = null;
        }
    }

    public void setStringTable(StringTable stringTable) {
        this.stringTable = stringTable;
    }

    public void setPreserveLexicalValues(boolean bl) {
        this.m_preserveLexicalValues = bl;
    }

    public final boolean getPreserveLexicalValues() {
        return this.m_preserveLexicalValues;
    }

    public final void startDocument() {
        this.currentState.targetGrammar.startDocument(this.currentState);
    }

    public final EventTypeList getNextEventTypes() {
        return this.currentState.targetGrammar.getNextEventTypes(this.currentState);
    }

    public final EventCodeTuple getNextEventCodes() {
        return this.currentState.targetGrammar.getNextEventCodes(this.currentState);
    }

    public final void startElement(EventType eventType) {
        this.currentState.targetGrammar.element(eventType, this.currentState);
    }

    public final void startWildcardElement(int n, int n2, int n3) {
        this.currentState.targetGrammar.wildcardElement(n, n2, n3, this.currentState);
    }

    public final void xsitp(int n) {
        this.currentState.targetGrammar.xsitp(n, this.currentState);
    }

    public final void nillify(int n) {
        this.currentState.targetGrammar.nillify(n, this.currentState);
    }

    public final void attribute(EventType eventType) {
        this.currentState.targetGrammar.attribute(eventType, this.currentState);
    }

    public final void wildcardAttribute(int n, int n2, int n3) {
        this.currentState.targetGrammar.wildcardAttribute(n, n2, n3, this.currentState);
    }

    public final void characters(EventType eventType) {
        this.currentState.targetGrammar.chars(eventType, this.currentState);
    }

    public final void undeclaredCharacters(int n) {
        this.currentState.targetGrammar.undeclaredChars(n, this.currentState);
    }

    public final void miscContent(int n) {
        this.currentState.targetGrammar.miscContent(n, this.currentState);
    }

    public final void endElement() {
        this.currentState.targetGrammar.end(this.currentState);
        this.currentState = this.m_statesStack[--this.m_n_stackedStates - 1];
    }

    public final void endDocument() {
        assert (this.currentState.targetGrammar.grammarType == 2 || this.currentState.targetGrammar.grammarType == 3 || this.currentState.targetGrammar.grammarType == 1);
        this.currentState.targetGrammar.endDocument(this.currentState);
    }

    public final GrammarState peekState() {
        return this.m_statesStack[this.m_n_stackedStates - 1];
    }

    final GrammarState pushState() {
        int n = this.m_statesStack.length;
        if (n == this.m_n_stackedStates) {
            int n2 = 2 * n;
            GrammarState[] grammarStateArray = new GrammarState[n2];
            System.arraycopy(this.m_statesStack, 0, grammarStateArray, 0, n);
            for (int i = n; i < n2; ++i) {
                grammarStateArray[i] = new GrammarState(this);
            }
            this.m_statesStack = grammarStateArray;
        }
        this.currentState = this.m_statesStack[this.m_n_stackedStates++];
        return this.currentState;
    }

    private void updateCodecTable(QName[] qNameArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        assert (this.schema != null);
        int n6 = this.schema.getTotalSimpleTypeCount();
        if (this.m_codecTable == null || this.m_codecTable.length < n6 + 1) {
            this.m_codecTable = new short[n6 + 1];
        } else {
            n5 = this.m_codecTable.length;
            for (n4 = 0; n4 < n5; ++n4) {
                this.m_codecTable[n4] = 0;
            }
        }
        System.arraycopy(defaultCodecTable, 0, this.m_codecTable, 0, defaultCodecTable.length);
        n4 = n5 = this.schema.getBuiltinTypeOfSchema(1);
        int n7 = 1;
        while (n4 != -1) {
            if (this.m_codecTable[n7] == 0 && this.schema.getBaseTypeOfSimpleType(n4) == n5) {
                switch (this.schema.getVarietyOfSimpleType(n4)) {
                    case 2: {
                        this.m_codecTable[n7] = 16;
                        break;
                    }
                    case 3: {
                        this.m_codecTable[n7] = 15;
                    }
                }
            }
            n4 = this.schema.getNextSimpleType(n4);
            ++n7;
        }
        n7 = 2 * n;
        if (n7 != 0) {
            ValueApparatus[] valueApparatusArray = this.getValueApparatuses();
            block10: for (n3 = 0; n3 < n7; n3 += 2) {
                QName qName = qNameArray[n3];
                String string = qName.namespaceName;
                String string2 = qName.localName;
                n2 = this.schema.getTypeOfSchema(string, string2);
                if (n2 == -1 || !this.schema.isSimpleType(n2)) continue;
                QName qName2 = qNameArray[n3 + 1];
                for (ValueApparatus valueApparatus : valueApparatusArray) {
                    if (!qName2.equals(valueApparatus.getName())) continue;
                    short s = valueApparatus.getCodecID();
                    int n8 = this.schema.getSerialOfType(n2);
                    this.m_codecTable[n8] = s;
                    continue block10;
                }
            }
        }
        n4 = n5;
        int n9 = 1;
        while (n4 != -1) {
            block27: {
                if (this.m_codecTable[n9] == 0) {
                    int n10 = 0;
                    byte by = this.schema.getVarietyOfSimpleType(n4);
                    switch (by) {
                        case 1: 
                        case 2: 
                        case 3: {
                            int n11 = n4;
                            if (n10 == 0) {
                                while ((n10 = this.m_codecTable[this.schema.getSerialOfType(n11 = this.schema.getBaseTypeOfSimpleType(n11))]) == 0) {
                                }
                            }
                            if (by == 1) {
                                n2 = this.schema.ancestryIds[this.schema.getSerialOfType(n4)];
                                if (n2 != 19 && n2 != 20 && this.schema.getEnumerationFacetCountOfAtomicSimpleType(n4) != 0 && (n4 == n11 || this.schema.getEnumerationFacetCountOfAtomicSimpleType(n11) == 0)) {
                                    n10 = 17;
                                }
                            } else assert (n10 != 0);
                            n3 = n10;
                            break;
                        }
                        case 0: {
                            assert (false);
                            break block27;
                        }
                        default: {
                            assert (false);
                            n3 = 0;
                        }
                    }
                    this.m_codecTable[n9] = n3;
                }
            }
            n4 = this.schema.getNextSimpleType(n4);
            ++n9;
        }
    }

    private void updateSimpleTypeData() {
        int n = this.schema.getTotalSimpleTypeCount();
        if (this.m_restrictedCharacterCountTable == null || this.m_restrictedCharacterCountTable.length < n + 1) {
            this.m_restrictedCharacterCountTable = new int[n + 1];
        }
        int n2 = this.schema.getBuiltinTypeOfSchema(1);
        int n3 = 1;
        while (n2 != -1) {
            int n4 = this.schema.getSerialOfType(n2);
            assert (n4 == n3);
            this.m_restrictedCharacterCountTable[n3] = this.schema.ancestryIds[n4] == 2 ? this.schema.getRestrictedCharacterCountOfStringSimpleType(n2) : 0;
            n2 = this.schema.getNextSimpleType(n2);
            ++n3;
        }
    }

    static {
        Apparatus.defaultCodecTable[17] = 1;
        Apparatus.defaultCodecTable[16] = 2;
        Apparatus.defaultCodecTable[3] = 3;
        Apparatus.defaultCodecTable[8] = 4;
        Apparatus.defaultCodecTable[9] = 5;
        Apparatus.defaultCodecTable[10] = 6;
        Apparatus.defaultCodecTable[11] = 7;
        Apparatus.defaultCodecTable[12] = 8;
        Apparatus.defaultCodecTable[13] = 9;
        Apparatus.defaultCodecTable[14] = 10;
        Apparatus.defaultCodecTable[15] = 11;
        Apparatus.defaultCodecTable[4] = 12;
        Apparatus.defaultCodecTable[5] = 13;
        Apparatus.defaultCodecTable[6] = 13;
        Apparatus.defaultCodecTable[21] = 14;
        Apparatus.defaultCodecTable[2] = 15;
        Apparatus.defaultCodecTable[1] = 15;
    }
}

