/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.io.ByteAlignedCommons;
import org.openexi.proc.io.SimpleScriber;

public final class ByteAlignedScriber
extends SimpleScriber {
    public ByteAlignedScriber() {
        super(false);
    }

    public AlignmentType getAlignmentType() {
        return AlignmentType.byteAligned;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.m_outputStream = outputStream;
    }

    protected void writeUnsignedInteger32(int n, OutputStream outputStream) throws IOException {
        ByteAlignedCommons.writeUnsignedInteger32(n, this.m_outputStream);
    }

    protected void writeUnsignedInteger64(long l, OutputStream outputStream) throws IOException {
        ByteAlignedCommons.writeUnsignedInteger64(l, this.m_outputStream);
    }

    protected void writeUnsignedInteger(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        ByteAlignedCommons.writeUnsignedInteger(bigInteger, this.m_outputStream);
    }

    protected void writeBoolean(boolean bl, OutputStream outputStream) throws IOException {
        this.m_outputStream.write(bl ? 1 : 0);
    }

    protected void writeNBitUnsigned(int n, int n2, OutputStream outputStream) throws IOException {
        ByteAlignedCommons.writeNBitUnsigned(n, n2, this.m_outputStream);
    }

    public void finish() throws IOException {
        this.m_outputStream.flush();
    }
}

