/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.scomp;

import java.math.BigInteger;
import java.util.HashMap;
import javax.xml.datatype.Duration;
import org.openexi.schema.EXISchemaConst;
import org.openexi.schema.XSDateTime;

abstract class EXISchemaStruct {
    protected int[] m_elems;
    protected int[] m_attrs;
    protected int[] m_types;
    protected String[] m_uris;
    protected String[] m_names;
    protected int[][] m_localNames;
    protected String[] m_strings;
    protected int[] m_ints;
    protected long[] m_mantissas;
    protected int[] m_exponents;
    protected boolean[] m_signs;
    protected String[] m_integralDigits;
    protected String[] m_reverseFractionalDigits;
    protected BigInteger[] m_integers;
    protected long[] m_longs;
    protected XSDateTime[] m_datetimes;
    protected Duration[] m_durations;
    protected byte[][] m_binaries;
    protected byte[] m_variantTypes;
    protected int[] m_variants;
    protected int[] m_grammars;
    protected int[] m_productions;
    protected byte[] m_eventTypes;
    protected int[] m_eventData;
    protected int m_n_elems;
    protected int m_n_attrs;
    protected int m_n_types;
    protected int m_n_uris;
    protected int m_n_names;
    protected int m_n_strings;
    protected int m_n_ints;
    protected int m_n_floats;
    protected int m_n_decimals;
    protected int m_n_integers;
    protected int m_n_longs;
    protected int m_n_datetimes;
    protected int m_n_durations;
    protected int m_n_binaries;
    protected int m_n_qnames;
    protected int m_n_lists;
    protected int m_n_variants;
    protected int m_n_grammars;
    protected int m_n_productions;
    protected int m_n_events;
    protected int m_n_stypes;
    protected int m_grammarCount;
    private final HashMap<Integer, Integer> m_eventMap = new HashMap();
    private static final int NODES_INITIAL = 1024;
    private static final int GRAMMARS_INITIAL = 1024;
    private static final int PRODUCTIONS_INITIAL = 1024;
    private static final int EVENTS_INITIAL = 1024;
    private static final int URIS_INITIAL = 16;
    private static final int URIS_INCREMENT = 16;
    private static final int NAMES_INITIAL = 1024;
    private static final int NAMES_INCREMENT = 1024;
    private static final int VALUES_INITIAL = 1024;
    private static final int VALUES_INCREMENT = 1024;
    protected static String[] INITIAL_URI_ENTRIES = new String[]{"", "http://www.w3.org/XML/1998/namespace", "http://www.w3.org/2001/XMLSchema-instance", "http://www.w3.org/2001/XMLSchema"};
    private static final BigInteger INT_MIN_VALUE = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);

    protected EXISchemaStruct() {
    }

    protected void reset() {
        int n;
        this.clear();
        this.m_elems = new int[1024];
        this.m_attrs = new int[1024];
        this.m_types = new int[1024];
        this.m_grammars = new int[1024];
        this.m_productions = new int[1024];
        this.m_eventTypes = new byte[1024];
        this.m_eventData = new int[1024];
        this.m_uris = new String[16];
        this.m_names = new String[1024];
        this.m_strings = new String[1024];
        this.m_ints = new int[1024];
        this.m_mantissas = new long[1024];
        this.m_exponents = new int[1024];
        this.m_signs = new boolean[1024];
        this.m_integralDigits = new String[1024];
        this.m_reverseFractionalDigits = new String[1024];
        this.m_integers = new BigInteger[1024];
        this.m_longs = new long[1024];
        this.m_datetimes = new XSDateTime[1024];
        this.m_durations = new Duration[1024];
        this.m_binaries = new byte[1024][];
        this.m_variantTypes = new byte[1024];
        this.m_variants = new int[1024];
        this.m_n_elems = 0;
        this.m_n_attrs = 0;
        this.m_n_types = 0;
        this.m_n_grammars = 0;
        this.m_n_productions = 0;
        this.m_n_events = 0;
        this.m_n_uris = 0;
        this.m_n_names = 0;
        this.m_n_strings = 0;
        this.m_n_ints = 0;
        this.m_n_floats = 0;
        this.m_n_decimals = 0;
        this.m_n_integers = 0;
        this.m_n_longs = 0;
        this.m_n_datetimes = 0;
        this.m_n_durations = 0;
        this.m_n_binaries = 0;
        this.m_n_qnames = 0;
        this.m_n_lists = 0;
        this.m_n_variants = 0;
        this.m_n_stypes = 0;
        this.m_grammarCount = 0;
        for (n = 0; n < INITIAL_URI_ENTRIES.length; ++n) {
            this.m_uris[this.m_n_uris++] = INITIAL_URI_ENTRIES[n];
        }
        this.m_names[this.m_n_names++] = "";
        for (n = 0; n < EXISchemaConst.XML_LOCALNAMES.length; ++n) {
            this.m_names[this.m_n_names++] = EXISchemaConst.XML_LOCALNAMES[n];
        }
        for (n = 0; n < EXISchemaConst.XSI_LOCALNAMES.length; ++n) {
            this.m_names[this.m_n_names++] = EXISchemaConst.XSI_LOCALNAMES[n];
        }
        for (n = 0; n < EXISchemaConst.XSD_LOCALNAMES.length; ++n) {
            this.m_names[this.m_n_names++] = EXISchemaConst.XSD_LOCALNAMES[n];
        }
        assert (this.m_n_strings == 0);
        this.m_strings[0] = "";
        ++this.m_n_strings;
    }

    protected void clear() {
        this.m_elems = null;
        this.m_attrs = null;
        this.m_types = null;
        this.m_grammars = null;
        this.m_productions = null;
        this.m_eventTypes = null;
        this.m_eventData = null;
        this.m_uris = null;
        this.m_names = null;
        this.m_localNames = null;
        this.m_strings = null;
        this.m_ints = null;
        this.m_mantissas = null;
        this.m_exponents = null;
        this.m_signs = null;
        this.m_integralDigits = null;
        this.m_reverseFractionalDigits = null;
        this.m_integers = null;
        this.m_longs = null;
        this.m_datetimes = null;
        this.m_durations = null;
        this.m_binaries = null;
        this.m_variantTypes = null;
        this.m_variants = null;
        this.m_eventMap.clear();
    }

    protected final void ensureElems(int n) {
        while (this.m_n_elems + n > this.m_elems.length) {
            int[] nArray = new int[2 * this.m_elems.length];
            System.arraycopy(this.m_elems, 0, nArray, 0, this.m_elems.length);
            this.m_elems = nArray;
        }
    }

    protected final void ensureAttrs(int n) {
        while (this.m_n_attrs + n > this.m_attrs.length) {
            int[] nArray = new int[2 * this.m_attrs.length];
            System.arraycopy(this.m_attrs, 0, nArray, 0, this.m_attrs.length);
            this.m_attrs = nArray;
        }
    }

    protected final void ensureTypes(int n) {
        while (this.m_n_types + n > this.m_types.length) {
            int[] nArray = new int[2 * this.m_types.length];
            System.arraycopy(this.m_types, 0, nArray, 0, this.m_types.length);
            this.m_types = nArray;
        }
    }

    protected final void ensureVariants() {
        this.ensureVariants(1);
    }

    protected final void ensureVariants(int n) {
        while (this.m_n_variants + n > this.m_variants.length) {
            byte[] byArray = new byte[this.m_variantTypes.length + 1024];
            int[] nArray = new int[this.m_variants.length + 1024];
            System.arraycopy(this.m_variantTypes, 0, byArray, 0, this.m_variantTypes.length);
            System.arraycopy(this.m_variants, 0, nArray, 0, this.m_variants.length);
            this.m_variantTypes = byArray;
            this.m_variants = nArray;
        }
    }

    protected final int indexOfUri(String string) {
        for (int i = 0; i < this.m_n_uris; ++i) {
            if (!string.equals(this.m_uris[i])) continue;
            return i;
        }
        return -1;
    }

    protected final int internUri(String string) {
        int n = this.indexOfUri(string);
        if (n != -1) {
            return n;
        }
        if (this.m_n_uris == this.m_uris.length) {
            String[] stringArray = new String[this.m_uris.length + 16];
            System.arraycopy(this.m_uris, 0, stringArray, 0, this.m_uris.length);
            this.m_uris = stringArray;
        }
        this.m_uris[this.m_n_uris] = string;
        return this.m_n_uris++;
    }

    protected final int indexOfLocalName(String string, int n) {
        int[] nArray = this.m_localNames[n];
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.m_names[nArray[i]].equals(string)) continue;
            return i;
        }
        return -1;
    }

    protected final int indexOfName(String string) {
        for (int i = 0; i < this.m_n_names; ++i) {
            if (!string.equals(this.m_names[i])) continue;
            return i;
        }
        return -1;
    }

    protected final int internName(String string) {
        int n = this.indexOfName(string);
        if (n != -1) {
            return n;
        }
        if (this.m_n_names >= this.m_names.length) {
            String[] stringArray = new String[this.m_names.length + 1024];
            System.arraycopy(this.m_names, 0, stringArray, 0, this.m_names.length);
            this.m_names = stringArray;
        }
        this.m_names[this.m_n_names] = string;
        return this.m_n_names++;
    }

    protected final int addStringValue(String string) {
        int n = -1;
        if (string != null) {
            if (string.length() == 0) {
                return 0;
            }
            if (this.m_n_strings >= this.m_strings.length) {
                String[] stringArray = new String[this.m_strings.length + 1024];
                System.arraycopy(this.m_strings, 0, stringArray, 0, this.m_strings.length);
                this.m_strings = stringArray;
            }
            this.m_strings[this.m_n_strings] = string;
            n = this.m_n_strings++;
        }
        return n;
    }

    protected final int addIntValue(int n) {
        int n2 = -1;
        if (this.m_n_ints >= this.m_ints.length) {
            int[] nArray = new int[this.m_ints.length + 1024];
            System.arraycopy(this.m_ints, 0, nArray, 0, this.m_ints.length);
            this.m_ints = nArray;
        }
        this.m_ints[this.m_n_ints] = n;
        n2 = this.m_n_ints++;
        return n2;
    }

    protected final int addFloatValue(long l, int n) {
        int n2 = -1;
        if (this.m_n_floats == this.m_mantissas.length) {
            int n3 = this.m_n_floats + 1024;
            long[] lArray = new long[n3];
            System.arraycopy(this.m_mantissas, 0, lArray, 0, this.m_n_floats);
            this.m_mantissas = lArray;
            int[] nArray = new int[n3];
            System.arraycopy(this.m_exponents, 0, nArray, 0, this.m_n_floats);
            this.m_exponents = nArray;
        }
        this.m_mantissas[this.m_n_floats] = l;
        this.m_exponents[this.m_n_floats] = n;
        n2 = this.m_n_floats++;
        return n2;
    }

    protected final int addDecimalValue(boolean bl, String string, String string2) {
        int n = -1;
        if (this.m_n_decimals >= this.m_signs.length) {
            int n2 = this.m_n_decimals + 1024;
            boolean[] blArray = new boolean[n2];
            System.arraycopy(this.m_signs, 0, blArray, 0, this.m_n_decimals);
            this.m_signs = blArray;
            String[] stringArray = new String[n2];
            System.arraycopy(this.m_integralDigits, 0, stringArray, 0, this.m_n_decimals);
            this.m_integralDigits = stringArray;
            String[] stringArray2 = new String[n2];
            System.arraycopy(this.m_reverseFractionalDigits, 0, stringArray2, 0, this.m_n_decimals);
            this.m_reverseFractionalDigits = stringArray2;
        }
        this.m_signs[this.m_n_decimals] = bl;
        this.m_integralDigits[this.m_n_decimals] = string;
        this.m_reverseFractionalDigits[this.m_n_decimals] = string2;
        n = this.m_n_decimals++;
        return n;
    }

    protected final int addIntegerValue(BigInteger bigInteger) {
        int n = -1;
        if (bigInteger != null) {
            if (this.m_n_integers >= this.m_integers.length) {
                BigInteger[] bigIntegerArray = new BigInteger[this.m_integers.length + 1024];
                System.arraycopy(this.m_integers, 0, bigIntegerArray, 0, this.m_integers.length);
                this.m_integers = bigIntegerArray;
            }
            this.m_integers[this.m_n_integers] = bigInteger;
            n = this.m_n_integers++;
        }
        return n;
    }

    protected final int addLongValue(long l) {
        int n = -1;
        if (this.m_n_longs >= this.m_longs.length) {
            long[] lArray = new long[this.m_longs.length + 1024];
            System.arraycopy(this.m_longs, 0, lArray, 0, this.m_longs.length);
            this.m_longs = lArray;
        }
        this.m_longs[this.m_n_longs] = l;
        n = this.m_n_longs++;
        return n;
    }

    protected final int addDateTimeValue(XSDateTime xSDateTime) {
        int n = -1;
        if (xSDateTime != null) {
            if (this.m_n_datetimes >= this.m_datetimes.length) {
                XSDateTime[] xSDateTimeArray = new XSDateTime[this.m_datetimes.length + 1024];
                System.arraycopy(this.m_datetimes, 0, xSDateTimeArray, 0, this.m_datetimes.length);
                this.m_datetimes = xSDateTimeArray;
            }
            this.m_datetimes[this.m_n_datetimes] = xSDateTime;
            n = this.m_n_datetimes++;
        }
        return n;
    }

    protected final int addDurationValue(Duration duration) {
        int n = -1;
        if (duration != null) {
            if (this.m_n_durations >= this.m_durations.length) {
                Duration[] durationArray = new Duration[this.m_durations.length + 1024];
                System.arraycopy(this.m_durations, 0, durationArray, 0, this.m_durations.length);
                this.m_durations = durationArray;
            }
            this.m_durations[this.m_n_durations] = duration;
            n = this.m_n_durations++;
        }
        return n;
    }

    protected final int addBinaryValue(byte[] byArray) {
        int n = -1;
        if (byArray != null) {
            if (this.m_n_binaries >= this.m_binaries.length) {
                byte[][] byArrayArray = new byte[this.m_binaries.length + 1024][];
                System.arraycopy(this.m_binaries, 0, byArrayArray, 0, this.m_binaries.length);
                this.m_binaries = byArrayArray;
            }
            this.m_binaries[this.m_n_binaries] = byArray;
            n = this.m_n_binaries++;
        }
        return n;
    }

    protected final int addVariantStringValue(String string) {
        int n = -1;
        if (string != null) {
            this.ensureVariants();
            this.m_variantTypes[this.m_n_variants] = 0;
            this.m_variants[this.m_n_variants] = this.addStringValue(string);
            n = this.m_n_variants++;
        }
        return n;
    }

    protected final int addVariantBooleanValue(boolean bl) {
        this.ensureVariants();
        this.m_variantTypes[this.m_n_variants] = 9;
        this.m_variants[this.m_n_variants] = bl ? 1 : 0;
        return this.m_n_variants++;
    }

    protected final int addVariantFloatValue(long l, int n) {
        this.ensureVariants();
        this.m_variantTypes[this.m_n_variants] = 1;
        this.m_variants[this.m_n_variants] = this.addFloatValue(l, n);
        return this.m_n_variants++;
    }

    protected final int addVariantDecimalValue(boolean bl, String string, String string2) {
        int n = -1;
        this.ensureVariants();
        this.m_variantTypes[this.m_n_variants] = 2;
        this.m_variants[this.m_n_variants] = this.addDecimalValue(bl, string, string2);
        n = this.m_n_variants++;
        return n;
    }

    protected final int addVariantIntegerValue(BigInteger bigInteger) {
        int n = -1;
        if (bigInteger != null) {
            this.ensureVariants();
            this.m_variantTypes[this.m_n_variants] = 3;
            this.m_variants[this.m_n_variants] = this.addIntegerValue(bigInteger);
            n = this.m_n_variants++;
        }
        return n;
    }

    protected final int addVariantIntValue(int n) {
        int n2 = -1;
        this.ensureVariants();
        this.m_variantTypes[this.m_n_variants] = 4;
        this.m_variants[this.m_n_variants] = this.addIntValue(n);
        n2 = this.m_n_variants++;
        return n2;
    }

    protected final int addVariantLongValue(long l) {
        int n = -1;
        this.ensureVariants();
        this.m_variantTypes[this.m_n_variants] = 5;
        this.m_variants[this.m_n_variants] = this.addLongValue(l);
        n = this.m_n_variants++;
        return n;
    }

    protected final int addVariantDateTimeValue(XSDateTime xSDateTime) {
        int n = -1;
        if (xSDateTime != null) {
            this.ensureVariants();
            this.m_variantTypes[this.m_n_variants] = 6;
            this.m_variants[this.m_n_variants] = this.addDateTimeValue(xSDateTime);
            n = this.m_n_variants++;
        }
        return n;
    }

    protected final int addVariantDurationValue(Duration duration) {
        int n = -1;
        if (duration != null) {
            this.ensureVariants();
            this.m_variantTypes[this.m_n_variants] = 7;
            this.m_variants[this.m_n_variants] = this.addDurationValue(duration);
            n = this.m_n_variants++;
        }
        return n;
    }

    protected final int addVariantBinaryValue(byte[] byArray, byte by) {
        assert (by == 8 || by == 10);
        int n = -1;
        if (byArray != null) {
            this.ensureVariants();
            this.m_variantTypes[this.m_n_variants] = by;
            this.m_variants[this.m_n_variants] = this.addBinaryValue(byArray);
            n = this.m_n_variants++;
        }
        return n;
    }

    protected int doIntegralVariantValue(BigInteger bigInteger, int n) {
        int n2 = (1 << n) - 1;
        BigInteger bigInteger2 = BigInteger.valueOf(Integer.MAX_VALUE - (long)n2);
        BigInteger bigInteger3 = BigInteger.valueOf(Long.MAX_VALUE - (long)n2);
        int n3 = INT_MIN_VALUE.compareTo(bigInteger) <= 0 && bigInteger.compareTo(bigInteger2) <= 0 ? this.addVariantIntValue(bigInteger.intValue()) : (LONG_MIN_VALUE.compareTo(bigInteger) <= 0 && bigInteger.compareTo(bigInteger3) <= 0 ? this.addVariantLongValue(bigInteger.longValue()) : this.addVariantIntegerValue(bigInteger));
        return n3;
    }

    protected final void ensureGrammar(int n) {
        while (this.m_n_grammars + n > this.m_grammars.length) {
            int[] nArray = new int[2 * this.m_grammars.length];
            System.arraycopy(this.m_grammars, 0, nArray, 0, this.m_grammars.length);
            this.m_grammars = nArray;
        }
    }

    protected final void ensureProduction() {
        if (this.m_n_productions + 2 > this.m_productions.length) {
            int[] nArray = new int[2 * this.m_productions.length];
            System.arraycopy(this.m_productions, 0, nArray, 0, this.m_productions.length);
            this.m_productions = nArray;
        }
    }

    private void ensureEvent() {
        if (this.m_n_events + 1 > this.m_eventTypes.length) {
            byte[] byArray = new byte[2 * this.m_eventTypes.length];
            System.arraycopy(this.m_eventTypes, 0, byArray, 0, this.m_eventTypes.length);
            this.m_eventTypes = byArray;
            int[] nArray = new int[2 * this.m_eventData.length];
            System.arraycopy(this.m_eventData, 0, nArray, 0, this.m_eventData.length);
            this.m_eventData = nArray;
        }
    }

    protected final int addEvent(byte by, int n) {
        assert ((by == 0 || by == 1) && n != -1);
        int n2 = n << 2 | by;
        Integer n3 = this.m_eventMap.get(n2);
        if (n3 != null) {
            return n3;
        }
        this.ensureEvent();
        int n4 = this.m_n_events++;
        this.m_eventMap.put(n2, n4);
        this.m_eventTypes[n4] = by;
        this.m_eventData[n4] = n;
        return n4;
    }

    protected final int addEvent(byte by, String string) {
        assert (by == 2 || by == 3);
        int n = this.indexOfUri(string);
        assert (0 <= n);
        int n2 = n << 2 | by;
        Integer n3 = this.m_eventMap.get(n2);
        if (n3 != null) {
            return n3;
        }
        this.ensureEvent();
        int n4 = this.m_n_events++;
        this.m_eventMap.put(n2, n4);
        this.m_eventTypes[n4] = by;
        this.m_eventData[n4] = n;
        return n4;
    }
}

