/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.sax;

import java.io.IOException;
import java.io.OutputStream;
import java.util.TreeSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openexi.proc.EXIOptionsEncoder;
import org.openexi.proc.HeaderOptionsOutputType;
import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.common.EXIOptions;
import org.openexi.proc.common.EXIOptionsException;
import org.openexi.proc.common.EventType;
import org.openexi.proc.common.EventTypeList;
import org.openexi.proc.common.GrammarOptions;
import org.openexi.proc.common.QName;
import org.openexi.proc.common.SchemaId;
import org.openexi.proc.common.StringTable;
import org.openexi.proc.grammars.EventTypeSchema;
import org.openexi.proc.grammars.Grammar;
import org.openexi.proc.grammars.GrammarCache;
import org.openexi.proc.io.BinaryDataSink;
import org.openexi.proc.io.BitOutputStream;
import org.openexi.proc.io.BitPackedScriber;
import org.openexi.proc.io.PrefixUriBindings;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.Scriber;
import org.openexi.proc.io.ScriberFactory;
import org.openexi.proc.io.ScriberRuntimeException;
import org.openexi.proc.io.ValueScriber;
import org.openexi.sax.SAXTransmogrifier;
import org.openexi.sax.TransmogrifierException;
import org.openexi.sax.TransmogrifierRuntimeException;
import org.openexi.schema.EXISchema;
import org.openexi.schema.EmptySchema;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;

public final class Transmogrifier {
    private final XMLReader m_xmlReader;
    private final SAXEventHandler m_saxHandler;
    private HeaderOptionsOutputType m_outputOptions;
    private final EXIOptions m_exiOptions;
    private boolean m_divertBuiltinGrammarToAnyType;
    private static final SchemaId SCHEMAID_NO_SCHEMA = new SchemaId(null);
    private static final SchemaId SCHEMAID_EMPTY_SCHEMA = new SchemaId("");

    public Transmogrifier() throws TransmogrifierRuntimeException {
        this(false);
    }

    public Transmogrifier(SAXParserFactory sAXParserFactory) throws TransmogrifierRuntimeException {
        this(sAXParserFactory, false);
    }

    Transmogrifier(boolean bl) throws TransmogrifierRuntimeException {
        this(Transmogrifier.createSAXParserFactory(), bl);
    }

    Transmogrifier(SAXParserFactory sAXParserFactory, boolean bl) throws TransmogrifierRuntimeException {
        if (!sAXParserFactory.isNamespaceAware()) {
            throw new TransmogrifierRuntimeException(3, (String[])null);
        }
        this.m_saxHandler = new SAXEventHandler();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            this.m_xmlReader = sAXParser.getXMLReader();
            this.m_xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", bl);
        }
        catch (Exception exception) {
            throw new TransmogrifierRuntimeException(2, (String[])null);
        }
        this.m_xmlReader.setContentHandler(this.m_saxHandler);
        try {
            this.m_xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", this.m_saxHandler);
        }
        catch (SAXException sAXException) {
            TransmogrifierRuntimeException transmogrifierRuntimeException = new TransmogrifierRuntimeException(1, new String[]{"http://xml.org/sax/properties/lexical-handler"});
            transmogrifierRuntimeException.setException(sAXException);
            throw transmogrifierRuntimeException;
        }
        this.m_outputOptions = HeaderOptionsOutputType.none;
        this.m_exiOptions = new EXIOptions();
        this.m_divertBuiltinGrammarToAnyType = false;
    }

    public void setResolveExternalGeneralEntities(boolean bl) throws TransmogrifierException {
        try {
            this.m_xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", bl);
        }
        catch (SAXException sAXException) {
            TransmogrifierException transmogrifierException = new TransmogrifierException(5, new String[]{"http://xml.org/sax/features/external-general-entities"});
            transmogrifierException.setException(sAXException);
            throw transmogrifierException;
        }
    }

    public void setPrefixUriBindings(PrefixUriBindings prefixUriBindings) {
        this.m_saxHandler.setPrefixUriBindings(prefixUriBindings);
    }

    private void reset() {
        this.m_saxHandler.reset();
    }

    public final void setOutputStream(OutputStream outputStream) {
        this.m_saxHandler.setOutputStream(outputStream);
    }

    public final void setAlignmentType(AlignmentType alignmentType) throws EXIOptionsException {
        this.m_exiOptions.setAlignmentType(alignmentType);
        this.m_saxHandler.setAlignmentType(alignmentType);
    }

    public final void setFragment(boolean bl) {
        this.m_exiOptions.setFragment(bl);
    }

    public final void setBlockSize(int n) throws EXIOptionsException {
        this.m_exiOptions.setBlockSize(n);
    }

    public final void setValueMaxLength(int n) {
        this.m_exiOptions.setValueMaxLength(n);
        this.m_saxHandler.setValueMaxLength(n);
    }

    public final void setValuePartitionCapacity(int n) {
        this.m_exiOptions.setValuePartitionCapacity(n);
    }

    public final void setDivertBuiltinGrammarToAnyType(boolean bl) {
        this.m_divertBuiltinGrammarToAnyType = bl;
    }

    public final void setPreserveLexicalValues(boolean bl) throws EXIOptionsException {
        if (this.m_exiOptions.getPreserveLexicalValues() != bl) {
            if (this.m_outputOptions != HeaderOptionsOutputType.none && this.m_exiOptions.getDatatypeRepresentationMapBindingsCount() != 0 && bl) {
                throw new EXIOptionsException("Preserve.lexicalValues option and datatypeRepresentationMap option cannot be specified together in EXI header options.");
            }
            this.m_exiOptions.setPreserveLexicalValues(bl);
            this.m_saxHandler.setPreserveLexicalValues(bl);
        }
    }

    public final void setGrammarCache(GrammarCache grammarCache) throws EXIOptionsException {
        this.setGrammarCache(grammarCache, null);
    }

    public final void setGrammarCache(GrammarCache grammarCache, SchemaId schemaId) throws EXIOptionsException {
        EXISchema eXISchema = grammarCache.getEXISchema();
        if (schemaId == null) {
            if (eXISchema == null) {
                schemaId = SCHEMAID_NO_SCHEMA;
            } else if (eXISchema == EmptySchema.getEXISchema()) {
                schemaId = SCHEMAID_EMPTY_SCHEMA;
            }
        }
        this.m_exiOptions.setSchemaId(schemaId);
        this.m_exiOptions.setGrammarOptions(grammarCache.grammarOptions);
        this.m_saxHandler.setGrammarCache(grammarCache);
    }

    public final GrammarCache getGrammarCache() {
        return this.m_saxHandler.getGrammarCache();
    }

    public final void setDatatypeRepresentationMap(QName[] qNameArray, int n) throws EXIOptionsException {
        if (!QName.isSame(this.m_exiOptions.getDatatypeRepresentationMap(), this.m_exiOptions.getDatatypeRepresentationMapBindingsCount(), qNameArray, n)) {
            if (this.m_outputOptions != HeaderOptionsOutputType.none && this.m_exiOptions.getPreserveLexicalValues() && qNameArray != null) {
                throw new EXIOptionsException("Preserve.lexicalValues option and datatypeRepresentationMap option cannot be specified together in EXI header options.");
            }
            this.m_exiOptions.setDatatypeRepresentationMap(qNameArray, n);
            this.m_saxHandler.setDatatypeRepresentationMap(qNameArray, n);
        }
    }

    public final void setEntityResolver(EntityResolver entityResolver) {
        this.m_xmlReader.setEntityResolver(entityResolver);
    }

    public final void setOutputCookie(boolean bl) {
        this.m_saxHandler.setOutputCookie(bl);
    }

    public final void setOutputOptions(HeaderOptionsOutputType headerOptionsOutputType) throws EXIOptionsException {
        if (this.m_outputOptions != headerOptionsOutputType) {
            if (headerOptionsOutputType != HeaderOptionsOutputType.none && this.m_exiOptions.getPreserveLexicalValues() && this.m_exiOptions.getDatatypeRepresentationMap() != null) {
                throw new EXIOptionsException("Preserve.lexicalValues option and datatypeRepresentationMap option cannot be specified together in EXI header options.");
            }
            this.m_outputOptions = headerOptionsOutputType;
        }
    }

    public final void setPreserveWhitespaces(boolean bl) {
        this.m_saxHandler.setPreserveWhitespaces(bl);
    }

    public void setDeflateLevel(int n) {
        this.m_saxHandler.setDeflateLevel(n);
    }

    public void setDeflateStrategy(int n) {
        this.m_saxHandler.setDeflateStrategy(n);
    }

    public void encode(InputSource inputSource) throws TransmogrifierException, IOException {
        this.reset();
        try {
            this.m_xmlReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception != null) {
                if (exception instanceof TransmogrifierException) {
                    throw (TransmogrifierException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
            }
            LocatorImpl locatorImpl = null;
            if (sAXException instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)sAXException;
                locatorImpl = new LocatorImpl();
                locatorImpl.setSystemId(sAXParseException.getSystemId());
                locatorImpl.setLineNumber(sAXParseException.getLineNumber());
                locatorImpl.setColumnNumber(sAXParseException.getColumnNumber());
            }
            throw new TransmogrifierException(6, new String[]{sAXException.getMessage()}, locatorImpl);
        }
    }

    public SAXTransmogrifier getSAXTransmogrifier() {
        this.reset();
        return this.m_saxHandler;
    }

    private static final String getPrefixOfQualifiedName(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            return string.substring(0, n);
        }
        return "";
    }

    private static QName setXsiTypeValue(QName qName, String string, PrefixUriBindings prefixUriBindings) {
        qName.qName = string;
        int n = string.indexOf(58);
        if (n != -1) {
            qName.prefix = string.substring(0, n);
            qName.namespaceName = prefixUriBindings.getUri(qName.prefix);
            if (qName.namespaceName != null) {
                qName.localName = string.substring(n + 1);
            } else {
                qName.namespaceName = "";
                qName.localName = string;
                qName.prefix = "";
            }
        } else {
            qName.localName = string;
            qName.namespaceName = prefixUriBindings.getDefaultUri();
            qName.prefix = "";
        }
        return qName;
    }

    private static SAXParserFactory createSAXParserFactory() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        return sAXParserFactory;
    }

    static /* synthetic */ boolean access$900(Transmogrifier transmogrifier) {
        return transmogrifier.m_divertBuiltinGrammarToAnyType;
    }

    static /* synthetic */ String access$1000(String string) {
        return Transmogrifier.getPrefixOfQualifiedName(string);
    }

    static /* synthetic */ QName access$1100(QName qName, String string, PrefixUriBindings prefixUriBindings) {
        return Transmogrifier.setXsiTypeValue(qName, string, prefixUriBindings);
    }

    private static class XMLLocusItemEx {
        int elementURI;
        int elementLocalName;
        PrefixUriBindings prefixUriBindings;

        private XMLLocusItemEx() {
        }
    }

    private final class NamespaceDeclarations {
        private String[] decls = new String[16];
        private int n_decls = 0;

        public final String[] getDecls() {
            return this.decls;
        }

        public final int getDeclsCount() {
            return this.n_decls;
        }

        private void addDecl(String string, String string2, boolean bl) {
            String[] stringArray;
            int n = this.n_decls << 1;
            if (bl) {
                for (int i = 0; i < n; i += 2) {
                    if (!this.decls[i].equals(string)) continue;
                    this.decls[i + 1] = string2;
                    return;
                }
            }
            if (n != this.decls.length) {
                stringArray = this.decls;
            } else {
                stringArray = new String[2 * n];
                System.arraycopy(this.decls, 0, stringArray, 0, n);
            }
            stringArray[n] = string;
            stringArray[n + 1] = string2;
            this.decls = stringArray;
            ++this.n_decls;
        }

        public final void clear() {
            this.n_decls = 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComparableAttribute
    implements Comparable<ComparableAttribute> {
        byte priority;
        String uri;
        String name;
        String prefix;
        int index;

        private ComparableAttribute() {
        }

        public void init(String string, String string2, String string3, int n) {
            this.uri = string;
            this.name = string2;
            this.index = n;
            this.prefix = string3;
            int n2 = 2;
            if (string.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                assert (!"type".equals(string2));
                if ("nil".equals(string2)) {
                    n2 = 1;
                }
            }
            this.priority = (byte)n2;
        }

        @Override
        public int compareTo(ComparableAttribute comparableAttribute) {
            int n = this.priority - comparableAttribute.priority;
            if (n != 0) {
                return n;
            }
            n = this.name.compareTo(comparableAttribute.name);
            if (n != 0) {
                return n;
            }
            return this.uri.compareTo(comparableAttribute.uri);
        }
    }

    private final class SAXEventHandler
    implements SAXTransmogrifier {
        private static final String W3C_2000_XMLNS_URI = "http://www.w3.org/2000/xmlns/";
        private XMLLocusItemEx[] m_locusStack;
        private int m_locusLastDepth;
        private boolean m_inDTD;
        private static final byte STAG = 0;
        private static final byte CONT = 1;
        private static final byte ETAG = 2;
        private byte m_contentState;
        private GrammarCache m_grammarCache = new GrammarCache(null);
        private EXISchema m_schema = null;
        private boolean hasNS;
        private PrefixUriBindings m_prefixUriBindingsDefault;
        private PrefixUriBindings m_prefixUriBindings;
        private char[] m_charBuf;
        private int m_charPos;
        private final TreeSet<ComparableAttribute> sortedAttributes;
        private ComparableAttribute[] m_comparableAttributes;
        private int m_n_comparableAttributes;
        private final NamespaceDeclarations m_decls;
        private final QName qname;
        private Scriber m_scriber;
        private ValueScriber m_stringValueScriber;
        private OutputStream m_outputStream;
        private Locator m_locator;
        private boolean m_outputCookie;
        private final EXIOptionsEncoder m_optionsEncoder;
        private final Scribble m_scribble;
        private int m_zlibLevel;
        private int m_zlibStrategy;
        private boolean m_preserveWhitespaces;

        SAXEventHandler() {
            int n;
            this.m_locusStack = new XMLLocusItemEx[32];
            for (n = 0; n < 32; ++n) {
                this.m_locusStack[n] = new XMLLocusItemEx();
            }
            this.m_locusLastDepth = -1;
            this.m_prefixUriBindingsDefault = new PrefixUriBindings();
            this.m_prefixUriBindings = null;
            this.m_charBuf = new char[128];
            this.sortedAttributes = new TreeSet();
            this.m_decls = new NamespaceDeclarations();
            this.qname = new QName();
            this.m_scriber = ScriberFactory.createScriber(AlignmentType.bitPacked);
            this.setStringTable(Scriber.createStringTable(this.m_grammarCache));
            this.m_outputCookie = false;
            this.m_optionsEncoder = new EXIOptionsEncoder();
            this.m_scribble = new Scribble();
            this.m_zlibLevel = -1;
            this.m_zlibStrategy = 0;
            this.m_preserveWhitespaces = false;
            this.m_comparableAttributes = new ComparableAttribute[32];
            for (n = 0; n < this.m_comparableAttributes.length; ++n) {
                this.m_comparableAttributes[n] = new ComparableAttribute();
            }
            this.m_n_comparableAttributes = 0;
        }

        private void reset() {
            this.m_prefixUriBindings = null;
            this.m_locator = null;
            this.m_inDTD = false;
            this.m_contentState = (byte)2;
        }

        public final void setAlignmentType(AlignmentType alignmentType) {
            if (this.m_scriber.getAlignmentType() != alignmentType) {
                this.m_scriber = ScriberFactory.createScriber(alignmentType);
                this.m_scriber.setSchema(this.m_schema, Transmogrifier.this.m_exiOptions.getDatatypeRepresentationMap(), Transmogrifier.this.m_exiOptions.getDatatypeRepresentationMapBindingsCount());
                this.setStringTable(Scriber.createStringTable(this.m_grammarCache));
                this.m_scriber.setValueMaxLength(Transmogrifier.this.m_exiOptions.getValueMaxLength());
                this.m_scriber.setPreserveLexicalValues(Transmogrifier.this.m_exiOptions.getPreserveLexicalValues());
            }
        }

        private void setGrammarCache(GrammarCache grammarCache) {
            if (this.m_grammarCache != grammarCache) {
                this.m_grammarCache = grammarCache;
                EXISchema eXISchema = this.m_grammarCache.getEXISchema();
                if (eXISchema != this.m_schema) {
                    this.m_schema = eXISchema;
                    this.m_scriber.setSchema(this.m_schema, Transmogrifier.this.m_exiOptions.getDatatypeRepresentationMap(), Transmogrifier.this.m_exiOptions.getDatatypeRepresentationMapBindingsCount());
                    this.setStringTable(Scriber.createStringTable(this.m_grammarCache));
                }
            }
        }

        public final GrammarCache getGrammarCache() {
            return this.m_grammarCache;
        }

        public final void setValueMaxLength(int n) {
            this.m_scriber.setValueMaxLength(n);
        }

        public final void setPreserveLexicalValues(boolean bl) {
            this.m_scriber.setPreserveLexicalValues(bl);
        }

        public final void setDatatypeRepresentationMap(QName[] qNameArray, int n) throws EXIOptionsException {
            this.m_scriber.setSchema(this.m_schema, qNameArray, n);
        }

        private void setOutputStream(OutputStream outputStream) {
            this.m_outputStream = outputStream;
        }

        void setPrefixUriBindings(PrefixUriBindings prefixUriBindings) {
            this.m_prefixUriBindingsDefault = prefixUriBindings != null ? prefixUriBindings : new PrefixUriBindings();
        }

        private void setOutputCookie(boolean bl) {
            this.m_outputCookie = bl;
        }

        public void setDeflateLevel(int n) {
            this.m_zlibLevel = n;
        }

        public void setDeflateStrategy(int n) {
            this.m_zlibStrategy = n;
        }

        public final void setPreserveWhitespaces(boolean bl) {
            this.m_preserveWhitespaces = bl;
        }

        public final void setDocumentLocator(Locator locator) {
            this.m_locator = locator;
        }

        public final void startDocument() throws SAXException {
            this.m_locusLastDepth = -1;
            this.m_decls.clear();
            this.m_charPos = 0;
            try {
                Object object;
                Scriber.writeHeaderPreamble(this.m_outputStream, this.m_outputCookie, Transmogrifier.this.m_outputOptions != HeaderOptionsOutputType.none);
                BitOutputStream bitOutputStream = null;
                if (Transmogrifier.this.m_outputOptions != HeaderOptionsOutputType.none) {
                    object = this.m_optionsEncoder.encode(Transmogrifier.this.m_exiOptions, Transmogrifier.this.m_outputOptions == HeaderOptionsOutputType.all, this.m_outputStream);
                    if (Transmogrifier.this.m_exiOptions.getAlignmentType() == AlignmentType.bitPacked) {
                        bitOutputStream = object;
                    }
                }
                this.m_scriber.reset();
                if (bitOutputStream != null) {
                    ((BitPackedScriber)this.m_scriber).setBitOutputStream(bitOutputStream);
                } else {
                    this.m_scriber.setOutputStream(this.m_outputStream);
                }
                this.hasNS = GrammarOptions.hasNS(this.m_grammarCache.grammarOptions);
                this.m_scriber.setPreserveNS(this.hasNS);
                this.m_scriber.stringTable.setValuePartitionCapacity(Transmogrifier.this.m_exiOptions.getValuePartitionCapacity());
                this.m_scriber.setBlockSize(Transmogrifier.this.m_exiOptions.getBlockSize());
                this.m_scriber.setDeflateParams(this.m_zlibLevel, this.m_zlibStrategy);
                this.m_stringValueScriber = this.m_scriber.getValueScriberByID((short)15);
                this.m_grammarCache.retrieveRootGrammar(Transmogrifier.this.m_exiOptions.isFragment(), this.m_scriber.eventTypesWorkSpace).init(this.m_scriber.currentState);
                this.m_prefixUriBindings = this.m_prefixUriBindingsDefault;
                object = this.m_scriber.getNextEventTypes();
                EventType eventType = ((EventTypeList)object).getSD();
                if (eventType == null) {
                    throw new SAXException(new TransmogrifierException(9, null, new LocatorImpl(this.m_locator)));
                }
                this.m_scriber.startDocument();
                this.m_scriber.writeEventType(eventType);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public final void startPrefixMapping(String string, String string2) throws SAXException {
            PrefixUriBindings prefixUriBindings;
            if (string.length() != 0) {
                if (string2.length() != 0) {
                    prefixUriBindings = this.m_prefixUriBindings.bind(string, string2);
                    this.m_decls.addDecl(string, string2, prefixUriBindings == this.m_prefixUriBindings);
                } else {
                    prefixUriBindings = this.m_prefixUriBindings.unbind(string);
                    this.m_decls.addDecl(string, "", prefixUriBindings == this.m_prefixUriBindings);
                }
            } else if (string2.length() != 0) {
                prefixUriBindings = this.m_prefixUriBindings.bindDefault(string2);
                this.m_decls.addDecl("", string2, prefixUriBindings == this.m_prefixUriBindings);
            } else {
                prefixUriBindings = this.m_prefixUriBindings.unbindDefault();
                this.m_decls.addDecl("", "", prefixUriBindings == this.m_prefixUriBindings);
            }
            this.m_prefixUriBindings = prefixUriBindings;
        }

        public final void endPrefixMapping(String string) throws SAXException {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public final void startElement(String var1_1, String var2_2, String var3_3, Attributes var4_4) throws SAXException {
            block87: {
                if (this.m_charPos > 0) {
                    this.do_characters(false);
                }
                this.m_contentState = 0;
                this.m_n_comparableAttributes = 0;
                if (this.hasNS) {
                    var6_5 = this.m_decls.getDecls();
                    var7_6 = this.m_decls.getDeclsCount();
                    if (var7_6 != 0) {
                        this.m_decls.clear();
                    }
                    var5_9 = (var8_7 = var3_3.indexOf(58)) != -1 ? var3_3.substring(0, var8_7) : "";
                } else {
                    var6_5 = null;
                    var7_6 = 0;
                    var5_9 = null;
                }
                if (++this.m_locusLastDepth == this.m_locusStack.length) {
                    var8_7 = this.m_locusLastDepth + 8;
                    var9_10 = new XMLLocusItemEx[var8_7];
                    System.arraycopy(this.m_locusStack, 0, var9_10, 0, this.m_locusLastDepth);
                    for (var10_12 = this.m_locusLastDepth; var10_12 < var8_7; ++var10_12) {
                        var9_10[var10_12] = new XMLLocusItemEx();
                    }
                    this.m_locusStack = var9_10;
                }
                var8_8 = this.m_locusStack[this.m_locusLastDepth];
                var8_8.prefixUriBindings = this.m_prefixUriBindings;
                try {
                    var9_10 = this.m_scriber.getNextEventTypes();
                    var12_13 = null;
                    var14_14 = -1;
                    var15_15 = false;
                    var11_16 = var9_10.getLength();
                    block15: for (var10_12 = 0; var10_12 < var11_16; ++var10_12) {
                        var12_13 = var9_10.item(var10_12);
                        v0 = var12_13.itemType;
                        var14_14 = v0;
                        switch (v0) {
                            case 11: {
                                if (var2_2.equals(var12_13.name) && var1_1.equals(var13_17 = var12_13.uri)) break block15;
                                ** GOTO lbl50
                            }
                            case 14: {
                                var15_15 = true;
                                break block15;
                            }
                            case 15: {
                                var15_15 = true;
                                var13_17 = var12_13.uri;
                                if (var1_1.equals(var13_17)) break block15;
                                ** GOTO lbl50
                            }
                            case 5: {
                                var15_15 = true;
                                break block15;
                            }
lbl50:
                            // 3 sources

                            default: {
                                continue block15;
                            }
                        }
                    }
                    if ((var16_18 = var10_12) < var11_16) {
                        this.m_scriber.writeEventType(var12_13);
                        this.m_scriber.writeQName(this.qname.setValue(var1_1, var2_2, var5_9), var12_13);
                        var8_8.elementURI = this.qname.uriId;
                        var8_8.elementLocalName = this.qname.localNameId;
                        if (var15_15) {
                            this.m_scriber.startWildcardElement(var16_18, this.qname.uriId, this.qname.localNameId);
                        } else {
                            this.m_scriber.startElement(var12_13);
                        }
                        var17_19 = this.m_scriber.currentState.targetGrammar.grammarType;
                        if (!SAXEventHandler.$assertionsDisabled && var17_19 != 0 && var17_19 != 4 && var17_19 != 5) {
                            throw new AssertionError();
                        }
                        if (this.hasNS) {
                            if (var7_6 != 0) {
                                var9_10 = this.m_scriber.getNextEventTypes();
                                var11_16 = var9_10.getLength();
                                for (var10_12 = 0; var10_12 < var11_16; ++var10_12) {
                                    var12_13 = var9_10.item(var10_12);
                                    v1 = var12_13.itemType;
                                    var14_14 = v1;
                                    if (v1 != 7) continue;
                                    var10_12 = 0;
                                    var18_21 = 0;
                                    while (var10_12 < var7_6) {
                                        this.m_scriber.writeEventType(var12_13);
                                        var19_22 = var6_5[var18_21];
                                        this.m_scriber.writeNS(var6_5[var18_21 + 1], var19_22, var5_9.equals(var19_22));
                                        ++var10_12;
                                        var18_21 += 2;
                                    }
                                    break;
                                }
                            }
                        } else if (!SAXEventHandler.$assertionsDisabled && var5_9 != null) {
                            throw new AssertionError();
                        }
                        var18_21 = this.m_scriber.currentState.targetGrammar.isSchemaInformed();
                        var19_23 = Transmogrifier.access$900(Transmogrifier.this) != false && var17_19 == 0;
                        var20_24 = -1;
                        var21_25 = -1;
                        var22_26 = null;
                        var23_27 = var4_4.getLength();
                        if (var23_27 != 0) {
                            this.sortedAttributes.clear();
                            var11_16 = var23_27;
                            for (var10_12 = 0; var10_12 < var11_16; ++var10_12) {
                                var24_28 = var4_4.getURI(var10_12);
                                var25_29 = var4_4.getQName(var10_12);
                                if ("http://www.w3.org/2000/xmlns/".equals(var24_28) || var25_29.startsWith("xmlns") && (var25_29.length() == 5 || var25_29.charAt(5) == ':')) {
                                    --var23_27;
                                    continue;
                                }
                                if ("http://www.w3.org/2001/XMLSchema-instance".equals(var24_28)) {
                                    var26_30 = var4_4.getLocalName(var10_12);
                                    if ("type".equals(var26_30)) {
                                        var21_25 = var10_12;
                                        --var23_27;
                                        continue;
                                    }
                                    if ("nil".equals(var26_30)) {
                                        var20_24 = var10_12;
                                        continue;
                                    }
                                }
                                var27_35 = this.hasNS != false ? Transmogrifier.access$1000((String)var25_29) : null;
                                var26_30 = this.acquireComparableAttribute();
                                var26_30.init((String)var24_28, var4_4.getLocalName(var10_12), var27_35, var10_12);
                                this.sortedAttributes.add((ComparableAttribute)var26_30);
                            }
                        }
                        if ((var21_25 != -1 || var19_23) && (var22_26 = this.matchXsiType(this.m_scriber.getNextEventTypes(), var19_23)) == null) {
                            if (!SAXEventHandler.$assertionsDisabled && var18_21 == 0) {
                                throw new AssertionError();
                            }
                            var24_28 = new TransmogrifierException(2, new String[]{"type", "http://www.w3.org/2001/XMLSchema-instance", var4_4.getValue(var21_25)}, new LocatorImpl(this.m_locator));
                            throw new SAXException((Exception)var24_28);
                        }
                        var24_28 = this.m_grammarCache.getEXISchema();
                        if (Transmogrifier.access$900(Transmogrifier.this) || var21_25 != -1) {
                            this.m_scriber.writeEventType(var22_26);
                            var25_29 = this.hasNS ? (var21_25 != -1 ? Transmogrifier.access$1000(var4_4.getQName(var21_25)) : "") : null;
                            this.m_scriber.writeQName(this.qname.setValue("http://www.w3.org/2001/XMLSchema-instance", "type", (String)var25_29), var22_26);
                            if (var21_25 != -1) {
                                var26_30 = var4_4.getValue(var21_25);
                                Transmogrifier.access$1100(this.qname, (String)var26_30, this.m_prefixUriBindings);
                            } else {
                                this.qname.qName = "anyType";
                                this.qname.namespaceName = "http://www.w3.org/2001/XMLSchema";
                                this.qname.localName = "anyType";
                                this.qname.prefix = "";
                            }
                            this.m_scriber.writeXsiTypeValue(this.qname);
                            if (var18_21 == 0) {
                                v2 = var22_26.itemType;
                                var14_14 = v2;
                                if (v2 == 8) {
                                    this.m_scriber.wildcardAttribute(var22_26.getIndex(), 2, 1);
                                }
                            }
                            if (var24_28 != null && (var26_31 = var24_28.getTypeOfSchema(this.qname.namespaceName, this.qname.localName)) != -1) {
                                this.m_scriber.xsitp(var26_31);
                                var18_21 = 1;
                            }
                        }
                        if (var20_24 != -1) {
                            var25_29 = var4_4.getValue(var20_24);
                            var26_33 = null;
                            if (var18_21 != 0) {
                                var27_36 = var25_29.length();
                                block19: for (var28_39 = var27_36 - 1; var28_39 > 0; --var28_39) {
                                    switch (var25_29.charAt(var28_39)) {
                                        case '\t': 
                                        case '\n': 
                                        case '\r': 
                                        case ' ': {
                                            continue block19;
                                        }
                                    }
                                }
                                ++var28_39;
                                block20: for (var29_42 = 0; var29_42 < var27_36; ++var29_42) {
                                    switch (var25_29.charAt(var29_42)) {
                                        case '\t': 
                                        case '\n': 
                                        case '\r': 
                                        case ' ': {
                                            continue block20;
                                        }
                                    }
                                }
                                if (var29_42 != 0 || var28_39 != var27_36) {
                                    var27_36 = var28_39 - var29_42;
                                }
                                var9_10 = this.m_scriber.getNextEventTypes();
                                var30_43 = false;
                                var11_16 = var9_10.getLength();
                                for (var10_12 = 0; var10_12 < var11_16; ++var10_12) {
                                    var12_13 = var9_10.item(var10_12);
                                    var14_14 = var12_13.itemType;
                                    if (var14_14 == 21) {
                                        var30_43 = true;
                                        if (var27_36 == 4) {
                                            if (var25_29.charAt(var29_42) != 't' || var25_29.charAt(var29_42 + 1) != 'r' || var25_29.charAt(var29_42 + 2) != 'u' || var25_29.charAt(var29_42 + 3) != 'e') continue;
                                            var26_33 = Boolean.TRUE;
                                            break;
                                        }
                                        if (var27_36 == 5) {
                                            if (var25_29.charAt(var29_42) != 'f' || var25_29.charAt(var29_42 + 1) != 'a' || var25_29.charAt(var29_42 + 2) != 'l' || var25_29.charAt(var29_42 + 3) != 's' || var25_29.charAt(var29_42 + 4) != 'e') continue;
                                            var26_33 = Boolean.FALSE;
                                            break;
                                        }
                                        if (var27_36 != 1) continue;
                                        var31_45 = var25_29.charAt(var29_42);
                                        if (var31_45 == 49) {
                                            var26_33 = Boolean.TRUE;
                                            break;
                                        }
                                        if (var31_45 != 48) continue;
                                        var26_33 = Boolean.FALSE;
                                        break;
                                    }
                                    if (var14_14 != 8) continue;
                                    if (!SAXEventHandler.$assertionsDisabled && !var30_43) {
                                        throw new AssertionError();
                                    }
                                    break;
                                }
                                if (var10_12 == var11_16) {
                                    var31_46 = new TransmogrifierException(2, new String[]{"nil", "http://www.w3.org/2001/XMLSchema-instance", var25_29}, new LocatorImpl(this.m_locator));
                                    throw new SAXException(var31_46);
                                }
                            }
                            if (var26_33 != null) {
                                this.m_scriber.writeEventType(var12_13);
                                this.m_scriber.writeQName(this.qname.setValue("http://www.w3.org/2001/XMLSchema-instance", "nil", this.hasNS != false ? Transmogrifier.access$1000(var4_4.getQName(var20_24)) : null), var12_13);
                                this.m_scriber.writeXsiNilValue(var26_33, (String)var25_29);
                                if (var26_33.booleanValue()) {
                                    this.m_scriber.nillify(var12_13.getIndex());
                                }
                                --var23_27;
                            } else if (var18_21 != 0) {
                                if (!SAXEventHandler.$assertionsDisabled && var14_14 != 8) {
                                    throw new AssertionError();
                                }
                                this.m_scriber.writeEventType(var12_13);
                                this.m_scriber.writeQName(this.qname.setValue("http://www.w3.org/2001/XMLSchema-instance", "nil", this.hasNS != false ? Transmogrifier.access$1000(var4_4.getQName(var20_24)) : null), var12_13);
                                this.m_stringValueScriber.scribe((String)var25_29, this.m_scribble, 0, 2, -1, this.m_scriber);
                                --var23_27;
                            } else {
                                var28_40 = this.hasNS != false ? Transmogrifier.access$1000(var4_4.getQName(var20_24)) : null;
                                var27_37 = this.acquireComparableAttribute();
                                var27_37.init(var4_4.getURI(var20_24), var4_4.getLocalName(var20_24), var28_40, var20_24);
                                this.sortedAttributes.add(var27_37);
                            }
                        }
                        if (var23_27 != 0) {
                            var25_29 = this.sortedAttributes.iterator();
                            for (var10_12 = 0; var10_12 < var23_27; ++var10_12) {
                                var9_10 = this.m_scriber.getNextEventTypes();
                                var26_34 = (ComparableAttribute)var25_29.next();
                                var27_38 = var26_34.uri;
                                var28_41 = var26_34.name;
                                var29_42 = -1;
                                var30_44 = null;
                                if (var18_21 != 0) {
                                    var12_13 = var9_10.getSchemaAttribute(var27_38, var28_41);
                                    if (var12_13 != null) {
                                        var31_47 = (EventTypeSchema)var12_13;
                                        var29_42 = var31_47.nd;
                                        if (var29_42 != -1) {
                                            var30_44 = this.m_scriber.getValueScriber(var29_42);
                                            if (!var30_44.process(var4_4.getValue(var26_34.index), var29_42, this.m_schema, this.m_scribble, this.m_scriber)) {
                                                var30_44 = this.m_stringValueScriber;
                                                var12_13 = var9_10.getSchemaAttributeInvalid(var27_38, var28_41);
                                                var29_42 = -1;
                                            }
                                        } else {
                                            var30_44 = this.m_stringValueScriber;
                                        }
                                        if (var12_13 != null) {
                                            this.m_scriber.writeEventType(var12_13);
                                            var32_49 = var26_34.prefix;
                                            if (this.hasNS) {
                                                this.verifyPrefix(var27_38, var32_49);
                                            }
                                            this.m_scriber.writeQName(this.qname.setValue(var27_38, var28_41, var32_49), var12_13);
                                            var30_44.scribe(var4_4.getValue(var26_34.index), this.m_scribble, this.qname.localNameId, this.qname.uriId, var29_42, this.m_scriber);
                                            this.m_scriber.attribute(var12_13);
                                            continue;
                                        }
                                    }
                                    if (var12_13 == null) {
                                        var12_13 = var9_10.getSchemaAttributeWildcardNS(var27_38);
                                        if (var12_13 == null) {
                                            var12_13 = var9_10.getSchemaAttributeWildcardAny();
                                        }
                                        if (var12_13 != null) {
                                            var31_45 = var24_28.getGlobalAttrOfSchema(var27_38, var28_41);
                                            if (var31_45 != -1) {
                                                var29_42 = var24_28.getTypeOfAttr(var31_45);
                                                if (!SAXEventHandler.$assertionsDisabled && var29_42 == -1) {
                                                    throw new AssertionError();
                                                }
                                                var30_44 = this.m_scriber.getValueScriber(var29_42);
                                                if (!var30_44.process(var4_4.getValue(var26_34.index), var29_42, this.m_schema, this.m_scribble, this.m_scriber)) {
                                                    var29_42 = -1;
                                                    var12_13 = null;
                                                }
                                            } else {
                                                var30_44 = this.m_stringValueScriber;
                                            }
                                        }
                                        if (var12_13 == null && (var12_13 = var9_10.getAttributeWildcardAnyUntyped()) != null) {
                                            var30_44 = this.m_stringValueScriber;
                                        }
                                        if (var12_13 != null) {
                                            this.m_scriber.writeEventType(var12_13);
                                            var31_47 = var26_34.prefix;
                                            if (this.hasNS) {
                                                this.verifyPrefix(var27_38, (String)var31_47);
                                            }
                                            this.m_scriber.writeQName(this.qname.setValue(var27_38, var28_41, (String)var31_47), var12_13);
                                            var30_44.scribe(var4_4.getValue(var26_34.index), this.m_scribble, this.qname.localNameId, this.qname.uriId, var29_42, this.m_scriber);
                                            if (var14_14 != 8) continue;
                                            this.m_scriber.wildcardAttribute(var12_13.getIndex(), this.qname.uriId, this.qname.localNameId);
                                            continue;
                                        }
                                    }
                                } else {
                                    var12_13 = var9_10.getLearnedAttribute(var27_38, var28_41);
                                    if (var12_13 != null || (var12_13 = var9_10.getAttributeWildcardAnyUntyped()) != null) {
                                        var30_44 = this.m_stringValueScriber;
                                    }
                                    if (var12_13 != null) {
                                        this.m_scriber.writeEventType(var12_13);
                                        var31_47 = var26_34.prefix;
                                        if (this.hasNS) {
                                            this.verifyPrefix(var27_38, (String)var31_47);
                                        }
                                        this.m_scriber.writeQName(this.qname.setValue(var27_38, var28_41, (String)var31_47), var12_13);
                                        var30_44.scribe(var4_4.getValue(var26_34.index), this.m_scribble, this.qname.localNameId, this.qname.uriId, var29_42, this.m_scriber);
                                        if (var12_13.itemType != 8) continue;
                                        this.m_scriber.wildcardAttribute(var12_13.getIndex(), this.qname.uriId, this.qname.localNameId);
                                        continue;
                                    }
                                }
                                var31_48 = new TransmogrifierException(2, new String[]{var28_41, var27_38, var4_4.getValue(var26_34.index)}, new LocatorImpl(this.m_locator));
                                throw new SAXException(var31_48);
                            }
                        }
                        break block87;
                    }
                    var17_20 = new TransmogrifierException(1, new String[]{var2_2, var1_1}, new LocatorImpl(this.m_locator));
                    throw new SAXException(var17_20);
                }
                catch (IOException var9_11) {
                    throw new SAXException(var9_11.getMessage(), var9_11);
                }
            }
        }

        public final void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.appendCharacters(cArray, n, n2);
        }

        public final void characters(char[] cArray, int n, int n2) throws SAXException {
            this.appendCharacters(cArray, n, n2);
        }

        public final BinaryDataSink startBinaryData(long l) throws SAXException {
            this.m_charPos = 0;
            try {
                EventTypeList eventTypeList = this.m_scriber.getNextEventTypes();
                EventType eventType = eventTypeList.getSchemaCharacters();
                if (eventType != null) {
                    int n = this.m_scriber.currentState.contentDatatype;
                    assert (n != -1);
                    ValueScriber valueScriber = this.m_scriber.getValueScriber(n);
                    if (valueScriber instanceof BinaryDataSink) {
                        BinaryDataSink binaryDataSink = (BinaryDataSink)((Object)valueScriber);
                        this.m_scriber.writeEventType(eventType);
                        this.m_scriber.characters(eventType);
                        try {
                            binaryDataSink.startBinaryData(l, this.m_scribble, this.m_scriber);
                        }
                        catch (ScriberRuntimeException scriberRuntimeException) {
                            TransmogrifierException transmogrifierException = new TransmogrifierException(12, new String[]{scriberRuntimeException.getMessage()}, new LocatorImpl(this.m_locator));
                            transmogrifierException.setException(scriberRuntimeException);
                            throw new SAXException(transmogrifierException);
                        }
                        return binaryDataSink;
                    }
                }
                TransmogrifierException transmogrifierException = new TransmogrifierException(4, null, new LocatorImpl(this.m_locator));
                throw new SAXException(transmogrifierException);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public final void binaryData(byte[] byArray, int n, int n2, BinaryDataSink binaryDataSink) throws SAXException {
            try {
                binaryDataSink.binaryData(byArray, n, n2, this.m_scribble, this.m_scriber);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public final void endBinaryData(BinaryDataSink binaryDataSink) throws SAXException {
            XMLLocusItemEx xMLLocusItemEx = this.m_locusStack[this.m_locusLastDepth];
            try {
                binaryDataSink.endBinaryData(this.m_scribble, xMLLocusItemEx.elementLocalName, xMLLocusItemEx.elementURI, this.m_scriber);
            }
            catch (ScriberRuntimeException scriberRuntimeException) {
                TransmogrifierException transmogrifierException = new TransmogrifierException(12, new String[]{scriberRuntimeException.getMessage()}, new LocatorImpl(this.m_locator));
                transmogrifierException.setException(scriberRuntimeException);
                throw new SAXException(transmogrifierException);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        private void do_characters(boolean bl) throws SAXException {
            bl = bl || this.m_contentState == 1;
            try {
                Object object;
                EventTypeList eventTypeList = this.m_scriber.getNextEventTypes();
                int n = -1;
                EventType eventType = eventTypeList.getSchemaCharacters();
                if (eventType != null) {
                    n = this.m_scriber.currentState.contentDatatype;
                    assert (n != -1);
                    ValueScriber valueScriber = this.m_scriber.getValueScriber(n);
                    if (valueScriber.process((String)(object = new String(this.m_charBuf, 0, this.m_charPos)), n, this.m_schema, this.m_scribble, this.m_scriber)) {
                        this.m_scriber.writeEventType(eventType);
                        this.m_scriber.characters(eventType);
                        XMLLocusItemEx xMLLocusItemEx = this.m_locusStack[this.m_locusLastDepth];
                        valueScriber.scribe((String)object, this.m_scribble, xMLLocusItemEx.elementLocalName, xMLLocusItemEx.elementURI, n, this.m_scriber);
                        this.m_charPos = 0;
                        return;
                    }
                }
                if ((eventType = eventTypeList.getCharacters()) != null) {
                    boolean bl2 = this.m_preserveWhitespaces;
                    if (!bl2) {
                        bl2 = n != -1 ? true : (this.m_scriber.currentState.targetGrammar.isSchemaInformed() ? eventType.itemType == 20 : bl);
                    }
                    if (bl2) {
                        this.m_scriber.writeEventType(eventType);
                        this.m_scriber.undeclaredCharacters(eventType.getIndex());
                        object = this.m_locusStack[this.m_locusLastDepth];
                        this.m_stringValueScriber.scribe(new String(this.m_charBuf, 0, this.m_charPos), this.m_scribble, ((XMLLocusItemEx)object).elementLocalName, ((XMLLocusItemEx)object).elementURI, -1, this.m_scriber);
                    } else {
                        int n2 = this.m_charPos;
                        block8: for (int i = 0; i < n2; ++i) {
                            switch (this.m_charBuf[i]) {
                                case '\t': 
                                case '\n': 
                                case '\r': 
                                case ' ': {
                                    continue block8;
                                }
                                default: {
                                    this.m_scriber.writeEventType(eventType);
                                    this.m_scriber.undeclaredCharacters(eventType.getIndex());
                                    XMLLocusItemEx xMLLocusItemEx = this.m_locusStack[this.m_locusLastDepth];
                                    this.m_stringValueScriber.scribe(new String(this.m_charBuf, 0, this.m_charPos), this.m_scribble, xMLLocusItemEx.elementLocalName, xMLLocusItemEx.elementURI, -1, this.m_scriber);
                                    break block8;
                                }
                            }
                        }
                    }
                    this.m_charPos = 0;
                    return;
                }
                int n3 = this.m_charPos;
                block9: for (int i = 0; i < n3; ++i) {
                    switch (this.m_charBuf[i]) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            continue block9;
                        }
                        default: {
                            TransmogrifierException transmogrifierException = new TransmogrifierException(3, new String[]{new String(this.m_charBuf, 0, this.m_charPos)}, new LocatorImpl(this.m_locator));
                            throw new SAXException(transmogrifierException);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
            this.m_charPos = 0;
        }

        public final void endElement(String string, String string2, String string3) throws SAXException {
            if (this.m_charPos > 0) {
                this.do_characters(this.m_contentState == 0);
            }
            this.m_contentState = (byte)2;
            try {
                EventTypeList eventTypeList = this.m_scriber.getNextEventTypes();
                EventType eventType = null;
                eventType = eventTypeList.getEE();
                if (eventType == null) {
                    assert (this.m_scriber.currentState.targetGrammar.isSchemaInformed());
                    eventType = eventTypeList.getSchemaCharacters();
                    if (eventType != null) {
                        int n = this.m_scriber.currentState.contentDatatype;
                        assert (n != -1);
                        ValueScriber valueScriber = this.m_scriber.getValueScriber(n);
                        if (valueScriber.process("", n, this.m_schema, this.m_scribble, this.m_scriber)) {
                            this.m_scriber.writeEventType(eventType);
                            this.m_scriber.characters(eventType);
                            XMLLocusItemEx xMLLocusItemEx = this.m_locusStack[this.m_locusLastDepth];
                            valueScriber.scribe("", this.m_scribble, xMLLocusItemEx.elementLocalName, xMLLocusItemEx.elementURI, n, this.m_scriber);
                            this.endElement(string, string2, string3);
                            return;
                        }
                    }
                    throw new SAXException(new TransmogrifierException(7, new String[]{string2, string}, new LocatorImpl(this.m_locator)));
                }
                this.m_scriber.writeEventType(eventType);
                this.m_scriber.endElement();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
            this.m_prefixUriBindings = this.m_locusLastDepth-- != 0 ? this.m_locusStack[this.m_locusLastDepth].prefixUriBindings : this.m_prefixUriBindingsDefault;
        }

        public final void endDocument() throws SAXException {
            if (this.m_charPos > 0) {
                this.do_characters(false);
            }
            try {
                EventTypeList eventTypeList = this.m_scriber.getNextEventTypes();
                EventType eventType = eventTypeList.getED();
                if (eventType == null) {
                    throw new SAXException(new TransmogrifierException(8, null, new LocatorImpl(this.m_locator)));
                }
                this.m_scriber.endDocument();
                this.m_scriber.writeEventType(eventType);
                this.m_scriber.finish();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public final void processingInstruction(String string, String string2) throws SAXException {
            if (Transmogrifier.this.m_exiOptions.getPreservePIs()) {
                if (this.m_charPos > 0) {
                    this.do_characters(true);
                }
                EventTypeList eventTypeList = this.m_scriber.getNextEventTypes();
                int n = eventTypeList.getLength();
                for (int i = 0; i < n; ++i) {
                    EventType eventType = eventTypeList.item(i);
                    if (eventType.itemType != 0) continue;
                    this.m_scriber.miscContent(eventType.getIndex());
                    try {
                        this.m_scriber.writeEventType(eventType);
                        this.m_scriber.writeName(string);
                        this.m_scriber.writeText(string2);
                    }
                    catch (IOException iOException) {
                        throw new SAXException(iOException);
                    }
                    this.m_contentState = 1;
                    break;
                }
            }
        }

        public final void skippedEntity(String string) throws SAXException {
            if (Transmogrifier.this.m_exiOptions.getPreserveDTD()) {
                if (this.m_charPos > 0) {
                    this.do_characters(true);
                }
                EventTypeList eventTypeList = this.m_scriber.getNextEventTypes();
                int n = eventTypeList.getLength();
                for (int i = 0; i < n; ++i) {
                    EventType eventType = eventTypeList.item(i);
                    if (eventType.itemType != 2) continue;
                    this.m_scriber.miscContent(eventType.getIndex());
                    try {
                        this.m_scriber.writeEventType(eventType);
                        this.m_scriber.writeName(string);
                    }
                    catch (IOException iOException) {
                        throw new SAXException(iOException);
                    }
                    this.m_contentState = 1;
                    break;
                }
            }
        }

        public final void comment(char[] cArray, int n, int n2) throws SAXException {
            if (!this.m_inDTD && Transmogrifier.this.m_exiOptions.getPreserveComments()) {
                if (this.m_charPos > 0) {
                    this.do_characters(true);
                }
                EventTypeList eventTypeList = this.m_scriber.getNextEventTypes();
                int n3 = eventTypeList.getLength();
                for (int i = 0; i < n3; ++i) {
                    EventType eventType = eventTypeList.item(i);
                    if (eventType.itemType != 1) continue;
                    this.m_scriber.miscContent(eventType.getIndex());
                    try {
                        this.m_scriber.writeEventType(eventType);
                        this.m_scriber.writeText(new String(cArray, n, n2));
                    }
                    catch (IOException iOException) {
                        throw new SAXException(iOException);
                    }
                    this.m_contentState = 1;
                    break;
                }
            }
        }

        public void startDTD(String string, String string2, String string3) throws SAXException {
            int n;
            EventTypeList eventTypeList = this.m_scriber.getNextEventTypes();
            EventType eventType = null;
            int n2 = eventTypeList.getLength();
            for (n = 0; n < n2; ++n) {
                eventType = eventTypeList.item(n);
                if (eventType.itemType == 10) break;
            }
            if (n < n2) {
                try {
                    this.m_scriber.writeEventType(eventType);
                    this.m_scriber.writeName(string);
                    this.m_scriber.writePublic(string2 != null ? string2 : "");
                    this.m_scriber.writeSystem(string3 != null ? string3 : "");
                    this.m_scriber.writeText("");
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
            this.m_inDTD = true;
        }

        public void endDTD() {
            this.m_inDTD = false;
        }

        public void startCDATA() {
        }

        public void endCDATA() {
        }

        public void startEntity(String string) {
        }

        public void endEntity(String string) {
        }

        private void appendCharacters(char[] cArray, int n, int n2) {
            while (this.m_charPos + n2 > this.m_charBuf.length) {
                char[] cArray2 = new char[2 * this.m_charBuf.length];
                System.arraycopy(this.m_charBuf, 0, cArray2, 0, this.m_charBuf.length);
                this.m_charBuf = cArray2;
            }
            System.arraycopy(cArray, n, this.m_charBuf, this.m_charPos, n2);
            this.m_charPos += n2;
        }

        private void setStringTable(StringTable stringTable) {
            this.m_scriber.setStringTable(stringTable);
        }

        private ComparableAttribute acquireComparableAttribute() {
            if (this.m_n_comparableAttributes == this.m_comparableAttributes.length) {
                int n = this.m_n_comparableAttributes + 32;
                ComparableAttribute[] comparableAttributeArray = new ComparableAttribute[n];
                System.arraycopy(this.m_comparableAttributes, 0, comparableAttributeArray, 0, this.m_n_comparableAttributes);
                for (int i = this.m_n_comparableAttributes; i < n; ++i) {
                    comparableAttributeArray[i] = new ComparableAttribute();
                }
                this.m_comparableAttributes = comparableAttributeArray;
            }
            return this.m_comparableAttributes[this.m_n_comparableAttributes++];
        }

        private void verifyPrefix(String string, String string2) throws SAXException, IOException {
            if (string2.length() != 0) {
                String string3 = this.m_prefixUriBindings.getUri(string2);
                if (string3 == null) {
                    TransmogrifierException transmogrifierException = new TransmogrifierException(10, new String[]{string2}, new LocatorImpl(this.m_locator));
                    throw new SAXException(transmogrifierException);
                }
                if (!string.equals(string3)) {
                    TransmogrifierException transmogrifierException = new TransmogrifierException(11, new String[]{string2, string3}, new LocatorImpl(this.m_locator));
                    throw new SAXException(transmogrifierException);
                }
            }
        }

        private EventType matchXsiType(EventTypeList eventTypeList, boolean bl) {
            Grammar grammar = this.m_scriber.currentState.targetGrammar;
            byte by = grammar.grammarType;
            boolean bl2 = grammar.isSchemaInformed();
            int n = eventTypeList.getLength();
            block5: for (int i = 0; i < n; ++i) {
                EventType eventType = eventTypeList.item(i);
                switch (eventType.itemType) {
                    case 22: {
                        assert (by != 0);
                        return eventType;
                    }
                    case 8: {
                        if (bl2) continue block5;
                        return eventType;
                    }
                    case 12: {
                        assert (!bl2);
                        if (bl || !"type".equals(eventType.name) || !"http://www.w3.org/2001/XMLSchema-instance".equals(eventType.uri)) continue block5;
                        return eventType;
                    }
                }
            }
            return null;
        }
    }
}

