/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.openexi.proc.common.QName;
import org.openexi.proc.io.DateTimeValueScriberBase;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.Scriber;
import org.openexi.schema.EXISchema;
import org.openexi.schema.XSDateTime;

public class TimeValueScriber
extends DateTimeValueScriberBase {
    public static final TimeValueScriber instance = new TimeValueScriber();

    private TimeValueScriber() {
        super(new QName("exi:time", "http://www.w3.org/2009/exi"));
    }

    public short getCodecID() {
        return 5;
    }

    public int getBuiltinRCS(int n, Scriber scriber) {
        return -5;
    }

    public boolean process(String string, int n, EXISchema eXISchema, Scribble scribble, Scriber scriber) {
        if (!this.trimWhitespaces(string)) {
            return false;
        }
        BigInteger bigInteger = null;
        int n2 = Integer.MIN_VALUE;
        this.nextPosition = this.startPosition;
        if (!this.parseHourField(string, scribble) || this.nextPosition == this.limitPosition) {
            return false;
        }
        int n3 = scribble.intValue1;
        if (string.charAt(this.nextPosition++) != ':' || this.nextPosition == this.limitPosition) {
            return false;
        }
        if (!this.parseMinuteField(string, scribble) || this.nextPosition == this.limitPosition) {
            return false;
        }
        int n4 = scribble.intValue1;
        if (n3 == 24 && n4 != 0) {
            return false;
        }
        if (string.charAt(this.nextPosition++) != ':' || this.nextPosition == this.limitPosition) {
            return false;
        }
        if (!this.parseSecondField(string, scribble)) {
            return false;
        }
        int n5 = scribble.intValue1;
        if (n3 == 24 && n5 != 0) {
            return false;
        }
        if (this.nextPosition != this.limitPosition) {
            if (string.charAt(this.nextPosition) == '.') {
                if (++this.nextPosition == this.limitPosition) {
                    return false;
                }
                bigInteger = this.parseFractionalSecondField(string);
                if (bigInteger == null) {
                    return false;
                }
                if (bigInteger.signum() == 0) {
                    bigInteger = null;
                }
            }
            if (this.nextPosition != this.limitPosition) {
                if (!this.parseTimezoneField(string, scribble) || this.nextPosition != this.limitPosition) {
                    return false;
                }
                n2 = scribble.intValue1;
            }
        }
        scribble.dateTime = new XSDateTime(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, n3, n4, n5, bigInteger, n2, 9);
        return true;
    }

    void scribeDateTimeValue(XSDateTime xSDateTime, OutputStream outputStream, Scriber scriber) throws IOException {
        this.writeTime(xSDateTime.hour, xSDateTime.minute, xSDateTime.second, xSDateTime.reverseFractionalSecond, outputStream, scriber);
        this.writeTimeZone(xSDateTime.timeZone, outputStream, scriber);
    }
}

