/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.grammars;

import org.openexi.proc.common.EventCode;
import org.openexi.proc.common.EventType;
import org.openexi.proc.grammars.EventCodeTuple;

final class ReverseEventCodeTuple
extends EventCodeTuple {
    private int m_initial_width;
    private int m_initial_itemsCount;

    public ReverseEventCodeTuple() {
        super((byte)-1, true);
        this.eventCodes = new EventCode[16];
    }

    void checkPoint() {
        this.m_initial_width = this.width;
        this.m_initial_itemsCount = this.itemsCount;
    }

    void reset() {
        this.width = this.m_initial_width;
        this.itemsCount = this.m_initial_itemsCount;
    }

    public EventCode getItem(int n) {
        return this.eventCodes[this.itemsCount - (n + 1)];
    }

    void setInitialSoloTuple(EventCodeTuple eventCodeTuple) {
        assert (this.itemsCount == 0);
        if (this.itemsCount == this.eventCodes.length) {
            EventCode[] eventCodeArray = new EventCode[this.itemsCount + 16];
            System.arraycopy(this.eventCodes, 0, eventCodeArray, 0, this.itemsCount);
            this.eventCodes = eventCodeArray;
        }
        this.eventCodes[this.itemsCount] = eventCodeTuple;
        eventCodeTuple.setParentalContext(this.itemsCount++, this);
        this.updateWidth();
        this.headItem = eventCodeTuple;
    }

    void setInitialItems(EventType eventType, EventCode eventCode) {
        assert (this.itemsCount == 0 && eventType.itemType == 9);
        if (this.itemsCount > this.eventCodes.length - 2) {
            EventCode[] eventCodeArray = new EventCode[this.itemsCount + 16];
            System.arraycopy(this.eventCodes, 0, eventCodeArray, 0, this.itemsCount);
            this.eventCodes = eventCodeArray;
        }
        this.eventCodes[this.itemsCount] = eventCode;
        this.eventCodes[this.itemsCount + 1] = eventType;
        eventCode.setParentalContext(this.itemsCount++, this);
        eventType.setParentalContext(this.itemsCount++, this);
        this.updateWidth();
        eventType.computeItemPath();
        this.headItem = this.eventCodes[0];
    }

    void setInitialItems(EventType eventType, EventType eventType2, EventCode eventCode) {
        EventCode[] eventCodeArray;
        assert (this.itemsCount == 0 && eventType.itemType == 5 && eventType2.itemType == 4);
        if (eventCode != null) {
            if (this.itemsCount == this.eventCodes.length) {
                eventCodeArray = new EventCode[this.itemsCount + 16];
                System.arraycopy(this.eventCodes, 0, eventCodeArray, 0, this.itemsCount);
                this.eventCodes = eventCodeArray;
            }
            this.eventCodes[this.itemsCount] = eventCode;
            eventCode.setParentalContext(this.itemsCount++, this);
        }
        if (this.itemsCount > this.eventCodes.length - 2) {
            eventCodeArray = new EventCode[this.itemsCount + 16];
            System.arraycopy(this.eventCodes, 0, eventCodeArray, 0, this.itemsCount);
            this.eventCodes = eventCodeArray;
        }
        this.eventCodes[this.itemsCount] = eventType2;
        this.eventCodes[this.itemsCount + 1] = eventType;
        eventType2.setParentalContext(this.itemsCount++, this);
        eventType.setParentalContext(this.itemsCount++, this);
        this.updateWidth();
        eventType2.computeItemPath();
        eventType.computeItemPath();
        this.headItem = this.eventCodes[0];
    }

    void addItem(EventType eventType) {
        if (this.itemsCount == this.eventCodes.length) {
            EventCode[] eventCodeArray = new EventCode[this.itemsCount + 16];
            System.arraycopy(this.eventCodes, 0, eventCodeArray, 0, this.itemsCount);
            this.eventCodes = eventCodeArray;
        }
        this.eventCodes[this.itemsCount] = eventType;
        eventType.setParentalContext(this.itemsCount++, this);
        this.updateWidth();
        eventType.computeItemPath();
    }

    private void updateWidth() {
        switch (this.itemsCount) {
            case 1: {
                this.width = 0;
                break;
            }
            case 2: {
                this.width = 1;
                break;
            }
            case 3: 
            case 4: {
                this.width = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.width = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                this.width = 4;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                this.width = 5;
                break;
            }
            default: {
                int n = 0;
                int n2 = this.itemsCount - 1;
                while (n2 != 0) {
                    n2 >>= 1;
                    ++n;
                }
                this.width = n;
            }
        }
    }
}

