/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.common.BinaryDataSource;
import org.openexi.proc.common.IBinaryValueScanner;
import org.openexi.proc.common.QName;
import org.openexi.proc.io.OctetBuffer;
import org.openexi.proc.io.Scanner;
import org.openexi.proc.io.ValueScannerBase;

public abstract class BinaryValueScanner
extends ValueScannerBase
implements IBinaryValueScanner {
    protected final Scanner m_scanner;
    protected byte[] m_octets;
    private final OctetBuffer m_octetBuffer;
    private final boolean m_resetBeforeScan;

    public BinaryValueScanner(QName qName, Scanner scanner) {
        super(qName);
        this.m_scanner = scanner;
        this.m_octets = new byte[8192];
        this.m_octetBuffer = this.m_scanner.octetBuffer;
        AlignmentType alignmentType = scanner.getAlignmentType();
        this.m_resetBeforeScan = alignmentType == AlignmentType.bitPacked || alignmentType == AlignmentType.byteAligned;
    }

    protected final void expandBuffer(int n) {
        int n2;
        for (n2 = this.m_octets.length << 1; n2 < n; n2 <<= 1) {
        }
        this.m_octets = new byte[n2];
    }

    public final BinaryDataSource scan(long l, BinaryDataSource binaryDataSource) throws IOException {
        int n;
        if (l == -1L) {
            l = this.m_scanner.readUnsignedIntegerAsLong(this.m_istream);
        }
        if ((n = this.m_scanner.m_binaryChunkSize) == -1) {
            n = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        } else if ((long)n > l) {
            n = (int)l;
        }
        if (this.m_resetBeforeScan) {
            this.m_octetBuffer.nextIndex = 0;
        }
        this.m_octetBuffer.ensureOctets(n);
        int n2 = this.m_octetBuffer.allocOctets(n);
        byte[] byArray = this.m_octetBuffer.octets;
        for (int i = 0; i < n; ++i) {
            byArray[n2 + i] = (byte)this.m_scanner.readEightBitsUnsigned(this.m_istream);
        }
        if (binaryDataSource == null) {
            binaryDataSource = new BinaryDataSource();
        }
        binaryDataSource.setValues(byArray, n2, n, this, l - (long)n);
        return binaryDataSource;
    }
}

