/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import org.openexi.schema.Characters;

public final class CharacterBuffer {
    public static final int BUFSIZE_DEFAULT = 4096;
    public final boolean isVolatile;
    public char[] characters;
    public int bufSize;
    public int nextIndex;

    public CharacterBuffer(int n) {
        this(n, true);
    }

    public CharacterBuffer(boolean bl) {
        this(4096, bl);
    }

    public CharacterBuffer(int n, boolean bl) {
        this.isVolatile = bl;
        this.characters = new char[n];
        this.bufSize = n;
        this.nextIndex = 0;
    }

    public int availability() {
        return this.bufSize - this.nextIndex;
    }

    public void ensureCharacters(int n) {
        int n2 = n - this.availability();
        if (n2 > 0) {
            int n3 = this.bufSize >> 1;
            int n4 = n2 < n3 ? n3 : (n2 < this.bufSize ? this.bufSize : n2 + n3);
            int n5 = this.bufSize + n4;
            char[] cArray = new char[n5];
            System.arraycopy(this.characters, 0, cArray, 0, this.nextIndex);
            this.characters = cArray;
            this.bufSize = n5;
        }
    }

    public int allocCharacters(int n) {
        int n2 = this.nextIndex + n;
        if (n2 > this.bufSize) {
            return -1;
        }
        int n3 = this.nextIndex;
        this.nextIndex = n2;
        return n3;
    }

    public void redeemCharacters(int n) {
        this.nextIndex -= n;
    }

    public Characters addChars(char[] cArray, int n) {
        int n2;
        int n3;
        int n4 = n3 = this.nextIndex;
        for (n2 = 0; n2 < n && n4 < this.bufSize; ++n2, ++n4) {
            this.characters[n4] = cArray[n2];
        }
        if (n2 != n) {
            return null;
        }
        this.nextIndex = n4;
        return new Characters(this.characters, n3, n, this.isVolatile);
    }

    public Characters addCharsReverse(char[] cArray, int n) {
        int n2;
        int n3;
        int n4 = n3 = this.nextIndex;
        int n5 = n - 1;
        for (n2 = 0; n2 < n && n4 < this.bufSize; ++n2, ++n4) {
            this.characters[n4] = cArray[n5 - n2];
        }
        if (n2 != n) {
            return null;
        }
        this.nextIndex = n4;
        return new Characters(this.characters, n3, n, this.isVolatile);
    }

    public Characters addDecimalChars(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        int n4;
        int n5 = n4 = this.nextIndex;
        int n6 = n - 1;
        int n7 = 0;
        while (n7 < n) {
            this.characters[n5] = cArray[n6 - n7];
            ++n7;
            ++n5;
        }
        this.characters[n5++] = 46;
        n7 = 0;
        while (n7 < n2) {
            this.characters[n5] = cArray2[n7];
            ++n7;
            ++n5;
        }
        this.nextIndex = n5;
        return new Characters(this.characters, n4, n3, this.isVolatile);
    }

    public Characters addString(String string, int n) {
        int n2;
        int n3;
        int n4 = n3 = this.nextIndex;
        for (n2 = 0; n2 < n && n4 < this.bufSize; ++n2, ++n4) {
            this.characters[n4] = string.charAt(n2);
        }
        if (n2 != n) {
            return null;
        }
        this.nextIndex = n4;
        return new Characters(this.characters, n3, n, this.isVolatile);
    }
}

