/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.lang.reflect.Constructor;
import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.io.BitPackedScanner;
import org.openexi.proc.io.ByteAlignedScanner;
import org.openexi.proc.io.Scanner;

public final class ScannerFactory {
    private static final Constructor<?> m_channellingScannerConstructor;

    public static Scanner createScanner(AlignmentType alignmentType, int n, boolean bl) {
        Scanner scanner;
        switch (alignmentType) {
            case bitPacked: {
                scanner = new BitPackedScanner(false);
                break;
            }
            case byteAligned: {
                scanner = new ByteAlignedScanner();
                break;
            }
            case preCompress: {
                if (m_channellingScannerConstructor != null) {
                    try {
                        scanner = (Scanner)m_channellingScannerConstructor.newInstance(Boolean.FALSE, bl);
                        break;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                return null;
            }
            case compress: {
                if (m_channellingScannerConstructor != null) {
                    try {
                        scanner = (Scanner)m_channellingScannerConstructor.newInstance(Boolean.TRUE, bl);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                } else {
                    return null;
                }
                scanner.init(n);
                break;
            }
            default: {
                return null;
            }
        }
        return scanner;
    }

    public static BitPackedScanner createHeaderOptionsScanner() {
        return new BitPackedScanner(true);
    }

    static {
        Constructor<?> constructor;
        block3: {
            ClassLoader classLoader = ScannerFactory.class.getClassLoader();
            constructor = null;
            try {
                Class<?> clazz = classLoader.loadClass("org.openexi.proc.io.compression.ChannellingScanner");
                constructor = clazz.getConstructor(Boolean.TYPE, Boolean.TYPE);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        m_channellingScannerConstructor = constructor;
    }
}

