/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import org.openexi.proc.common.QName;
import org.openexi.proc.common.StringTable;
import org.openexi.proc.io.Scanner;
import org.openexi.proc.io.ValueScannerBase;
import org.openexi.schema.Characters;

final class StringValueScanner
extends ValueScannerBase {
    private final Scanner m_scanner;
    private StringTable.GlobalValuePartition m_globalValuePartition;
    private int m_valueMaxExclusiveLength;

    protected StringValueScanner(Scanner scanner) {
        super(new QName("exi:string", "http://www.w3.org/2009/exi"));
        this.m_scanner = scanner;
        this.m_valueMaxExclusiveLength = Integer.MAX_VALUE;
    }

    public short getCodecID() {
        return 15;
    }

    void setStringTable(StringTable stringTable) {
        this.m_globalValuePartition = stringTable.globalValuePartition;
    }

    public void setValueMaxLength(int n) {
        assert (n >= 0);
        this.m_valueMaxExclusiveLength = n != Integer.MAX_VALUE ? n + 1 : Integer.MAX_VALUE;
    }

    public Characters scan(int n, int n2, int n3) throws IOException {
        int n4 = this.m_scanner.readUnsignedInteger(this.m_istream);
        if ((n4 & 0xFFFFFFFE) != 0) {
            if ((n4 -= 2) != 0) {
                Characters characters = this.m_scanner.readLiteralString(n4, n3, this.m_istream);
                if (n4 < this.m_valueMaxExclusiveLength) {
                    this.m_globalValuePartition.addValue(characters, n, n2);
                }
                return characters;
            }
            return Characters.CHARACTERS_EMPTY;
        }
        if (n4 == 0) {
            StringTable.LocalValuePartition localValuePartition = this.m_globalValuePartition.getLocalPartition(n, n2);
            int n5 = this.m_scanner.readNBitUnsigned(localValuePartition.width, this.m_istream);
            return localValuePartition.valueEntries[n5].value;
        }
        int n6 = this.m_scanner.readNBitUnsigned(this.m_globalValuePartition.width, this.m_istream);
        return this.m_globalValuePartition.valueEntries[n6].value;
    }
}

