/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io.compression;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class EXIInflaterInputStreamThreaded
extends FilterInputStream {
    private final Inflater m_inflater;
    private final OutputBuffer[] alternateBuffers;
    private final EXIInflator m_exiInflator;
    private int m_bufferIndex;
    private Exception m_inflatorException;
    private final byte[] m_bytes;
    private int m_bufLen;
    private int m_curPos;

    public EXIInflaterInputStreamThreaded(InputStream inputStream, Inflater inflater, int n) {
        super(inputStream);
        this.m_inflater = inflater;
        this.alternateBuffers = new OutputBuffer[2];
        this.alternateBuffers[0] = new OutputBuffer(n * 200);
        this.alternateBuffers[1] = new OutputBuffer(n * 200);
        this.m_bufferIndex = 0;
        this.m_bytes = new byte[8192];
        this.m_bufLen = 0;
        this.m_curPos = 0;
        this.m_exiInflator = new EXIInflator(n);
        new Thread(this.m_exiInflator).start();
    }

    private int fill() throws IOException {
        assert (this.m_curPos == this.m_bufLen);
        this.m_curPos = 0;
        this.m_bufLen = this.read(this.m_bytes, 0, this.m_bytes.length);
        if (this.m_bufLen == -1) {
            this.m_bufLen = 0;
            return -1;
        }
        return this.m_bufLen;
    }

    public int read() throws IOException {
        if (this.m_curPos == this.m_bufLen && this.fill() == -1) {
            return -1;
        }
        return this.m_bytes[this.m_curPos++] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void close() throws IOException {
        int n = 0;
        while (true) {
            OutputBuffer outputBuffer;
            if (n >= 2) {
                super.close();
                return;
            }
            OutputBuffer outputBuffer2 = outputBuffer = this.alternateBuffers[n];
            // MONITORENTER : outputBuffer
            outputBuffer.quit = true;
            outputBuffer.notify();
            // MONITOREXIT : outputBuffer2
            ++n;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        OutputBuffer outputBuffer;
        int n3 = n + n2;
        int n4 = n;
        OutputBuffer outputBuffer2 = outputBuffer = this.alternateBuffers[this.m_bufferIndex];
        synchronized (outputBuffer) {
            try {
                Status status;
                while ((status = outputBuffer.status) == Status.doInflate) {
                    ++outputBuffer.waitCount;
                    outputBuffer.wait();
                    --outputBuffer.waitCount;
                }
                switch (status) {
                    case dataAvailable: {
                        break;
                    }
                    case none: {
                        // ** MonitorExit[var7_7] (shouldn't be in output)
                        return -1;
                    }
                    case errorFormat: {
                        DataFormatException dataFormatException = (DataFormatException)this.m_inflatorException;
                        this.m_inflatorException = null;
                        outputBuffer.status = Status.none;
                        outputBuffer.quit = true;
                        outputBuffer.notify();
                        throw new IOException(dataFormatException.getMessage());
                    }
                    case errorInteruption: {
                        InterruptedException interruptedException = (InterruptedException)this.m_inflatorException;
                        this.m_inflatorException = null;
                        outputBuffer.status = Status.none;
                        outputBuffer.quit = true;
                        throw interruptedException;
                    }
                    case errorIO: {
                        IOException iOException = (IOException)this.m_inflatorException;
                        this.m_inflatorException = null;
                        outputBuffer.status = Status.none;
                        outputBuffer.quit = true;
                        outputBuffer.notify();
                        throw iOException;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                assert (outputBuffer.status == Status.dataAvailable);
                while (outputBuffer.offset != outputBuffer.limit && n4 != n3) {
                    byArray[n4++] = outputBuffer.bts[outputBuffer.offset++];
                }
                if (outputBuffer.offset == outputBuffer.limit) {
                    if (outputBuffer.endOfStream) {
                        outputBuffer.status = Status.none;
                    } else {
                        outputBuffer.status = Status.doInflate;
                        this.m_bufferIndex = 1 - this.m_bufferIndex;
                        if (outputBuffer.waitCount > 0) {
                            outputBuffer.notify();
                        }
                    }
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return n4 - n;
            }
            catch (InterruptedException interruptedException) {
                outputBuffer.status = Status.none;
                outputBuffer.quit = true;
                outputBuffer.notify();
                throw new IOException(interruptedException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        none,
        doInflate,
        dataAvailable,
        errorFormat,
        errorInteruption,
        errorIO;

    }

    private class OutputBuffer {
        final byte[] bts;
        int offset;
        int limit;
        int waitCount;
        boolean quit;
        Status status;
        boolean endOfStream;

        OutputBuffer(int n) {
            this.bts = new byte[n];
            this.limit = 0;
            this.offset = 0;
            this.waitCount = 0;
            this.quit = false;
            this.status = Status.doInflate;
            this.endOfStream = false;
        }
    }

    private class EXIInflator
    implements Runnable {
        private final byte[] inputBuffer;
        private int inputOffset;
        private int inputLimit;
        private int outputBufferIndex;
        private final int m_quorum;

        public EXIInflator(int n) {
            this.inputBuffer = new byte[n];
            this.m_quorum = 199 * n;
            this.inputLimit = 0;
            this.inputOffset = 0;
            this.outputBufferIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            OutputBuffer outputBuffer = null;
            try {
                while (true) {
                    OutputBuffer outputBuffer2 = outputBuffer = EXIInflaterInputStreamThreaded.this.alternateBuffers[this.outputBufferIndex];
                    // MONITORENTER : outputBuffer
                    boolean bl = false;
                    while (outputBuffer.status != Status.doInflate || (bl = outputBuffer.quit)) {
                        ++outputBuffer.waitCount;
                        outputBuffer.wait();
                        --outputBuffer.waitCount;
                    }
                    if (bl) {
                        // MONITOREXIT : outputBuffer2
                        return;
                    }
                    assert (outputBuffer.offset == outputBuffer.limit);
                    outputBuffer.limit = 0;
                    outputBuffer.offset = 0;
                    while (outputBuffer.limit < this.m_quorum) {
                        int n;
                        if (EXIInflaterInputStreamThreaded.this.m_inflater.finished()) {
                            EXIInflaterInputStreamThreaded.this.m_inflater.reset();
                        }
                        if ((n = EXIInflaterInputStreamThreaded.super.read(this.inputBuffer, this.inputLimit, this.inputBuffer.length - this.inputLimit)) != -1) {
                            this.inputLimit += n;
                        } else if (this.inputLimit - this.inputOffset == 0) {
                            EXIInflaterInputStreamThreaded.this.m_inflater.reset();
                            outputBuffer.endOfStream = true;
                            outputBuffer.status = Status.dataAvailable;
                            if (outputBuffer.waitCount > 0) {
                                outputBuffer.notify();
                            }
                            // MONITOREXIT : outputBuffer2
                            return;
                        }
                        EXIInflaterInputStreamThreaded.this.m_inflater.setInput(this.inputBuffer, this.inputOffset, this.inputLimit - this.inputOffset);
                        int n2 = EXIInflaterInputStreamThreaded.this.m_inflater.inflate(outputBuffer.bts, outputBuffer.limit, outputBuffer.bts.length - outputBuffer.limit);
                        outputBuffer.limit += n2;
                        int n3 = EXIInflaterInputStreamThreaded.this.m_inflater.getRemaining();
                        if (n3 == 0) {
                            this.inputLimit = 0;
                            this.inputOffset = 0;
                            continue;
                        }
                        this.inputOffset += this.inputLimit - this.inputOffset - n3;
                    }
                    outputBuffer.status = Status.dataAvailable;
                    this.outputBufferIndex = 1 - this.outputBufferIndex;
                    if (outputBuffer.waitCount > 0) {
                        outputBuffer.notify();
                    }
                    // MONITOREXIT : outputBuffer2
                }
            }
            catch (DataFormatException dataFormatException) {
                EXIInflaterInputStreamThreaded.this.m_inflatorException = dataFormatException;
                outputBuffer.status = Status.errorFormat;
                return;
            }
            catch (InterruptedException interruptedException) {
                EXIInflaterInputStreamThreaded.this.m_inflatorException = interruptedException;
                outputBuffer.status = Status.errorInteruption;
                return;
            }
            catch (IOException iOException) {
                EXIInflaterInputStreamThreaded.this.m_inflatorException = iOException;
                outputBuffer.status = Status.errorIO;
            }
        }
    }
}

