/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream {
    private int putCount = 8;
    private int bitBuf = 0;
    private final OutputStream m_out;

    BitOutputStream(OutputStream outputStream) {
        this.m_out = outputStream;
    }

    private static int rightBits(int n, int n2) {
        return n2 & (1 << n) - 1;
    }

    public void putBit(boolean bl) throws IOException {
        --this.putCount;
        if (bl) {
            this.bitBuf |= 1 << this.putCount;
        }
        if (this.putCount == 0) {
            this.m_out.write(this.bitBuf);
            this.bitBuf = 0;
            this.putCount = 8;
        }
    }

    public void putBits(int n, int n2) throws IOException {
        while (n >= this.putCount) {
            this.bitBuf |= BitOutputStream.rightBits(this.putCount, n2 >>> (n -= this.putCount));
            this.m_out.write(this.bitBuf);
            this.bitBuf = 0;
            this.putCount = 8;
        }
        this.putCount -= n;
        this.bitBuf |= BitOutputStream.rightBits(n, n2) << this.putCount;
    }

    public void flush() throws IOException {
        if (this.putCount != 8) {
            this.putBits(this.putCount, 0);
        }
        this.m_out.flush();
    }
}

