/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.Scriber;
import org.openexi.proc.io.ValueScriber;
import org.openexi.proc.io.ValueScriberBase;
import org.openexi.schema.EXISchema;

final class ListValueScriber
extends ValueScriberBase {
    private final ArrayList<String> stringItems = new ArrayList();
    private final StringBuffer stringBuffer = new StringBuffer();

    public ListValueScriber() {
        super(null);
    }

    public short getCodecID() {
        return 16;
    }

    public int getBuiltinRCS(int n, Scriber scriber) {
        EXISchema eXISchema = scriber.schema;
        assert (eXISchema.getVarietyOfSimpleType(n) == 2);
        int n2 = eXISchema.getItemTypeOfListSimpleType(n);
        ValueScriber valueScriber = scriber.getValueScriber(n2);
        return valueScriber.getBuiltinRCS(n2, scriber);
    }

    public boolean process(String string, int n, EXISchema eXISchema, Scribble scribble, Scriber scriber) {
        assert (eXISchema.getVarietyOfSimpleType(n) == 2);
        int n2 = eXISchema.getItemTypeOfListSimpleType(n);
        this.stringItems.clear();
        int n3 = string.length();
        boolean bl = true;
        block3: for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (bl) continue block3;
                    this.stringItems.add(this.stringBuffer.toString());
                    this.stringBuffer.setLength(0);
                    bl = true;
                    continue block3;
                }
                default: {
                    if (bl) {
                        bl = false;
                    }
                    this.stringBuffer.append(c);
                }
            }
        }
        if (!bl) {
            assert (this.stringBuffer.length() > 0);
            this.stringItems.add(this.stringBuffer.toString());
            this.stringBuffer.setLength(0);
        }
        ValueScriber valueScriber = scriber.getValueScriber(n2);
        int n4 = this.stringItems.size();
        if (n4 != 0) {
            int n5;
            if (scribble.listOfScribbles == null) {
                scribble.listOfScribbles = new Scribble[n4];
                for (n5 = 0; n5 < n4; ++n5) {
                    scribble.listOfScribbles[n5] = new Scribble();
                }
            } else {
                n5 = scribble.listOfScribbles.length;
                if (n5 < n4) {
                    int n6 = n5;
                    while ((n6 <<= 1) < n4) {
                    }
                    Scribble[] scribbleArray = new Scribble[n6];
                    System.arraycopy(scribble.listOfScribbles, 0, scribbleArray, 0, n5);
                    for (int i = n5; i < n6; ++i) {
                        scribbleArray[i] = new Scribble();
                    }
                    scribble.listOfScribbles = scribbleArray;
                }
            }
            n5 = 0;
            do {
                Scribble scribble2 = scribble.listOfScribbles[n5];
                if (valueScriber.process(this.stringItems.get(n5), n2, eXISchema, scribble2, scriber)) continue;
                return false;
            } while (++n5 < n4);
        }
        scribble.intValue1 = n4;
        scribble.valueScriber = valueScriber;
        return true;
    }

    public void scribe(String string, Scribble scribble, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        this.scribeListValue(scribble.intValue1, scribble.listOfScribbles, scribble.valueScriber, n, n2, n3, outputStream, scriber);
    }

    public Object toValue(String string, Scribble scribble, Scriber scriber) {
        int n = scribble.intValue1;
        Scribble[] scribbleArray = new Scribble[n];
        for (int i = 0; i < n; ++i) {
            scribbleArray[i] = new Scribble(scribble.listOfScribbles[i]);
        }
        ValueScriber valueScriber = scribble.valueScriber;
        return new ListValue(n, scribbleArray, valueScriber);
    }

    public void doScribe(Object object, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        ListValue listValue = (ListValue)object;
        this.scribeListValue(listValue.n_items, listValue.listOfScribbles, listValue.itemValueScriber, n, n2, n3, outputStream, scriber);
    }

    private void scribeListValue(int n, Scribble[] scribbleArray, ValueScriber valueScriber, int n2, int n3, int n4, OutputStream outputStream, Scriber scriber) throws IOException {
        EXISchema eXISchema = scriber.schema;
        scriber.writeUnsignedInteger32(n, outputStream);
        int n5 = eXISchema.getItemTypeOfListSimpleType(n4);
        for (int i = 0; i < n; ++i) {
            Scribble scribble = scribbleArray[i];
            valueScriber.scribe(scribble.stringValue1, scribble, n2, n3, n5, outputStream, scriber);
        }
    }

    private static class ListValue {
        int n_items;
        Scribble[] listOfScribbles;
        ValueScriber itemValueScriber;

        ListValue(int n, Scribble[] scribbleArray, ValueScriber valueScriber) {
            this.n_items = n;
            this.listOfScribbles = scribbleArray;
            this.itemValueScriber = valueScriber;
        }
    }
}

