/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io.compression;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.Inflater;
import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.common.Channel;
import org.openexi.proc.common.EventCode;
import org.openexi.proc.common.EventDescription;
import org.openexi.proc.common.EventType;
import org.openexi.proc.common.EventTypeList;
import org.openexi.proc.events.EXIEventComment;
import org.openexi.proc.events.EXIEventDTD;
import org.openexi.proc.events.EXIEventEntityReference;
import org.openexi.proc.events.EXIEventProcessingInstruction;
import org.openexi.proc.events.EXIEventSchemaNil;
import org.openexi.proc.events.EXIEventWildcardStartElement;
import org.openexi.proc.grammars.EventCodeTuple;
import org.openexi.proc.grammars.EventTypeSchema;
import org.openexi.proc.io.ByteAlignedCommons;
import org.openexi.proc.io.Scanner;
import org.openexi.proc.io.compression.ChannelKeeper;
import org.openexi.proc.io.compression.EXIEventElement;
import org.openexi.proc.io.compression.EXIEventValueReference;
import org.openexi.proc.io.compression.EXIInflaterInputStream;
import org.openexi.proc.io.compression.EXIInflaterInputStreamThreaded;
import org.openexi.proc.io.compression.ScannerChannel;
import org.openexi.proc.io.compression.ScannerChannelFactory;
import org.openexi.schema.Characters;

public final class ChannellingScanner
extends Scanner {
    private final ChannelKeeper m_channelKeeper;
    private EventDescription[] m_eventList;
    private int m_n_events;
    private final boolean m_compressed;
    private final Inflater m_inflater;
    private int m_bufSize;
    private final boolean m_useThreadedInflater;
    private boolean m_foundED;
    private int m_n_blocks;
    private int m_eventIndex;
    private int n_elements;
    private EXIEventElement[] m_elementEvents;
    private EXIEventValueReference[] m_valueEvents;

    public ChannellingScanner(boolean bl, boolean bl2) {
        super(false);
        this.m_compressed = bl;
        this.m_inflater = this.m_compressed ? new Inflater(true) : null;
        this.m_useThreadedInflater = bl2;
        this.m_eventList = new EventDescription[8192];
        this.m_n_events = 0;
        this.m_channelKeeper = new ChannelKeeper(new ScannerChannelFactory());
        this.m_valueEvents = new EXIEventValueReference[8192];
        this.m_elementEvents = new EXIEventElement[4096];
    }

    protected void init(int n) {
        this.m_bufSize = this.m_compressed ? n : -1;
    }

    public void reset() {
        super.reset();
        this.m_foundED = false;
        this.m_n_blocks = 0;
        this.m_n_events = 0;
        this.m_eventIndex = 0;
        this.m_channelKeeper.reset();
    }

    public void setInputStream(InputStream inputStream) {
        if (this.m_compressed) {
            this.m_inflater.reset();
            if (this.m_useThreadedInflater) {
                super.setInputStream(this.m_compressed ? new EXIInflaterInputStreamThreaded(inputStream, this.m_inflater, this.m_bufSize) : inputStream);
            } else {
                super.setInputStream(new EXIInflaterInputStream(inputStream, this.m_inflater, this.m_bufSize));
            }
        } else {
            super.setInputStream(inputStream);
        }
    }

    public final void prepare() throws IOException {
        super.prepare();
        this.processBlock();
    }

    public final void setBlockSize(int n) {
        EventDescription[] eventDescriptionArray;
        this.m_channelKeeper.setBlockSize(n);
        if (this.m_valueEvents.length < n) {
            eventDescriptionArray = new EXIEventValueReference[n];
            System.arraycopy(this.m_valueEvents, 0, eventDescriptionArray, 0, this.m_valueEvents.length);
            this.m_valueEvents = eventDescriptionArray;
        }
        if (this.m_elementEvents.length < n) {
            eventDescriptionArray = new EXIEventElement[n];
            System.arraycopy(this.m_elementEvents, 0, eventDescriptionArray, 0, this.m_elementEvents.length);
            this.m_elementEvents = eventDescriptionArray;
        }
    }

    public final int getBlockCount() {
        return this.m_n_blocks;
    }

    public final void setBinaryChunkSize(int n) {
        throw new UnsupportedOperationException("Setting binary chunk size is not supported.");
    }

    public EventDescription nextEvent() throws IOException {
        if (this.m_eventIndex < this.m_n_events) {
            return this.m_eventList[this.m_eventIndex++];
        }
        if (!this.m_foundED) {
            this.processBlock();
            return this.nextEvent();
        }
        return null;
    }

    private void readValueChannels() throws IOException {
        int n;
        Object object;
        ScannerChannel scannerChannel;
        this.m_characterBuffer.nextIndex = 0;
        if (this.m_binaryDataEnabled) {
            this.octetBuffer.nextIndex = 0;
        }
        this.m_channelKeeper.finish();
        Iterator<Channel> iterator = this.m_channelKeeper.getSmallChannels().iterator();
        if (iterator.hasNext()) {
            if (this.m_compressed && this.m_channelKeeper.getTotalValueCount() > 100 && !this.m_useThreadedInflater) {
                ((EXIInflaterInputStream)this.m_inputStream).resetInflator();
            }
            do {
                scannerChannel = (ScannerChannel)iterator.next();
                object = scannerChannel.values;
                int n2 = object.size();
                for (n = 0; n < n2; ++n) {
                    ((EXIEventValueReference)object.get(n)).scanText(this, this.m_binaryDataEnabled, this.m_inputStream);
                }
            } while (iterator.hasNext());
        }
        object = this.m_channelKeeper.getLargeChannels().iterator();
        while (object.hasNext()) {
            if (this.m_compressed && !this.m_useThreadedInflater) {
                ((EXIInflaterInputStream)this.m_inputStream).resetInflator();
            }
            scannerChannel = (ScannerChannel)object.next();
            ArrayList<EXIEventValueReference> arrayList = scannerChannel.values;
            n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ((EXIEventValueReference)arrayList.get(i)).scanText(this, this.m_binaryDataEnabled, this.m_inputStream);
            }
        }
        if (this.m_compressed && !this.m_useThreadedInflater) {
            ((EXIInflaterInputStream)this.m_inputStream).resetInflator();
        }
    }

    private void readStructureChannel() throws IOException {
        block50: {
            int n;
            Object object;
            String string;
            EventType eventType;
            int n2;
            EventCodeTuple eventCodeTuple;
            int n3 = 0;
            this.n_elements = 0;
            boolean bl = false;
            block27: while (!bl && (eventCodeTuple = this.getNextEventCodes()) != null) {
                Object object2;
                while (true) {
                    object2 = (n2 = eventCodeTuple.width) != 0 ? eventCodeTuple.getItem(this.readNBitUnsigned(n2, this.m_inputStream)) : eventCodeTuple.getItem(0);
                    if (((EventCode)object2).itemType != -1) break;
                    eventCodeTuple = (EventCodeTuple)object2;
                }
                eventType = (EventType)object2;
                byte by = eventType.itemType;
                switch (by) {
                    case 13: {
                        this.currentState.targetGrammar.startDocument(this.currentState);
                        this.addEvent(eventType.asEventDescription());
                        continue block27;
                    }
                    case 10: {
                        object2 = this.readText().makeString();
                        Characters characters = this.readText();
                        string = characters.length != 0 ? characters.makeString() : null;
                        characters = this.readText();
                        object = characters.length != 0 ? characters.makeString() : null;
                        characters = this.readText();
                        characters.turnPermanent();
                        this.addEvent(new EXIEventDTD((String)object2, string, (String)object, characters, eventType));
                        continue block27;
                    }
                    case 11: {
                        this.doElement(eventType);
                        continue block27;
                    }
                    case 12: 
                    case 16: {
                        int n4 = eventType.getURIId();
                        int n5 = eventType.getNameId();
                        String string2 = this.m_preserveNS ? this.readPrefixOfQName(n4) : null;
                        this.attribute(eventType);
                        if (by == 12 && n4 == 2 && n5 == 1) {
                            this.addEvent(this.readXsiTypeValue(string2, eventType));
                            continue block27;
                        }
                        int n6 = by == 16 ? ((EventTypeSchema)eventType).nd : -1;
                        EXIEventValueReference eXIEventValueReference = this.m_valueEvents[n3];
                        if (eXIEventValueReference == null) {
                            this.m_valueEvents[n3] = eXIEventValueReference = new EXIEventValueReference();
                        }
                        ScannerChannel scannerChannel = (ScannerChannel)this.m_channelKeeper.getChannel(n5, n4, this.stringTable);
                        bl = this.m_channelKeeper.incrementValueCount(scannerChannel);
                        scannerChannel.values.add(eXIEventValueReference);
                        eXIEventValueReference.nameId = n5;
                        eXIEventValueReference.uriId = n4;
                        eXIEventValueReference.tp = n6;
                        eXIEventValueReference.eventKind = (byte)3;
                        eXIEventValueReference.eventType = eventType;
                        eXIEventValueReference.prefix = string2;
                        eXIEventValueReference.uri = eventType.uri;
                        eXIEventValueReference.name = eventType.name;
                        eXIEventValueReference.text = null;
                        eXIEventValueReference.binaryData = null;
                        this.addEvent(eXIEventValueReference);
                        ++n3;
                        continue block27;
                    }
                    case 23: {
                        int n4 = eventType.getURIId();
                        int n5 = eventType.getNameId();
                        String string3 = this.m_preserveNS ? this.readPrefixOfQName(n4) : null;
                        EXIEventValueReference eXIEventValueReference = this.m_valueEvents[n3];
                        if (eXIEventValueReference == null) {
                            this.m_valueEvents[n3] = eXIEventValueReference = new EXIEventValueReference();
                        }
                        ScannerChannel scannerChannel = (ScannerChannel)this.m_channelKeeper.getChannel(n5, n4, this.stringTable);
                        bl = this.m_channelKeeper.incrementValueCount(scannerChannel);
                        scannerChannel.values.add(eXIEventValueReference);
                        this.attribute(eventType);
                        eXIEventValueReference.nameId = n5;
                        eXIEventValueReference.uriId = n4;
                        eXIEventValueReference.tp = -1;
                        eXIEventValueReference.eventKind = (byte)3;
                        eXIEventValueReference.eventType = eventType;
                        eXIEventValueReference.prefix = string3;
                        eXIEventValueReference.uri = eventType.uri;
                        eXIEventValueReference.name = eventType.name;
                        eXIEventValueReference.text = null;
                        eXIEventValueReference.binaryData = null;
                        this.addEvent(eXIEventValueReference);
                        ++n3;
                        continue block27;
                    }
                    case 19: {
                        EXIEventValueReference eXIEventValueReference = this.m_valueEvents[n3];
                        if (eXIEventValueReference == null) {
                            this.m_valueEvents[n3] = eXIEventValueReference = new EXIEventValueReference();
                        }
                        bl = this.doCharactersTyped(eXIEventValueReference, eventType);
                        this.addEvent(eXIEventValueReference);
                        ++n3;
                        continue block27;
                    }
                    case 20: {
                        this.undeclaredCharacters(eventType.getIndex());
                        EXIEventValueReference eXIEventValueReference = this.m_valueEvents[n3];
                        if (eXIEventValueReference == null) {
                            this.m_valueEvents[n3] = eXIEventValueReference = new EXIEventValueReference();
                        }
                        int n7 = this.m_nameLocusStack[this.m_nameLocusLastDepth];
                        n = this.m_nameLocusStack[this.m_nameLocusLastDepth + 1];
                        ScannerChannel scannerChannel = (ScannerChannel)this.m_channelKeeper.getChannel(n7, n, this.stringTable);
                        bl = this.m_channelKeeper.incrementValueCount(scannerChannel);
                        scannerChannel.values.add(eXIEventValueReference);
                        eXIEventValueReference.nameId = n7;
                        eXIEventValueReference.uriId = n;
                        eXIEventValueReference.tp = -1;
                        eXIEventValueReference.eventKind = (byte)6;
                        eXIEventValueReference.eventType = eventType;
                        eXIEventValueReference.prefix = null;
                        eXIEventValueReference.uri = null;
                        eXIEventValueReference.name = "#text";
                        eXIEventValueReference.text = null;
                        eXIEventValueReference.binaryData = null;
                        this.addEvent(eXIEventValueReference);
                        ++n3;
                        continue block27;
                    }
                    case 3: {
                        this.undeclaredCharacters(eventType.getIndex());
                        EXIEventValueReference eXIEventValueReference = this.m_valueEvents[n3];
                        if (eXIEventValueReference == null) {
                            this.m_valueEvents[n3] = eXIEventValueReference = new EXIEventValueReference();
                        }
                        int n7 = this.m_nameLocusStack[this.m_nameLocusLastDepth];
                        n = this.m_nameLocusStack[this.m_nameLocusLastDepth + 1];
                        ScannerChannel scannerChannel = (ScannerChannel)this.m_channelKeeper.getChannel(n7, n, this.stringTable);
                        bl = this.m_channelKeeper.incrementValueCount(scannerChannel);
                        scannerChannel.values.add(eXIEventValueReference);
                        eXIEventValueReference.nameId = n7;
                        eXIEventValueReference.uriId = n;
                        eXIEventValueReference.tp = -1;
                        eXIEventValueReference.eventKind = (byte)6;
                        eXIEventValueReference.eventType = eventType;
                        eXIEventValueReference.prefix = null;
                        eXIEventValueReference.uri = null;
                        eXIEventValueReference.name = "#text";
                        eXIEventValueReference.text = null;
                        eXIEventValueReference.binaryData = null;
                        this.addEvent(eXIEventValueReference);
                        ++n3;
                        continue block27;
                    }
                    case 9: {
                        if (eventType.depth != 1) {
                            this.currentState.targetGrammar.end(this.currentState);
                        }
                        this.currentState = this.m_statesStack[--this.m_n_stackedStates - 1];
                        this.m_nameLocusLastDepth -= 2;
                        if (this.m_preserveNS) {
                            --this.m_prefixUriBindingsLocusLastDepth;
                        }
                        this.addEvent(eventType.asEventDescription());
                        continue block27;
                    }
                    case 4: {
                        this.currentState.targetGrammar.endDocument(this.currentState);
                        this.addEvent(eventType.asEventDescription());
                        this.m_foundED = true;
                        continue block27;
                    }
                    case 15: {
                        this.m_characterBuffer.nextIndex = 0;
                        this.doElementWildcard(eventType.getURIId(), eventType);
                        continue block27;
                    }
                    case 5: 
                    case 14: {
                        this.m_characterBuffer.nextIndex = 0;
                        this.doElementWildcard(this.readURI(), eventType);
                        continue block27;
                    }
                    case 8: 
                    case 17: 
                    case 18: {
                        int n8;
                        String string4;
                        EXIEventValueReference eXIEventValueReference;
                        int n4 = by == 18 ? eventType.getURIId() : this.readURI();
                        int n5 = this.readLocalName(this.stringTable.getLocalNamePartition(n4));
                        String string5 = string4 = this.m_preserveNS ? this.readPrefixOfQName(n4) : null;
                        if (by == 8) {
                            this.wildcardAttribute(eventType.getIndex(), n4, n5);
                        }
                        if (n4 == 2 && n5 == 1) {
                            assert (by == 8);
                            this.addEvent(this.readXsiTypeValue(string4, eventType));
                            continue block27;
                        }
                        String string6 = this.stringTable.getURI(n4);
                        String string7 = this.stringTable.getLocalNamePartition((int)n4).localNameEntries[n5].localName;
                        int n9 = -1;
                        if (by != 8 && (n8 = this.schema.getGlobalAttrOfSchema(string6, string7)) != -1) {
                            n9 = this.schema.getTypeOfAttr(n8);
                        }
                        if ((eXIEventValueReference = this.m_valueEvents[n3]) == null) {
                            this.m_valueEvents[n3] = eXIEventValueReference = new EXIEventValueReference();
                        }
                        ScannerChannel scannerChannel = (ScannerChannel)this.m_channelKeeper.getChannel(n5, n4, this.stringTable);
                        bl = this.m_channelKeeper.incrementValueCount(scannerChannel);
                        scannerChannel.values.add(eXIEventValueReference);
                        eXIEventValueReference.nameId = n5;
                        eXIEventValueReference.uriId = n4;
                        eXIEventValueReference.tp = n9;
                        eXIEventValueReference.eventKind = (byte)3;
                        eXIEventValueReference.eventType = eventType;
                        eXIEventValueReference.prefix = string4;
                        eXIEventValueReference.uri = string6;
                        eXIEventValueReference.name = string7;
                        eXIEventValueReference.text = null;
                        eXIEventValueReference.binaryData = null;
                        this.addEvent(eXIEventValueReference);
                        ++n3;
                        continue block27;
                    }
                    case 21: {
                        int n4 = eventType.getURIId();
                        int n5 = eventType.getNameId();
                        String string8 = this.m_preserveNS ? this.readPrefixOfQName(n4) : null;
                        EXIEventSchemaNil eXIEventSchemaNil = this.readXsiNilValue(string8, eventType);
                        if (eXIEventSchemaNil.isNilled()) {
                            this.nillify(eventType.getIndex());
                        }
                        this.addEvent(eXIEventSchemaNil);
                        continue block27;
                    }
                    case 22: {
                        int n4 = eventType.getURIId();
                        int n5 = eventType.getNameId();
                        String string9 = this.m_preserveNS ? this.readPrefixOfQName(n4) : null;
                        this.addEvent(this.readXsiTypeValue(string9, eventType));
                        continue block27;
                    }
                    case 7: {
                        this.addEvent(this.readNS(eventType));
                        continue block27;
                    }
                    case 6: {
                        throw new UnsupportedOperationException("Event type SC is not supported yet.");
                    }
                    case 0: {
                        this.miscContent(eventType.getIndex());
                        object2 = this.readText().makeString();
                        Characters characters = this.readText();
                        characters.turnPermanent();
                        this.addEvent(new EXIEventProcessingInstruction((String)object2, characters, eventType));
                        continue block27;
                    }
                    case 1: {
                        this.miscContent(eventType.getIndex());
                        Characters characters = this.readText();
                        characters.turnPermanent();
                        this.addEvent(new EXIEventComment(characters, eventType));
                        continue block27;
                    }
                    case 2: {
                        this.miscContent(eventType.getIndex());
                        object2 = this.readText().makeString();
                        this.addEvent(new EXIEventEntityReference((String)object2, eventType));
                        continue block27;
                    }
                }
                assert (false);
            }
            if (!bl) break block50;
            block29: while (true) {
                EventTypeList eventTypeList;
                if ((n = (eventTypeList = this.getNextEventTypes()).getLength()) != 1) {
                    assert (n > 1);
                    break;
                }
                eventType = eventTypeList.item(0);
                switch (eventType.itemType) {
                    case 11: {
                        int n10 = eventType.getURIId();
                        n2 = eventType.getNameId();
                        string = this.m_preserveNS ? this.readPrefixOfQName(n10) : null;
                        this.pushLocusItem(n10, n2);
                        this.startElement(eventType);
                        if (this.m_preserveNS) {
                            object = this.m_elementEvents[this.n_elements];
                            if (object == null) {
                                object = new EXIEventElement();
                                this.m_elementEvents[this.n_elements] = object;
                            }
                            ++this.n_elements;
                            ((EXIEventElement)object).prefix = string;
                            ((EXIEventElement)object).eventType = eventType;
                            this.addEvent((EventDescription)object);
                            continue block29;
                        }
                        this.addEvent(eventType.asEventDescription());
                        continue block29;
                    }
                    case 9: {
                        this.endElement();
                        this.m_nameLocusLastDepth -= 2;
                        if (this.m_preserveNS) {
                            --this.m_prefixUriBindingsLocusLastDepth;
                        }
                        this.addEvent(eventType.asEventDescription());
                        continue block29;
                    }
                    case 4: {
                        this.endDocument();
                        this.addEvent(eventType.asEventDescription());
                        this.m_foundED = true;
                    }
                }
                break;
            }
        }
    }

    private void processBlock() throws IOException {
        ++this.m_n_blocks;
        this.m_n_events = 0;
        this.readStructureChannel();
        this.readValueChannels();
        this.m_channelKeeper.punctuate();
        this.m_eventIndex = 0;
    }

    public AlignmentType getAlignmentType() {
        return this.m_compressed ? AlignmentType.compress : AlignmentType.preCompress;
    }

    private boolean doCharactersTyped(EXIEventValueReference eXIEventValueReference, EventType eventType) throws IOException {
        this.currentState.targetGrammar.chars(eventType, this.currentState);
        int n = this.m_nameLocusStack[this.m_nameLocusLastDepth];
        int n2 = this.m_nameLocusStack[this.m_nameLocusLastDepth + 1];
        ScannerChannel scannerChannel = (ScannerChannel)this.m_channelKeeper.getChannel(n, n2, this.stringTable);
        boolean bl = this.m_channelKeeper.incrementValueCount(scannerChannel);
        scannerChannel.values.add(eXIEventValueReference);
        eXIEventValueReference.nameId = n;
        eXIEventValueReference.uriId = n2;
        eXIEventValueReference.tp = this.currentState.contentDatatype;
        eXIEventValueReference.eventKind = (byte)6;
        eXIEventValueReference.eventType = eventType;
        eXIEventValueReference.prefix = null;
        eXIEventValueReference.uri = null;
        eXIEventValueReference.name = "#text";
        eXIEventValueReference.text = null;
        eXIEventValueReference.binaryData = null;
        return bl;
    }

    private void doElement(EventType eventType) throws IOException {
        this.m_characterBuffer.nextIndex = 0;
        int n = eventType.getURIId();
        int n2 = eventType.getNameId();
        this.pushLocusItem(n, n2);
        this.currentState.targetGrammar.element(eventType, this.currentState);
        if (this.m_preserveNS) {
            EXIEventElement eXIEventElement = this.m_elementEvents[this.n_elements];
            if (eXIEventElement == null) {
                this.m_elementEvents[this.n_elements] = eXIEventElement = new EXIEventElement();
            }
            ++this.n_elements;
            eXIEventElement.prefix = this.readPrefixOfQName(n);
            eXIEventElement.eventType = eventType;
            this.addEvent(eXIEventElement);
        } else {
            this.addEvent(eventType.asEventDescription());
        }
    }

    private void doElementWildcard(int n, EventType eventType) throws IOException {
        int n2 = this.readLocalName(this.stringTable.getLocalNamePartition(n));
        String string = this.m_preserveNS ? this.readPrefixOfQName(n) : null;
        this.pushLocusItem(n, n2);
        this.startWildcardElement(eventType.getIndex(), n, n2);
        this.addEvent(new EXIEventWildcardStartElement(this.stringTable.getURI(n), this.stringTable.getLocalNamePartition((int)n).localNameEntries[n2].localName, n, n2, string, eventType));
    }

    protected boolean readBoolean(InputStream inputStream) throws IOException {
        return ByteAlignedCommons.readBoolean(inputStream);
    }

    protected int readNBitUnsigned(int n, InputStream inputStream) throws IOException {
        if (n != 0) {
            return ByteAlignedCommons.readNBitUnsigned(n, inputStream);
        }
        return 0;
    }

    protected int readEightBitsUnsigned(InputStream inputStream) throws IOException {
        return ByteAlignedCommons.readEightBitsUnsigned(inputStream);
    }

    private void pushLocusItem(int n, int n2) {
        this.m_nameLocusLastDepth += 2;
        this.m_nameLocusStack[this.m_nameLocusLastDepth] = n2;
        this.m_nameLocusStack[this.m_nameLocusLastDepth + 1] = n;
        if (this.m_preserveNS) {
            this.m_prefixUriBindingsLocusStack[++this.m_prefixUriBindingsLocusLastDepth] = this.m_prefixUriBindings;
        }
    }

    private void addEvent(EventDescription eventDescription) {
        if (this.m_eventList.length == this.m_n_events) {
            int n = this.m_eventList.length;
            n += n >> 1;
            EventDescription[] eventDescriptionArray = new EventDescription[n];
            System.arraycopy(this.m_eventList, 0, eventDescriptionArray, 0, this.m_eventList.length);
            this.m_eventList = eventDescriptionArray;
        }
        this.m_eventList[this.m_n_events++] = eventDescription;
    }
}

