/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io.compression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openexi.proc.common.Channel;
import org.openexi.proc.common.StringTable;
import org.openexi.proc.io.compression.ChannelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ChannelKeeper {
    private int m_totalValueCount = 0;
    private final LinkedList<Channel> m_smallChannelList = new LinkedList();
    private final ArrayList<Channel> m_largeChannelList = new ArrayList();
    private final ChannelFactory m_channelFactory;
    private int m_blockSize;
    private int m_blockNum;

    ChannelKeeper(ChannelFactory channelFactory) {
        this.m_channelFactory = channelFactory;
        this.m_blockSize = 1000000;
        this.m_blockNum = -1;
    }

    public void punctuate() {
        this.m_totalValueCount = 0;
        this.m_smallChannelList.clear();
        this.m_largeChannelList.clear();
        ++this.m_blockNum;
    }

    public void reset() {
        this.m_blockNum = -1;
        this.punctuate();
    }

    public void finish() {
        Collections.sort(this.m_smallChannelList);
        Collections.sort(this.m_largeChannelList);
    }

    public int getBlockSize() {
        return this.m_blockSize;
    }

    void setBlockSize(int n) {
        this.m_blockSize = n;
    }

    List<Channel> getSmallChannels() {
        return this.m_smallChannelList;
    }

    List<Channel> getLargeChannels() {
        return this.m_largeChannelList;
    }

    int getTotalValueCount() {
        return this.m_totalValueCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Channel getChannel(int n, int n2, StringTable stringTable) {
        StringTable.LocalNamePartition localNamePartition = stringTable.getLocalNamePartition(n2);
        Channel channel = localNamePartition.localNameEntries[n].channel;
        if (channel != null) {
            if (channel.blockNum == this.m_blockNum) return channel;
            channel.reset(this.m_totalValueCount, this.m_blockNum);
        } else {
            channel = this.m_channelFactory.createChannel(this.m_totalValueCount, this.m_blockNum);
            localNamePartition.setChannel(n, channel);
        }
        this.m_smallChannelList.add(channel);
        return channel;
    }

    boolean incrementValueCount(Channel channel) {
        if (++channel.valueCount == 101) {
            this.m_smallChannelList.remove(channel);
            this.m_largeChannelList.add(channel);
        }
        return ++this.m_totalValueCount == this.m_blockSize;
    }
}

