/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io.compression;

import java.io.IOException;
import org.openexi.proc.common.StringTable;
import org.openexi.proc.io.BinaryDataSink;
import org.openexi.proc.io.BinaryValueScriber;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.Scriber;
import org.openexi.proc.io.ScriberRuntimeException;
import org.openexi.proc.io.compression.ChannelKeeper;
import org.openexi.proc.io.compression.ChannellingScriber;
import org.openexi.proc.io.compression.ChannellingValueScriberProxy;
import org.openexi.proc.io.compression.ScriberChannel;
import org.openexi.proc.io.compression.ScriberValueHolder;

final class ChannellingBinaryValueScriberProxy
extends ChannellingValueScriberProxy
implements BinaryDataSink {
    ChannellingBinaryValueScriberProxy(ChannelKeeper channelKeeper, BinaryValueScriber binaryValueScriber) {
        super(channelKeeper, binaryValueScriber);
    }

    public final void startBinaryData(long l, Scribble scribble, Scriber scriber) throws ScriberRuntimeException {
        scribble.intValue1 = 0;
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new ScriberRuntimeException(2, new String[]{Long.toString(l)});
        }
        scribble.intValue2 = (int)l;
        scribble.binaryValue = scribble.expandOctetArray(scribble.intValue2);
    }

    public final void binaryData(byte[] byArray, int n, int n2, Scribble scribble, Scriber scriber) throws IOException {
        System.arraycopy(byArray, n, scribble.binaryValue, scribble.intValue1, n2);
        scribble.intValue1 += n2;
    }

    public final void endBinaryData(Scribble scribble, int n, int n2, Scriber scriber) throws ScriberRuntimeException, IOException {
        if (scribble.intValue1 != scribble.intValue2) {
            throw new ScriberRuntimeException(1);
        }
        StringTable stringTable = scriber.stringTable;
        ScriberChannel scriberChannel = (ScriberChannel)this.m_channelKeeper.getChannel(n, n2, stringTable);
        boolean bl = this.m_channelKeeper.incrementValueCount(scriberChannel);
        scriberChannel.values.add(new ScriberValueHolder(n, n2, -1, this.m_valueScriber.toValue(null, scribble, scriber), this));
        if (bl) {
            ((ChannellingScriber)scriber).finishBlock();
        }
    }
}

