/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.openexi.proc.common.QName;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.Scriber;
import org.openexi.proc.io.ValueScriberBase;
import org.openexi.schema.EXISchema;

public final class IntegerValueScriber
extends ValueScriberBase {
    public static final IntegerValueScriber instance = new IntegerValueScriber();

    private IntegerValueScriber() {
        super(new QName("exi:integer", "http://www.w3.org/2009/exi"));
    }

    public short getCodecID() {
        return 14;
    }

    public int getBuiltinRCS(int n, Scriber scriber) {
        return -8;
    }

    public boolean process(String string, int n, EXISchema eXISchema, Scribble scribble, Scriber scriber) {
        int n2;
        if (!this.trimWhitespaces(string)) {
            return false;
        }
        int n3 = this.startPosition;
        boolean bl = true;
        int n4 = 0;
        long l = 0L;
        boolean bl2 = false;
        char c = string.charAt(n3);
        if (c == '-' || c == '+') {
            ++n3;
            if (c != '+') {
                bl2 = true;
            }
        }
        boolean bl3 = false;
        int n5 = -1;
        int n6 = 0;
        block12: while (n3 < this.limitPosition) {
            c = string.charAt(n3);
            switch (c) {
                case '0': {
                    if (!bl3) break;
                    if (++n6 < 10) {
                        n4 *= 10;
                        break;
                    }
                    if (n6 == 10) {
                        l = 10L * (long)n4;
                        bl = false;
                        break;
                    }
                    if (n6 < 19) {
                        l *= 10L;
                        break;
                    }
                    l = Long.MIN_VALUE;
                    ++n3;
                    break block12;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (!bl3) {
                        bl3 = true;
                        n5 = n3;
                    }
                    n2 = c - 48;
                    if (++n6 < 10) {
                        n4 = 10 * n4 + n2;
                        break;
                    }
                    if (n6 == 10) {
                        l = 10L * (long)n4 + (long)n2;
                        bl = false;
                        break;
                    }
                    if (n6 < 19) {
                        l = 10L * l + (long)n2;
                        break;
                    }
                    l = Long.MIN_VALUE;
                    ++n3;
                    break block12;
                }
                default: {
                    return false;
                }
            }
            ++n3;
        }
        if (n3 != this.limitPosition) {
            assert (l == Long.MIN_VALUE);
            while (n3 != this.limitPosition) {
                c = string.charAt(n3);
                if (c < '0' || '9' < c) {
                    return false;
                }
                ++n3;
            }
        }
        assert (n5 >= 0 && bl3 || !bl3 && l == 0L && n4 == 0 && bl);
        if (!bl3 && bl2) {
            bl2 = false;
        }
        if (eXISchema.isIntegralSimpleType(n)) {
            scribble.intValue2 = eXISchema.getWidthOfIntegralSimpleType(n);
            switch (scribble.intValue2) {
                case 255: {
                    break;
                }
                case 254: {
                    if (bl2) {
                        return false;
                    }
                    scribble.booleanValue2 = bl;
                    if (scribble.booleanValue2) {
                        scribble.intValue1 = n4;
                    } else {
                        scribble.longValue = l;
                        if (scribble.longValue == Long.MIN_VALUE) {
                            scribble.stringValue1 = string.substring(n5, this.limitPosition);
                        }
                    }
                    return true;
                }
                default: {
                    if (!bl && l == Long.MIN_VALUE) {
                        return false;
                    }
                    if (bl2) {
                        if (bl) {
                            n4 = 0 - n4;
                        } else {
                            l = 0L - l;
                        }
                    }
                    n6 = eXISchema.getMinInclusiveFacetOfIntegerSimpleType(n);
                    switch (eXISchema.getTypeOfVariant(n6)) {
                        case 4: {
                            n2 = eXISchema.getIntValueOfVariant(n6);
                            if (bl) {
                                if (n4 >= n2 && (n4 -= n2) <= NBIT_INTEGER_RANGES[scribble.intValue2]) break;
                                return false;
                            }
                            if (l < (long)n2 || (l -= (long)n2) > (long)NBIT_INTEGER_RANGES[scribble.intValue2]) {
                                return false;
                            }
                            n4 = (int)l;
                            break;
                        }
                        case 5: {
                            long l2 = eXISchema.getLongValueOfVariant(n6);
                            if (bl) {
                                if ((long)n4 >= l2 && (n4 = (int)((long)n4 - l2)) <= NBIT_INTEGER_RANGES[scribble.intValue2]) break;
                                return false;
                            }
                            if (l < l2 || (l -= l2) > (long)NBIT_INTEGER_RANGES[scribble.intValue2]) {
                                return false;
                            }
                            n4 = (int)l;
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    scribble.intValue1 = n4;
                    return true;
                }
            }
        }
        scribble.intValue2 = 255;
        scribble.booleanValue1 = bl2;
        scribble.booleanValue2 = bl;
        if (scribble.booleanValue2) {
            scribble.intValue1 = n4;
        } else {
            scribble.longValue = l;
            if (scribble.longValue == Long.MIN_VALUE) {
                scribble.stringValue1 = string.substring(n5, this.limitPosition);
            }
        }
        return true;
    }

    public boolean processUnsignedInt(int n, Scribble scribble) {
        assert (n >= 0);
        scribble.intValue2 = 254;
        scribble.booleanValue2 = true;
        scribble.intValue1 = n;
        return true;
    }

    public void scribe(String string, Scribble scribble, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        this.scribeIntegerValue(scribble.booleanValue2, scribble.longValue, scribble.stringValue1, scribble.intValue1, scribble.intValue2, scribble.booleanValue1, outputStream, scriber);
    }

    public Object toValue(String string, Scribble scribble, Scriber scriber) {
        return new IntegerValue(scribble.booleanValue2, scribble.longValue, scribble.stringValue1, scribble.intValue1, scribble.intValue2, scribble.booleanValue1);
    }

    public void doScribe(Object object, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        IntegerValue integerValue = (IntegerValue)object;
        this.scribeIntegerValue(integerValue.useIntValue, integerValue.longValue, integerValue.digits, integerValue.intValue, integerValue.width, integerValue.isNegative, outputStream, scriber);
    }

    private void scribeIntegerValue(boolean bl, long l, String string, int n, int n2, boolean bl2, OutputStream outputStream, Scriber scriber) throws IOException {
        switch (n2) {
            case 255: {
                scriber.writeBoolean(bl2, outputStream);
                if (bl) {
                    assert (bl2 && n != 0 || !bl2);
                    scriber.writeUnsignedInteger32(bl2 ? n - 1 : n, outputStream);
                    break;
                }
                if (l != Long.MIN_VALUE) {
                    scriber.writeUnsignedInteger64(bl2 ? l - 1L : l, outputStream);
                    break;
                }
                BigInteger bigInteger = new BigInteger(string);
                if (bl2) {
                    bigInteger = bigInteger.subtract(BigInteger.ONE);
                }
                scriber.writeUnsignedInteger(bigInteger, outputStream);
                break;
            }
            case 254: {
                if (bl) {
                    scriber.writeUnsignedInteger32(n, outputStream);
                    break;
                }
                if (l != Long.MIN_VALUE) {
                    scriber.writeUnsignedInteger64(l, outputStream);
                    break;
                }
                scriber.writeUnsignedInteger(new BigInteger(string), outputStream);
                break;
            }
            default: {
                scriber.writeNBitUnsigned(n, n2, outputStream);
            }
        }
    }

    private static class IntegerValue {
        boolean useIntValue;
        long longValue;
        String digits;
        int intValue;
        int width;
        boolean isNegative;

        IntegerValue(boolean bl, long l, String string, int n, int n2, boolean bl2) {
            this.useIntValue = bl;
            this.longValue = l;
            this.digits = string;
            this.intValue = n;
            this.width = n2;
            this.isNegative = bl2;
        }
    }
}

