/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.InputStream;
import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.io.BitInputStream;
import org.openexi.proc.io.BodyBitInputStream;
import org.openexi.proc.io.HeaderOptionsInputStream;
import org.openexi.proc.io.SimpleScanner;

public final class BitPackedScanner
extends SimpleScanner {
    private BitInputStream m_bitInputStream;
    private final BodyBitInputStream m_bodyBitInputStream;

    BitPackedScanner(boolean bl) {
        super(bl);
        this.m_bodyBitInputStream = bl ? null : new BodyBitInputStream();
    }

    public void setInputStream(InputStream inputStream) {
        this.m_bodyBitInputStream.setInputStream(inputStream);
        this.m_bitInputStream = this.m_bodyBitInputStream;
        super.setInputStream(null);
    }

    public void setEXIOptionsInputStream(InputStream inputStream) {
        this.m_bitInputStream = new HeaderOptionsInputStream(inputStream);
        super.setInputStream(null);
    }

    public void takeover(HeaderOptionsInputStream headerOptionsInputStream) {
        this.m_bodyBitInputStream.inheritResidue(headerOptionsInputStream);
        this.m_bitInputStream = this.m_bodyBitInputStream;
        super.setInputStream(null);
    }

    public BitInputStream getBitInputStream() {
        return this.m_bitInputStream;
    }

    public AlignmentType getAlignmentType() {
        return AlignmentType.bitPacked;
    }

    protected boolean readBoolean(InputStream inputStream) throws IOException {
        return this.m_bitInputStream.getBit();
    }

    protected int readNBitUnsigned(int n, InputStream inputStream) throws IOException {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.m_bitInputStream.getOneBit();
            }
            case 2: {
                return this.m_bitInputStream.getTwoBits();
            }
            case 3: {
                return this.m_bitInputStream.getThreeBits();
            }
            case 4: {
                return this.m_bitInputStream.getFourBits();
            }
            case 5: {
                return this.m_bitInputStream.getFiveBits();
            }
        }
        return this.m_bitInputStream.getBits(n);
    }

    protected int readEightBitsUnsigned(InputStream inputStream) throws IOException {
        return this.m_bitInputStream.getEightBits();
    }
}

