/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.openexi.proc.common.QName;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.Scriber;
import org.openexi.proc.io.ValueScriberBase;
import org.openexi.schema.EXISchema;

public final class DecimalValueScriber
extends ValueScriberBase {
    public static final DecimalValueScriber instance = new DecimalValueScriber();

    private DecimalValueScriber() {
        super(new QName("exi:decimal", "http://www.w3.org/2009/exi"));
    }

    public short getCodecID() {
        return 12;
    }

    public int getBuiltinRCS(int n, Scriber scriber) {
        return -6;
    }

    public boolean process(String string, int n, EXISchema eXISchema, Scribble scribble, Scriber scriber) {
        return this.doProcess(string, scribble, scriber.stringBuilder1, scriber.stringBuilder2);
    }

    public void scribe(String string, Scribble scribble, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        this.scribeDecimalValue(scribble.stringValue1, scribble.stringValue2, scribble.booleanValue1, outputStream, scriber);
    }

    public Object toValue(String string, Scribble scribble, Scriber scriber) {
        return new DecimalValue(scribble.stringValue1, scribble.stringValue2, scribble.booleanValue1);
    }

    public void doScribe(Object object, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        DecimalValue decimalValue = (DecimalValue)object;
        this.scribeDecimalValue(decimalValue.integralDigits, decimalValue.fractionalDigits, decimalValue.isNegative, outputStream, scriber);
    }

    public static boolean getSign(Scribble scribble) {
        return scribble.booleanValue1;
    }

    public static String getIntegralDigits(Scribble scribble) {
        return scribble.stringValue1;
    }

    public static String getReverseFractionalDigits(Scribble scribble) {
        return scribble.stringValue2;
    }

    public static final void canonicalizeValue(Scribble scribble) {
        boolean bl = scribble.booleanValue1;
        String string = scribble.stringValue1;
        String string2 = scribble.stringValue2;
        if (bl && "0".equals(string) && "0".equals(string2)) {
            scribble.booleanValue1 = false;
        }
    }

    public boolean doProcess(String string, Scribble scribble, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        if (!this.trimWhitespaces(string)) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        stringBuilder.setLength(0);
        stringBuilder2.setLength(0);
        boolean bl = true;
        boolean bl2 = false;
        int n5 = 0;
        block6: for (int i = this.startPosition; i < this.limitPosition && !bl2; ++i) {
            char c = string.charAt(i);
            switch (n5) {
                case 0: {
                    if (c == '-' || c == '+') {
                        n5 = 1;
                        if (c == '+') continue block6;
                        bl = false;
                        continue block6;
                    }
                    if (c == '.') {
                        n5 = 3;
                        continue block6;
                    }
                    if (c >= '0' && c <= '9') {
                        n5 = 2;
                        ++n;
                        if (c == '0') continue block6;
                        stringBuilder.append(c);
                        ++n2;
                        continue block6;
                    }
                    bl2 = true;
                    continue block6;
                }
                case 1: 
                case 2: {
                    if (c == '.') {
                        n5 = 3;
                        continue block6;
                    }
                    if (c >= '0' && c <= '9') {
                        n5 = 2;
                        ++n;
                        if (n2 <= 0 && c == '0') continue block6;
                        stringBuilder.append(c);
                        ++n2;
                        continue block6;
                    }
                    bl2 = true;
                    continue block6;
                }
                case 3: {
                    if (c == '0') {
                        ++n4;
                        n5 = 4;
                        continue block6;
                    }
                    if (c >= '1' && c <= '9') {
                        stringBuilder2.append(c);
                        ++n;
                        ++n3;
                        continue block6;
                    }
                    bl2 = true;
                    continue block6;
                }
                case 4: {
                    assert (n4 > 0);
                    if (c == '0') {
                        ++n4;
                        continue block6;
                    }
                    if (c >= '1' && c <= '9') {
                        n += n4;
                        n3 += n4;
                        for (int j = 0; j < n4; ++j) {
                            stringBuilder2.append('0');
                        }
                        stringBuilder2.append(c);
                        ++n;
                        ++n3;
                        n4 = 0;
                        n5 = 3;
                        continue block6;
                    }
                    bl2 = true;
                }
            }
        }
        if (!bl2) {
            n += n4;
            if (n5 == 4) {
                n5 = 3;
            }
            if (n5 == 3 && n3 == 0 && n4 == 0) {
                n4 = 1;
            }
            n2 += n3;
        }
        if (bl2 || n5 != 2 && n5 != 3 || n == 0) {
            return false;
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append('0');
        }
        if (stringBuilder2.length() == 0) {
            stringBuilder2.append('0');
        } else {
            stringBuilder2.reverse();
        }
        scribble.booleanValue1 = !bl;
        scribble.stringValue1 = stringBuilder.toString();
        scribble.stringValue2 = stringBuilder2.toString();
        return true;
    }

    private void scribeDecimalValue(String string, String string2, boolean bl, OutputStream outputStream, Scriber scriber) throws IOException {
        int n;
        scriber.writeBoolean(bl, outputStream);
        int n2 = string.length();
        if (n2 < 10 || n2 == 10 && "2147483647".compareTo(string) >= 0) {
            n = Integer.parseInt(string);
            scriber.writeUnsignedInteger32(n, outputStream);
        } else {
            BigInteger bigInteger = new BigInteger(string);
            scriber.writeUnsignedInteger(bigInteger, outputStream);
        }
        n = string2.length();
        if (n < 10 || n == 10 && "2147483647".compareTo(string2) >= 0) {
            int n3 = Integer.parseInt(string2);
            scriber.writeUnsignedInteger32(n3, outputStream);
        } else {
            BigInteger bigInteger = new BigInteger(string2);
            scriber.writeUnsignedInteger(bigInteger, outputStream);
        }
    }

    private static class DecimalValue {
        String integralDigits;
        String fractionalDigits;
        boolean isNegative;

        DecimalValue(String string, String string2, boolean bl) {
            this.integralDigits = string;
            this.fractionalDigits = string2;
            this.isNegative = bl;
        }
    }
}

