/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.OutputStream;
import org.openexi.proc.common.QName;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.Scriber;
import org.openexi.proc.io.ValueScriberBase;
import org.openexi.schema.EXISchema;

public final class FloatValueScriber
extends ValueScriberBase {
    public static final FloatValueScriber instance = new FloatValueScriber();

    private FloatValueScriber() {
        super(new QName("exi:double", "http://www.w3.org/2009/exi"));
    }

    public short getCodecID() {
        return 13;
    }

    public int getBuiltinRCS(int n, Scriber scriber) {
        return -7;
    }

    public boolean process(String string, int n, EXISchema eXISchema, Scribble scribble, Scriber scriber) {
        return this.doProcess(string, scribble, scriber.stringBuilder1);
    }

    public void scribe(String string, Scribble scribble, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        this.scribeFloatValue(scribble.longValue, scribble.intValue1, outputStream, scriber);
    }

    public Object toValue(String string, Scribble scribble, Scriber scriber) {
        return new FloatValue(scribble.longValue, scribble.intValue1);
    }

    public void doScribe(Object object, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        FloatValue floatValue = (FloatValue)object;
        this.scribeFloatValue(floatValue.mantissa, floatValue.exponent, outputStream, scriber);
    }

    public static long getMantissa(Scribble scribble) {
        return scribble.longValue;
    }

    public static int getExponent(Scribble scribble) {
        return scribble.intValue1;
    }

    public static final void canonicalizeValue(Scribble scribble) {
        long l = scribble.longValue;
        int n = scribble.intValue1;
        if (n == -16384 && l != 1L && l != -1L) {
            l = 0L;
        } else if (l != 0L) {
            while (l % 10L == 0L) {
                l /= 10L;
                ++n;
            }
        } else {
            n = 0;
        }
        scribble.longValue = l;
        scribble.intValue1 = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doProcess(String string, Scribble scribble, StringBuilder stringBuilder) {
        long l;
        int n;
        String string2;
        int n2;
        boolean bl;
        int n3;
        block54: {
            block55: {
                int n4;
                if (!this.trimWhitespaces(string)) {
                    return false;
                }
                int n5 = 0;
                int n6 = 0;
                n3 = 0;
                int n7 = 0;
                int n8 = this.limitPosition - this.startPosition;
                switch (string.charAt(this.limitPosition - 1)) {
                    case 'F': {
                        if (n8 == 3 && string.charAt(this.startPosition) == 'I' && string.charAt(this.startPosition + 1) == 'N') {
                            scribble.longValue = 1L;
                            scribble.intValue1 = -16384;
                            return true;
                        }
                        if (n8 == 4 && string.charAt(this.startPosition) == '-' && string.charAt(this.startPosition + 1) == 'I' && string.charAt(this.startPosition + 2) == 'N') {
                            scribble.longValue = -1L;
                            scribble.intValue1 = -16384;
                            return true;
                        }
                        return false;
                    }
                    case 'N': {
                        if (n8 == 3 && string.charAt(this.startPosition) == 'N' && string.charAt(this.startPosition + 1) == 'a') {
                            scribble.longValue = 0L;
                            scribble.intValue1 = -16384;
                            return true;
                        }
                        return false;
                    }
                }
                stringBuilder.setLength(0);
                bl = true;
                int n9 = 0;
                block16: for (n2 = this.startPosition; n2 < this.limitPosition; ++n2) {
                    char c = string.charAt(n2);
                    switch (n9) {
                        case 0: {
                            if (c == '-' || c == '+') {
                                n9 = 1;
                                if (c == '+') break;
                                bl = false;
                                break;
                            }
                            if (c == '.') {
                                n9 = 3;
                                break;
                            }
                            if (c >= '0' && c <= '9') {
                                n9 = 2;
                                ++n5;
                                if (c == '0') break;
                                stringBuilder.append(c);
                                ++n6;
                                break;
                            }
                            return false;
                        }
                        case 1: 
                        case 2: {
                            if (c == '.') {
                                n9 = 3;
                                break;
                            }
                            if (c >= '0' && c <= '9') {
                                n9 = 2;
                                ++n5;
                                if (n6 <= 0 && c == '0') break;
                                stringBuilder.append(c);
                                ++n6;
                                break;
                            }
                            if (n9 == 2 && (c == 'e' || c == 'E')) break block16;
                            return false;
                        }
                        case 3: {
                            if (c == '0') {
                                ++n7;
                                n9 = 4;
                                break;
                            }
                            if (c >= '1' && c <= '9') {
                                stringBuilder.append(c);
                                ++n5;
                                ++n3;
                                break;
                            }
                            if (c == 'e' || c == 'E') break block16;
                            return false;
                        }
                        case 4: {
                            assert (n7 > 0);
                            if (c == '0') {
                                ++n7;
                                break;
                            }
                            if (c >= '1' && c <= '9') {
                                n5 += n7;
                                n3 += n7;
                                for (n4 = 0; n4 < n7; ++n4) {
                                    stringBuilder.append('0');
                                }
                                stringBuilder.append(c);
                                ++n5;
                                ++n3;
                                n7 = 0;
                                n9 = 3;
                                break;
                            }
                            if (c != 'e' && c != 'E') {
                                return false;
                            }
                            n5 += n7;
                            n3 += n7;
                            for (n4 = 0; n4 < n7; ++n4) {
                                stringBuilder.append('0');
                            }
                            n7 = 0;
                            break block16;
                        }
                    }
                }
                n5 += n7;
                if (n9 == 4) {
                    n9 = 3;
                }
                if (n9 == 3 && n3 == 0 && n7 == 0) {
                    n7 = 1;
                }
                n6 += n3;
                if (n9 != 2 && n9 != 3 || n5 == 0) {
                    return false;
                }
                if (stringBuilder.length() == 0) {
                    stringBuilder.append('0');
                }
                string2 = stringBuilder.toString();
                n4 = stringBuilder.length();
                if (n4 > 19) {
                    return false;
                }
                if (n4 != 19) break block55;
                if (bl) {
                    n = "9223372036854775807".compareTo(string2);
                    if (n == 0) {
                        l = Long.MAX_VALUE;
                        break block54;
                    } else {
                        if (n < 0) {
                            return false;
                        }
                        l = Long.parseLong(string2);
                    }
                    break block54;
                } else {
                    n = "9223372036854775808".compareTo(string2);
                    if (n == 0) {
                        l = Long.MIN_VALUE;
                        break block54;
                    } else {
                        if (n < 0) {
                            return false;
                        }
                        l = -Long.parseLong(string2);
                    }
                }
                break block54;
            }
            l = bl ? Long.parseLong(string2) : -Long.parseLong(string2);
        }
        stringBuilder.setLength(0);
        bl = true;
        if (n2 < this.limitPosition && ((n = (int)string.charAt(n2++)) == 101 || n == 69) && n2 < this.limitPosition) {
            n = string.charAt(n2);
            if (n == 45 || n == 43) {
                ++n2;
                if (n != 43) {
                    bl = false;
                }
            }
            boolean bl2 = false;
            while (n2 < this.limitPosition) {
                char c = string.charAt(n2);
                n = c;
                switch (c) {
                    case '0': {
                        if (!bl2) break;
                        stringBuilder.append((char)n);
                        break;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (!bl2) {
                            bl2 = true;
                        }
                        stringBuilder.append((char)n);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                ++n2;
            }
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append('0');
        }
        string2 = stringBuilder.toString();
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        n = bl ? (n -= n3) : -(n + n3);
        if (n >= -16383 && 16383 >= n) {
            scribble.longValue = l;
            scribble.intValue1 = n;
            return true;
        }
        return false;
    }

    private void scribeFloatValue(long l, int n, OutputStream outputStream, Scriber scriber) throws IOException {
        boolean bl = (l & Long.MIN_VALUE) != 0L;
        if (bl) {
            l ^= 0xFFFFFFFFFFFFFFFFL;
        }
        scriber.writeBoolean(bl, outputStream);
        scriber.writeUnsignedInteger64(l, outputStream);
        bl = (n & Integer.MIN_VALUE) != 0;
        if (bl) {
            n ^= 0xFFFFFFFF;
        }
        scriber.writeBoolean(bl, outputStream);
        scriber.writeUnsignedInteger32(n, outputStream);
    }

    private static final class FloatValue {
        final long mantissa;
        final int exponent;

        FloatValue(long l, int n) {
            this.mantissa = l;
            this.exponent = n;
        }
    }
}

