/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.attributes;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.attributes.AttributeList;
import com.siemens.ct.exi.core.container.NamespaceDeclaration;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class AttributeListImpl
implements AttributeList {
    public static final int XMLNS_PFX_START = "xmlns".length() + 1;
    protected final boolean isSchemaInformed;
    protected final boolean isCanonical;
    protected final boolean preserveSchemaLocation;
    protected final boolean preservePrefixes;
    protected boolean hasXsiType;
    protected String xsiTypeRaw;
    protected String xsiTypePrefix;
    protected boolean hasXsiNil;
    protected String xsiNil;
    protected String xsiNilPrefix;
    protected final List<String> attributeURI;
    protected final List<String> attributeLocalName;
    protected final List<String> attributeValue;
    protected final List<String> attributePrefix;
    protected List<NamespaceDeclaration> nsDecls;

    public AttributeListImpl(EXIFactory exiFactory) {
        this.isSchemaInformed = exiFactory.getGrammars().isSchemaInformed();
        this.isCanonical = exiFactory.getEncodingOptions().isOptionEnabled("http://www.w3.org/TR/exi-c14n") || exiFactory.getEncodingOptions().isOptionEnabled("http://www.w3.org/TR/exi-c14n#WithoutEXIOptions");
        this.preserveSchemaLocation = exiFactory.getEncodingOptions().isOptionEnabled("INCLUDE_XSI_SCHEMALOCATION");
        this.preservePrefixes = exiFactory.getFidelityOptions().isFidelityEnabled("PRESERVE_PREFIXES");
        this.attributeURI = new ArrayList<String>();
        this.attributeLocalName = new ArrayList<String>();
        this.attributeValue = new ArrayList<String>();
        this.attributePrefix = new ArrayList<String>();
        this.nsDecls = new ArrayList<NamespaceDeclaration>();
    }

    public void clear() {
        this.hasXsiType = false;
        this.hasXsiNil = false;
        this.attributeURI.clear();
        this.attributeLocalName.clear();
        this.attributeValue.clear();
        this.attributePrefix.clear();
        this.xsiTypeRaw = null;
        this.nsDecls.clear();
    }

    public boolean hasXsiType() {
        return this.hasXsiType;
    }

    public String getXsiTypeRaw() {
        return this.xsiTypeRaw;
    }

    public String getXsiTypePrefix() {
        return this.xsiTypePrefix;
    }

    public boolean hasXsiNil() {
        return this.hasXsiNil;
    }

    public String getXsiNil() {
        return this.xsiNil;
    }

    public String getXsiNilPrefix() {
        return this.xsiNilPrefix;
    }

    public int getNumberOfAttributes() {
        return this.attributeURI.size();
    }

    public String getAttributeURI(int index) {
        return this.attributeURI.get(index);
    }

    public String getAttributeLocalName(int index) {
        return this.attributeLocalName.get(index);
    }

    public String getAttributeValue(int index) {
        return this.attributeValue.get(index);
    }

    public String getAttributePrefix(int index) {
        return this.attributePrefix.get(index);
    }

    private void setXsiType(String rawType, String xsiPrefix) {
        this.hasXsiType = true;
        this.xsiTypeRaw = rawType;
        this.xsiTypePrefix = xsiPrefix;
    }

    private void setXsiNil(String rawNil, String xsiPrefix) {
        this.hasXsiNil = true;
        this.xsiNil = rawNil;
        this.xsiNilPrefix = xsiPrefix;
    }

    public void addNamespaceDeclaration(String uri, String pfx) {
        if (this.nsDecls.size() == 0 || !this.isCanonical) {
            this.nsDecls.add(new NamespaceDeclaration(uri, pfx));
        } else {
            int i;
            for (i = this.getNumberOfNamespaceDeclarations(); i > 0 && this.isGreaterNS(i - 1, pfx); --i) {
            }
            this.nsDecls.add(i, new NamespaceDeclaration(uri, pfx));
        }
    }

    public int getNumberOfNamespaceDeclarations() {
        return this.nsDecls.size();
    }

    public NamespaceDeclaration getNamespaceDeclaration(int index) {
        assert (index >= 0 && index < this.nsDecls.size());
        return this.nsDecls.get(index);
    }

    public void addAttribute(QName at, String value) {
        this.addAttribute(at.getNamespaceURI(), at.getLocalPart(), at.getPrefix(), value);
    }

    public void addAttribute(String uri, String localName, String pfx, String value) {
        uri = uri == null ? "" : uri;
        String string = pfx = pfx == null ? "" : pfx;
        if (uri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
            if (localName.equals("type")) {
                this.setXsiType(value, pfx);
            } else if (localName.equals("nil")) {
                this.setXsiNil(value, pfx);
            } else if (!localName.equals("schemaLocation") && !localName.equals("noNamespaceSchemaLocation") || this.preserveSchemaLocation) {
                this.insertAttribute(uri, localName, pfx, value);
            }
        } else {
            this.insertAttribute(uri, localName, pfx, value);
        }
    }

    protected void insertAttribute(String uri, String localName, String pfx, String value) {
        if (this.isSchemaInformed || this.isCanonical) {
            int i;
            for (i = this.getNumberOfAttributes(); i > 0 && this.isGreaterAttribute(i - 1, uri, localName); --i) {
            }
            this.attributeURI.add(i, uri);
            this.attributeLocalName.add(i, localName);
            this.attributePrefix.add(i, pfx);
            this.attributeValue.add(i, value);
        } else {
            this.attributeURI.add(uri);
            this.attributeLocalName.add(localName);
            this.attributePrefix.add(pfx);
            this.attributeValue.add(value);
        }
    }

    protected final boolean isGreaterAttribute(int attributeIndex, String uri, String localName) {
        int compLocalName = this.getAttributeLocalName(attributeIndex).compareTo(localName);
        if (compLocalName > 0) {
            return true;
        }
        if (compLocalName < 0) {
            return false;
        }
        return this.getAttributeURI(attributeIndex).compareTo(uri) > 0;
    }

    protected final boolean isGreaterNS(int nsIndex, String prefix) {
        int compPrefix = this.getNamespaceDeclaration((int)nsIndex).prefix.compareTo(prefix);
        return compPrefix > 0;
    }
}

