/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammars;

import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammars.event.AbstractEvent;
import com.siemens.ct.exi.grammars.event.AttributeGeneric;
import com.siemens.ct.exi.grammars.event.CharactersGeneric;
import com.siemens.ct.exi.grammars.event.EndElement;
import com.siemens.ct.exi.grammars.event.Event;
import com.siemens.ct.exi.grammars.event.StartElement;
import com.siemens.ct.exi.grammars.event.StartElementGeneric;
import com.siemens.ct.exi.grammars.event.StartElementNS;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedElement;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedGrammar;
import com.siemens.ct.exi.util.sort.LexicographicSort;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDeclHelper;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.CMNodeFactory;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSWildcard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EXIContentModelBuilder
extends CMBuilder
implements XMLErrorHandler {
    private static final boolean DEBUG = false;
    protected static final Event END_ELEMENT = new EndElement();
    protected static final Event START_ELEMENT_GENERIC = new StartElementGeneric();
    protected static final Event ATTRIBUTE_GENERIC = new AttributeGeneric();
    protected static final Event CHARACTERS_GENERIC = new CharactersGeneric();
    protected static final boolean forUPA = false;
    protected static final LexicographicSort lexSort = new LexicographicSort();
    protected SubstitutionGroupHandler subGroupHandler;
    protected XSModel xsModel;
    protected List<String> schemaParsingErrors;
    protected Map<XSElementDeclaration, StartElement> elementPool;

    public EXIContentModelBuilder() {
        super(new CMNodeFactory());
    }

    protected void initOnce() {
        this.elementPool = new HashMap<XSElementDeclaration, StartElement>();
        this.schemaParsingErrors = new ArrayList<String>();
    }

    protected void initEachRun() {
        this.elementPool.clear();
        this.schemaParsingErrors.clear();
    }

    public void loadGrammars(XMLInputSource xsdSource) throws EXIException {
        this.loadGrammars(xsdSource, null);
    }

    public void loadGrammars(XMLInputSource xsdSource, XMLEntityResolver entityResolver) throws EXIException {
        try {
            this.initEachRun();
            XMLSchemaLoader sl = new XMLSchemaLoader();
            if (entityResolver != null) {
                sl.setEntityResolver(entityResolver);
            }
            sl.setErrorHandler((XMLErrorHandler)this);
            SchemaGrammar g = (SchemaGrammar)sl.loadGrammar(xsdSource);
            this.xsModel = g.toXSModel();
            this.subGroupHandler = new SubstitutionGroupHandler((XSElementDeclHelper)sl);
        }
        catch (Exception e) {
            throw new EXIException("XML Schema document (" + xsdSource.getSystemId() + ") not found.", e);
        }
    }

    public void loadXSDTypesOnlyGrammars() throws EXIException {
        String emptySchema = "<schema xmlns='http://www.w3.org/2001/XMLSchema' /> ";
        StringReader r = new StringReader(emptySchema);
        XMLInputSource is = new XMLInputSource(null, null, null, (Reader)r, null);
        this.loadGrammars(is, null);
    }

    public void loadGrammars(String xsdLocation) throws EXIException {
        this.loadGrammars(xsdLocation, null);
    }

    public void loadGrammars(String xsdLocation, XMLEntityResolver entityResolver) throws EXIException {
        XMLInputSource xsdSource = null;
        if (entityResolver != null) {
            XMLResourceIdentifierImpl rid = new XMLResourceIdentifierImpl();
            rid.setLiteralSystemId(xsdLocation);
            try {
                xsdSource = entityResolver.resolveEntity((XMLResourceIdentifier)rid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (xsdSource == null) {
            String systemId = xsdLocation;
            String publicId = null;
            String baseSystemId = null;
            xsdSource = new XMLInputSource(publicId, systemId, baseSystemId);
        }
        this.loadGrammars(xsdSource, entityResolver);
    }

    public void loadGrammars(InputStream xsdInputStream) throws EXIException {
        this.loadGrammars(xsdInputStream, null);
    }

    public void loadGrammars(InputStream xsdInputStream, XMLEntityResolver entityResolver) throws EXIException {
        String publicId = null;
        String systemId = null;
        String baseSystemId = null;
        String encoding = null;
        XMLInputSource xsdSource = new XMLInputSource(publicId, systemId, baseSystemId, xsdInputStream, encoding);
        this.loadGrammars(xsdSource, entityResolver);
    }

    public XSModel getXSModel() {
        return this.xsModel;
    }

    private static SchemaInformedGrammar addNewState(Map<CMState, SchemaInformedGrammar> states, CMState key, boolean isMixedContent) {
        SchemaInformedElement val = new SchemaInformedElement();
        if (key.end) {
            val.addTerminalProduction(END_ELEMENT);
        }
        if (isMixedContent) {
            val.addProduction(CHARACTERS_GENERIC, val);
        }
        states.put(key, val);
        return val;
    }

    private void getMaxOccursUnboundedElements(List<XSElementDeclaration> elementsMaxOccursUnbounded, XSParticle xsParticle) {
        this.getMaxOccursUnboundedElements(elementsMaxOccursUnbounded, xsParticle, false);
    }

    private void getMaxOccursUnboundedElements(List<XSElementDeclaration> elementsMaxOccursUnbounded, XSParticle xsParticle, boolean outerUnbounded) {
        XSTerm xsTerm = xsParticle.getTerm();
        if (xsTerm instanceof XSElementDeclaration) {
            XSElementDeclaration xse = (XSElementDeclaration)xsTerm;
            if ((outerUnbounded || xsParticle.getMaxOccursUnbounded()) && !elementsMaxOccursUnbounded.contains(xse)) {
                elementsMaxOccursUnbounded.add(xse);
            }
        } else if (xsTerm instanceof XSModelGroup) {
            XSModelGroup smg = (XSModelGroup)xsTerm;
            XSObjectList particles = smg.getParticles();
            for (int i = 0; i < particles.getLength(); ++i) {
                XSParticle xsp = (XSParticle)particles.item(i);
                this.getMaxOccursUnboundedElements(elementsMaxOccursUnbounded, xsp, xsParticle.getMaxOccursUnbounded());
            }
        }
    }

    protected SchemaInformedGrammar handleParticle(XSComplexTypeDefinition ctd, boolean isMixedContent) throws EXIException {
        XSModelGroup mg;
        XSParticle xsParticle = ctd.getParticle();
        XSTerm xsTerm = xsParticle.getTerm();
        if (xsTerm instanceof XSModelGroup && (mg = (XSModelGroup)xsTerm).getCompositor() == 3) {
            SchemaInformedElement allRule = new SchemaInformedElement();
            allRule.addTerminalProduction(END_ELEMENT);
            XSObjectList allParticles = mg.getParticles();
            for (int i = 0; i < allParticles.getLength(); ++i) {
                XSObject o = allParticles.item(i);
                assert (o instanceof XSParticle);
                XSParticle xsp = (XSParticle)o;
                XSTerm tt = xsp.getTerm();
                if (2 != tt.getType()) {
                    throw new RuntimeException("No XSElementDeclaration for xsd:all particle, " + tt);
                }
                XSElementDeclaration el = (XSElementDeclaration)tt;
                StartElement se = this.translatElementDeclarationToFSA(el);
                allRule.addProduction(se, allRule);
            }
            return allRule;
        }
        XSCMValidator xscmVal = this.getContentModel((XSComplexTypeDecl)ctd, false);
        int[] state = xscmVal.startContentModel();
        Vector possibleElements = xscmVal.whatCanGoHere(state);
        ArrayList<XSElementDeclaration> elementsMaxOccursUnbounded = new ArrayList<XSElementDeclaration>();
        this.getMaxOccursUnboundedElements(elementsMaxOccursUnbounded, xsParticle);
        boolean isEnd = xscmVal.endContentModel(state);
        int[] occurenceInfo = xscmVal.occurenceInfo(state);
        CMState startState = new CMState(possibleElements, isEnd, state, elementsMaxOccursUnbounded, occurenceInfo);
        HashMap<CMState, SchemaInformedGrammar> knownStates = new HashMap<CMState, SchemaInformedGrammar>();
        EXIContentModelBuilder.addNewState(knownStates, startState, isMixedContent);
        this.handleStateEntries(possibleElements, xscmVal, state, startState, knownStates, isMixedContent, elementsMaxOccursUnbounded);
        return (SchemaInformedGrammar)knownStates.get(startState);
    }

    protected abstract StartElementNS createStartElementNS(String var1);

    protected abstract StartElement translatElementDeclarationToFSA(XSElementDeclaration var1) throws EXIException;

    private void handleStateEntries(List<XSObject> possibleElements, XSCMValidator xscmVal, int[] originalState, CMState startState, Map<CMState, SchemaInformedGrammar> knownStates, boolean isMixedContent, List<XSElementDeclaration> elementsMaxOccursUnbounded) throws EXIException {
        assert (knownStates.containsKey(startState));
        for (int ind = 0; ind < possibleElements.size(); ++ind) {
            AbstractEvent xsEvent;
            int i;
            XSObject xs = possibleElements.get(ind);
            int[] cstate = new int[originalState.length];
            System.arraycopy(originalState, 0, cstate, 0, originalState.length);
            if (xs.getType() == 2) {
                XSElementDeclaration nextEl = (XSElementDeclaration)xs;
                QName qname = new QName(null, nextEl.getName(), null, nextEl.getNamespace());
                Object nextRet = xscmVal.oneTransition(qname, cstate, this.subGroupHandler);
                assert (xs == nextRet);
                Vector nextPossibleElements = xscmVal.whatCanGoHere(cstate);
                boolean isEnd = xscmVal.endContentModel(cstate);
                int[] occurenceInfo = xscmVal.occurenceInfo(cstate);
                CMState nextState = new CMState(nextPossibleElements, isEnd, cstate, elementsMaxOccursUnbounded, occurenceInfo);
                EXIContentModelBuilder.printTransition(startState, xs, nextState);
                List<XSElementDeclaration> elements = this.getPossibleElementDeclarations(nextEl);
                assert (elements.size() > 0);
                boolean isNewState = false;
                for (i = 0; i < elements.size(); ++i) {
                    XSElementDeclaration nextEN = elements.get(i);
                    xsEvent = this.translatElementDeclarationToFSA(nextEN);
                    if (i == 0) {
                        isNewState = this.handleStateEntry(startState, knownStates, xsEvent, nextState, isMixedContent);
                        continue;
                    }
                    this.handleStateEntry(startState, knownStates, xsEvent, nextState, isMixedContent);
                }
                if (!isNewState) continue;
                this.handleStateEntries(nextPossibleElements, xscmVal, cstate, nextState, knownStates, isMixedContent, elementsMaxOccursUnbounded);
                continue;
            }
            assert (xs.getType() == 9);
            XSWildcard nextWC = (XSWildcard)xs;
            short constraintType = nextWC.getConstraintType();
            if (constraintType == 1 || constraintType == 2) {
                QName qname = new QName(null, "##wc", null, "");
                Object nextRet = xscmVal.oneTransition(qname, cstate, this.subGroupHandler);
                assert (xs == nextRet);
                Vector nextPossibleElements = xscmVal.whatCanGoHere(cstate);
                boolean isEnd = xscmVal.endContentModel(cstate);
                int[] occurenceInfo = xscmVal.occurenceInfo(cstate);
                CMState nextState = new CMState(nextPossibleElements, isEnd, cstate, elementsMaxOccursUnbounded, occurenceInfo);
                EXIContentModelBuilder.printTransition(startState, xs, nextState);
                Event xsEvent2 = START_ELEMENT_GENERIC;
                boolean isNewState = this.handleStateEntry(startState, knownStates, xsEvent2, nextState, isMixedContent);
                if (!isNewState) continue;
                this.handleStateEntries(nextPossibleElements, xscmVal, cstate, nextState, knownStates, isMixedContent, elementsMaxOccursUnbounded);
                continue;
            }
            assert (constraintType == 3);
            StringList sl = nextWC.getNsConstraintList();
            QName qname = new QName(null, "##wc", null, sl.item(0));
            Object nextRet = xscmVal.oneTransition(qname, cstate, this.subGroupHandler);
            assert (xs == nextRet);
            Vector nextPossibleElements = xscmVal.whatCanGoHere(cstate);
            boolean isEnd = xscmVal.endContentModel(cstate);
            int[] occurenceInfo = xscmVal.occurenceInfo(cstate);
            CMState nextState = new CMState(nextPossibleElements, isEnd, cstate, elementsMaxOccursUnbounded, occurenceInfo);
            EXIContentModelBuilder.printTransition(startState, xs, nextState);
            for (i = 0; i < sl.getLength(); ++i) {
                String namespaceURI = sl.item(i);
                this.addNamespaceStringEntry(namespaceURI);
                xsEvent = this.createStartElementNS(namespaceURI);
                boolean isNewState = this.handleStateEntry(startState, knownStates, xsEvent, nextState, isMixedContent);
                if (!isNewState) continue;
                this.handleStateEntries(nextPossibleElements, xscmVal, cstate, nextState, knownStates, isMixedContent, elementsMaxOccursUnbounded);
            }
        }
    }

    protected abstract void addLocalNameStringEntry(String var1, String var2);

    protected abstract List<String> addNamespaceStringEntry(String var1);

    private boolean handleStateEntry(CMState startState, Map<CMState, SchemaInformedGrammar> knownStates, Event xsEvent, CMState nextState, boolean isMixedContent) {
        SchemaInformedGrammar startRule = knownStates.get(startState);
        if (knownStates.containsKey(nextState)) {
            startRule.addProduction(xsEvent, knownStates.get(nextState));
            return false;
        }
        EXIContentModelBuilder.addNewState(knownStates, nextState, isMixedContent);
        startRule.addProduction(xsEvent, knownStates.get(nextState));
        return true;
    }

    protected List<XSElementDeclaration> getPossibleElementDeclarations(XSElementDeclaration el) {
        XSObjectList listSG;
        ArrayList<XSElementDeclaration> listElements = new ArrayList<XSElementDeclaration>();
        listElements.add(el);
        XSNamedMap globalElements = this.xsModel.getComponents((short)2);
        if (globalElements != null && globalElements.size() > 0 && (listSG = this.xsModel.getSubstitutionGroup(el)) != null && listSG.getLength() > 0) {
            for (int i = 0; i < listSG.getLength(); ++i) {
                XSElementDeclaration ed = (XSElementDeclaration)listSG.item(i);
                listElements.add(ed);
            }
        }
        Collections.sort(listElements, lexSort);
        return listElements;
    }

    private static void printTransition(CMState startState, XSObject xs, CMState nextState) {
    }

    public void error(String domain, String key, XMLParseException exception) throws XNIException {
        this.schemaParsingErrors.add("[xs-error] " + exception.getMessage());
    }

    public void fatalError(String domain, String key, XMLParseException exception) throws XNIException {
        this.schemaParsingErrors.add("[xs-fatalError] " + exception.getMessage());
    }

    public void warning(String domain, String key, XMLParseException exception) throws XNIException {
        this.schemaParsingErrors.add("[xs-warning] " + exception.getMessage());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CMState {
        protected final List<XSObject> states;
        protected final boolean end;
        protected final int[] state;
        protected final List<XSElementDeclaration> elementsMaxOccursUnbounded;
        protected final int[] occurenceInfo;

        public CMState(List<XSObject> states, boolean end, int[] state, List<XSElementDeclaration> elementsMaxOccursUnbounded, int[] occurenceInfo) {
            this.states = states;
            this.end = end;
            this.elementsMaxOccursUnbounded = elementsMaxOccursUnbounded;
            this.occurenceInfo = occurenceInfo;
            this.state = new int[state.length];
            System.arraycopy(state, 0, this.state, 0, state.length);
        }

        public boolean equals(Object o) {
            if (o instanceof CMState) {
                CMState other = (CMState)o;
                if (this.end == other.end && this.states.equals(other.states)) {
                    assert (this.state.length > 1 && other.state.length > 1);
                    if (this.state[0] == other.state[0] && this.state[1] == other.state[1]) {
                        if (this.states.size() == 0 && other.states.size() == 0) {
                            return true;
                        }
                        if (this.state[2] != other.state[2]) {
                            for (int i = 0; i < this.states.size(); ++i) {
                                XSObject s = this.states.get(i);
                                if (!this.elementsMaxOccursUnbounded.contains(s)) continue;
                                if (this.occurenceInfo == null) {
                                    return true;
                                }
                                assert (this.occurenceInfo[0] == other.occurenceInfo[0]);
                                return this.occurenceInfo[2] >= this.occurenceInfo[0] && other.occurenceInfo[2] >= this.occurenceInfo[0];
                            }
                            return false;
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        public String toString() {
            return (this.end ? "F" : "N") + this.stateToString() + this.states.toString();
        }

        protected String stateToString() {
            StringBuilder s = new StringBuilder();
            s.append('(');
            for (int i = 0; i < this.state.length; ++i) {
                s.append(this.state[i]);
                if (i >= this.state.length - 1) continue;
                s.append(',');
            }
            s.append(')');
            return s.toString();
        }

        public int hashCode() {
            return this.end ? this.states.hashCode() : -this.states.hashCode();
        }
    }
}

