/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc;

import java.io.IOException;
import java.io.InputStream;
import org.openexi.proc.EXISchemaResolver;
import org.openexi.proc.HeaderOptionsDecoder;
import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.common.EXIOptions;
import org.openexi.proc.common.EXIOptionsException;
import org.openexi.proc.common.QName;
import org.openexi.proc.common.SchemaId;
import org.openexi.proc.grammars.GrammarCache;
import org.openexi.proc.io.BitPackedScanner;
import org.openexi.proc.io.HeaderOptionsInputStream;
import org.openexi.proc.io.Scanner;
import org.openexi.proc.io.ScannerFactory;
import org.openexi.schema.EXISchema;
import org.openexi.schema.EmptySchema;

public class EXIDecoder {
    private Scanner m_scanner;
    private GrammarCache m_grammarCache;
    private EXISchema m_schema;
    private EXISchemaResolver m_schemaResolver;
    private InputStream m_inputStream;
    private final EXIOptions m_exiOptions;
    private final EXIOptions m_exiHeaderOptions;
    private final HeaderOptionsDecoder m_optionsDecoder;
    private static final int DEFAULT_INFLATOR_BUF_SIZE = 8192;
    private final int m_inflatorBufSize;
    private final boolean m_useThreadedInflater;
    private boolean m_binaryDataEnabled;
    private int m_initialBinaryDataBufferSize;

    public EXIDecoder() {
        this(8192, false);
    }

    public EXIDecoder(int n, boolean bl) {
        this.m_inflatorBufSize = n;
        this.m_exiOptions = new EXIOptions();
        this.m_exiHeaderOptions = new EXIOptions();
        this.m_optionsDecoder = new HeaderOptionsDecoder();
        this.m_grammarCache = null;
        this.m_schema = null;
        this.m_schemaResolver = null;
        this.m_useThreadedInflater = bl;
        this.m_scanner = ScannerFactory.createScanner(AlignmentType.bitPacked, this.m_inflatorBufSize, this.m_useThreadedInflater);
        this.m_scanner.setSchema(this.m_schema, null, 0);
        this.m_scanner.setStringTable(Scanner.createStringTable(this.m_grammarCache));
        this.m_binaryDataEnabled = false;
        this.m_initialBinaryDataBufferSize = 8192;
    }

    public final void setInputStream(InputStream inputStream) {
        this.m_inputStream = inputStream;
    }

    public final void setAlignmentType(AlignmentType alignmentType) throws EXIOptionsException {
        this.m_exiOptions.setAlignmentType(alignmentType);
        if (this.m_scanner.getAlignmentType() != alignmentType) {
            this.m_scanner = ScannerFactory.createScanner(alignmentType, this.m_inflatorBufSize, this.m_useThreadedInflater);
            this.m_scanner.setSchema(this.m_schema, this.m_exiOptions.getDatatypeRepresentationMap(), this.m_exiOptions.getDatatypeRepresentationMapBindingsCount());
            this.m_scanner.setStringTable(Scanner.createStringTable(this.m_grammarCache));
            this.m_scanner.setValueMaxLength(this.m_exiOptions.getValueMaxLength());
            this.m_scanner.setPreserveLexicalValues(this.m_exiOptions.getPreserveLexicalValues());
        }
    }

    public final void setFragment(boolean bl) {
        this.m_exiOptions.setFragment(bl);
    }

    public final void setGrammarCache(GrammarCache grammarCache) throws EXIOptionsException {
        this.m_exiOptions.setGrammarOptions(grammarCache.grammarOptions);
        if (this.m_grammarCache != grammarCache) {
            this.m_grammarCache = grammarCache;
            EXISchema eXISchema = this.m_grammarCache.getEXISchema();
            if (eXISchema != this.m_schema) {
                this.m_schema = eXISchema;
                this.m_scanner.setSchema(this.m_schema, this.m_exiOptions.getDatatypeRepresentationMap(), this.m_exiOptions.getDatatypeRepresentationMapBindingsCount());
                this.m_scanner.setStringTable(Scanner.createStringTable(this.m_grammarCache));
            }
        }
    }

    public final void setEXISchemaResolver(EXISchemaResolver eXISchemaResolver) {
        this.m_schemaResolver = eXISchemaResolver;
    }

    public final void setBlockSize(int n) throws EXIOptionsException {
        this.m_exiOptions.setBlockSize(n);
    }

    public final void setValueMaxLength(int n) {
        this.m_exiOptions.setValueMaxLength(n);
        this.m_scanner.setValueMaxLength(n);
    }

    public final void setValuePartitionCapacity(int n) {
        this.m_exiOptions.setValuePartitionCapacity(n);
    }

    public final void setPreserveLexicalValues(boolean bl) throws EXIOptionsException {
        this.m_exiOptions.setPreserveLexicalValues(bl);
        this.m_scanner.setPreserveLexicalValues(bl);
    }

    public final void setDatatypeRepresentationMap(QName[] qNameArray, int n) throws EXIOptionsException {
        if (!QName.isSame(this.m_exiOptions.getDatatypeRepresentationMap(), this.m_exiOptions.getDatatypeRepresentationMapBindingsCount(), qNameArray, n)) {
            this.m_exiOptions.setDatatypeRepresentationMap(qNameArray, n);
            this.m_scanner.setSchema(this.m_schema, qNameArray, n);
        }
    }

    public final void setEnableBinaryData(boolean bl) {
        this.m_binaryDataEnabled = bl;
    }

    public final void setInitialBinaryDataBufferSize(int n) {
        this.m_initialBinaryDataBufferSize = n;
    }

    public Scanner processHeader() throws IOException, EXIOptionsException {
        boolean bl;
        Scanner scanner;
        GrammarCache grammarCache;
        int n = this.m_inputStream.read();
        if (n == 36) {
            this.m_inputStream.read();
            this.m_inputStream.read();
            this.m_inputStream.read();
            n = this.m_inputStream.read();
        }
        HeaderOptionsInputStream headerOptionsInputStream = null;
        if ((n & 0x20) != 0) {
            EXISchema eXISchema;
            this.m_exiHeaderOptions.init();
            HeaderOptionsInputStream headerOptionsInputStream2 = this.m_optionsDecoder.decode(this.m_exiHeaderOptions, this.m_inputStream);
            short s = this.m_exiHeaderOptions.toGrammarOptions();
            SchemaId schemaId = this.m_exiHeaderOptions.getSchemaId();
            if (schemaId != null) {
                String string = schemaId.getValue();
                if (string == null) {
                    eXISchema = null;
                    grammarCache = new GrammarCache(s);
                } else if (string.length() == 0) {
                    assert (false);
                    eXISchema = EmptySchema.getEXISchema();
                    grammarCache = new GrammarCache(eXISchema, s);
                } else {
                    GrammarCache grammarCache2 = null;
                    if (this.m_schemaResolver != null && (grammarCache2 = this.m_schemaResolver.resolveSchema(string, s)) != null) {
                        grammarCache = grammarCache2;
                        eXISchema = grammarCache.getEXISchema();
                    } else {
                        eXISchema = this.m_schema;
                        grammarCache = this.m_grammarCache.grammarOptions != s ? new GrammarCache(eXISchema, s) : this.m_grammarCache;
                    }
                }
            } else {
                eXISchema = this.m_schema;
                grammarCache = this.m_grammarCache.grammarOptions != s ? new GrammarCache(eXISchema, s) : this.m_grammarCache;
            }
            AlignmentType alignmentType = this.m_exiHeaderOptions.getAlignmentType();
            if (alignmentType == AlignmentType.bitPacked) {
                headerOptionsInputStream = headerOptionsInputStream2;
            }
            scanner = ScannerFactory.createScanner(alignmentType, this.m_inflatorBufSize, this.m_useThreadedInflater);
            scanner.setSchema(eXISchema, this.m_exiHeaderOptions.getDatatypeRepresentationMap(), this.m_exiHeaderOptions.getDatatypeRepresentationMapBindingsCount());
            scanner.setStringTable(Scanner.createStringTable(grammarCache));
            scanner.setValueMaxLength(this.m_exiHeaderOptions.getValueMaxLength());
            scanner.setPreserveLexicalValues(this.m_exiHeaderOptions.getPreserveLexicalValues());
            scanner.setValueMaxLength(this.m_exiHeaderOptions.getValueMaxLength());
            scanner.setBlockSize(this.m_exiHeaderOptions.getBlockSize());
            scanner.stringTable.setValuePartitionCapacity(this.m_exiHeaderOptions.getValuePartitionCapacity());
            bl = this.m_exiHeaderOptions.isFragment();
            scanner.setHeaderOptions(this.m_exiHeaderOptions);
        } else {
            scanner = this.m_scanner;
            scanner.setBlockSize(this.m_exiOptions.getBlockSize());
            scanner.stringTable.setValuePartitionCapacity(this.m_exiOptions.getValuePartitionCapacity());
            bl = this.m_exiOptions.isFragment();
            scanner.setHeaderOptions(null);
            grammarCache = this.m_grammarCache;
        }
        scanner.reset();
        scanner.setEnableBinaryData(this.m_binaryDataEnabled, this.m_initialBinaryDataBufferSize);
        if (headerOptionsInputStream != null) {
            ((BitPackedScanner)scanner).takeover(headerOptionsInputStream);
        } else {
            scanner.setInputStream(this.m_inputStream);
        }
        scanner.setGrammar(grammarCache.retrieveRootGrammar(bl, scanner.eventTypesWorkSpace), grammarCache.grammarOptions);
        scanner.prepare();
        return scanner;
    }
}

