/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.DatatypeID;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.IntegerValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;

public class IntegerDatatype
extends AbstractDatatype {
    private static final long serialVersionUID = -7131847569262739592L;
    private IntegerValue lastInteger;

    public IntegerDatatype(QNameContext schemaType) {
        super(BuiltInType.INTEGER, schemaType);
    }

    public DatatypeID getDatatypeID() {
        return DatatypeID.exi_integer;
    }

    protected boolean isValidString(String value) {
        this.lastInteger = IntegerValue.parse(value);
        return this.lastInteger != null;
    }

    public boolean isValid(Value value) {
        if (value instanceof IntegerValue) {
            this.lastInteger = (IntegerValue)value;
            return true;
        }
        return this.isValidString(value.toString());
    }

    public void writeValue(QNameContext qnContext, EncoderChannel valueChannel, StringEncoder stringEncoder) throws IOException {
        valueChannel.encodeIntegerValue(this.lastInteger);
    }

    public Value readValue(QNameContext qnContext, DecoderChannel valueChannel, StringDecoder stringDecoder) throws IOException {
        return valueChannel.decodeIntegerValue();
    }
}

