/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.scomp;

import org.openexi.scomp.Event;
import org.openexi.scomp.EventAT;
import org.openexi.scomp.EventATWildcardNS;
import org.openexi.scomp.ProtoGrammar;
import org.openexi.scomp.RightHandSide;
import org.openexi.scomp.Substance;

final class Production
extends Substance {
    private final Event m_event;
    private ProtoGrammar m_subsequentGrammar;
    private final int m_particleNumber;

    public Production(Event event, ProtoGrammar protoGrammar) {
        this(event, protoGrammar, -1);
    }

    public Production(Event event, ProtoGrammar protoGrammar, int n) {
        this.m_event = event;
        this.m_subsequentGrammar = protoGrammar;
        this.m_particleNumber = n;
    }

    public final boolean isProduction() {
        return true;
    }

    public final RightHandSide.RHSType getRHSType() {
        return RightHandSide.RHSType.PROD;
    }

    public Event getEvent() {
        return this.m_event;
    }

    public ProtoGrammar getSubsequentGrammar() {
        return this.m_subsequentGrammar;
    }

    void setSubsequentGrammar(ProtoGrammar protoGrammar) {
        this.m_subsequentGrammar = protoGrammar;
    }

    public int getParticleNumber() {
        return this.m_particleNumber;
    }

    public boolean equals(Object object) {
        if (object instanceof Production) {
            Production production = (Production)object;
            return this.m_event.equals(production.m_event) && this.m_subsequentGrammar == production.m_subsequentGrammar;
        }
        return false;
    }

    final short getPriority() {
        return this.m_event.getEventType();
    }

    static int compareAT(Production production, Production production2) {
        EventAT eventAT = (EventAT)production.m_event;
        EventAT eventAT2 = (EventAT)production2.m_event;
        int n = 0;
        if (production != production2) {
            n = eventAT.getLocalName().compareTo(eventAT2.getLocalName());
            if (n == 0) {
                n = eventAT.getUri().compareTo(eventAT2.getUri());
            }
            assert (n != 0);
        }
        return n;
    }

    static int compareATWildcardNS(Production production, Production production2) {
        EventATWildcardNS eventATWildcardNS = (EventATWildcardNS)production.m_event;
        EventATWildcardNS eventATWildcardNS2 = (EventATWildcardNS)production2.m_event;
        int n = eventATWildcardNS.getUri().compareTo(eventATWildcardNS2.getUri());
        assert (n != 0);
        return n;
    }

    static int compareSE(Production production, Production production2) {
        int n = production.m_particleNumber - production2.m_particleNumber;
        return n;
    }
}

