/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.OutputStream;
import org.openexi.proc.common.QName;
import org.openexi.proc.io.Scribble;
import org.openexi.proc.io.Scriber;
import org.openexi.proc.io.ValueScriberBase;
import org.openexi.schema.EXISchema;

final class BooleanValueScriber
extends ValueScriberBase {
    public static final BooleanValueScriber instance = new BooleanValueScriber();

    private BooleanValueScriber() {
        super(new QName("exi:boolean", "http://www.w3.org/2009/exi"));
    }

    public short getCodecID() {
        return 3;
    }

    public int getBuiltinRCS(int n, Scriber scriber) {
        return -4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean process(String string, int n, EXISchema eXISchema, Scribble scribble, Scriber scriber) {
        if (!this.trimWhitespaces(string)) {
            return false;
        }
        boolean bl = scribble.booleanValue2 = eXISchema.isPatternedBooleanSimpleType(n);
        int n2 = this.limitPosition - this.startPosition;
        if (n2 == 4 && string.charAt(this.startPosition) == 't' && string.charAt(this.startPosition + 1) == 'r' && string.charAt(this.startPosition + 2) == 'u' && string.charAt(this.startPosition + 3) == 'e') {
            if (bl) {
                scribble.intValue1 = 2;
                return true;
            } else {
                scribble.booleanValue1 = true;
            }
            return true;
        } else if (n2 == 5 && string.charAt(this.startPosition) == 'f' && string.charAt(this.startPosition + 1) == 'a' && string.charAt(this.startPosition + 2) == 'l' && string.charAt(this.startPosition + 3) == 's' && string.charAt(this.startPosition + 4) == 'e') {
            if (bl) {
                scribble.intValue1 = 0;
                return true;
            } else {
                scribble.booleanValue1 = false;
            }
            return true;
        } else {
            if (n2 != 1) return false;
            char c = string.charAt(this.startPosition);
            if (c == '1') {
                if (bl) {
                    scribble.intValue1 = 3;
                    return true;
                } else {
                    scribble.booleanValue1 = true;
                }
                return true;
            } else {
                if (c != '0') return false;
                if (bl) {
                    scribble.intValue1 = 1;
                    return true;
                } else {
                    scribble.booleanValue1 = false;
                }
            }
        }
        return true;
    }

    public void scribe(String string, Scribble scribble, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        if (scribble.booleanValue2) {
            scriber.writeNBitUnsigned(scribble.intValue1, 2, outputStream);
        } else {
            scriber.writeBoolean(scribble.booleanValue1, outputStream);
        }
    }

    public Object toValue(String string, Scribble scribble, Scriber scriber) {
        if (scribble.booleanValue2) {
            return new BooleanValue(true, true, (byte)scribble.intValue1);
        }
        return new BooleanValue(false, scribble.booleanValue1, -1);
    }

    public void doScribe(Object object, int n, int n2, int n3, OutputStream outputStream, Scriber scriber) throws IOException {
        BooleanValue booleanValue = (BooleanValue)object;
        if (booleanValue.distinguishLexicalValues) {
            scriber.writeNBitUnsigned(booleanValue.lexicalValueId, 2, outputStream);
        } else {
            scriber.writeBoolean(booleanValue.booleanValue, outputStream);
        }
    }

    private static class BooleanValue {
        boolean distinguishLexicalValues;
        boolean booleanValue;
        byte lexicalValueId;

        BooleanValue(boolean bl, boolean bl2, byte by) {
            this.distinguishLexicalValues = bl;
            this.booleanValue = bl2;
            this.lexicalValueId = by;
        }
    }
}

