/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi;

import com.siemens.ct.exi.exceptions.UnsupportedOption;
import java.util.HashSet;
import java.util.Set;

public class EncodingOptions {
    public static final String INCLUDE_COOKIE = "INCLUDE_COOKIE";
    public static final String INCLUDE_OPTIONS = "INCLUDE_OPTIONS";
    public static final String INCLUDE_SCHEMA_ID = "INCLUDE_SCHEMA_ID";
    public static final String RETAIN_ENTITY_REFERENCE = "KEEP_ENTITY_REFERENCES_UNRESOLVED";
    public static final String INCLUDE_XSI_SCHEMALOCATION = "INCLUDE_XSI_SCHEMALOCATION";
    public static final String INCLUDE_INSIGNIFICANT_XSI_NIL = "INCLUDE_INSIGNIFICANT_XSI_NIL";
    public static final String INCLUDE_PROFILE_VALUES = "INCLUDE_PROFILE_VALUES";
    public static final String CANONICAL_EXI = "http://www.w3.org/TR/exi-c14n";
    public static final String CANONICAL_EXI_WITHOUT_EXI_OPTIONS = "http://www.w3.org/TR/exi-c14n#WithoutEXIOptions";
    protected Set<String> options = new HashSet<String>();

    protected EncodingOptions() {
    }

    public static EncodingOptions createDefault() {
        EncodingOptions ho = new EncodingOptions();
        return ho;
    }

    public void setOption(String key) throws UnsupportedOption {
        if (key.equals(INCLUDE_COOKIE)) {
            this.options.add(key);
        } else if (key.equals(INCLUDE_OPTIONS)) {
            this.options.add(key);
        } else if (key.equals(INCLUDE_SCHEMA_ID)) {
            this.options.add(key);
        } else if (key.equals(RETAIN_ENTITY_REFERENCE)) {
            this.options.add(key);
        } else if (key.equals(INCLUDE_XSI_SCHEMALOCATION)) {
            this.options.add(key);
        } else if (key.equals(INCLUDE_INSIGNIFICANT_XSI_NIL)) {
            this.options.add(key);
        } else if (key.equals(INCLUDE_PROFILE_VALUES)) {
            this.options.add(key);
        } else if (key.equals(CANONICAL_EXI)) {
            this.options.remove(CANONICAL_EXI_WITHOUT_EXI_OPTIONS);
            this.options.add(key);
        } else if (key.equals(CANONICAL_EXI_WITHOUT_EXI_OPTIONS)) {
            this.options.remove(CANONICAL_EXI);
            this.options.add(key);
        } else {
            throw new UnsupportedOption("EncodingOption '" + key + "' is unknown!");
        }
    }

    public boolean unsetOption(String key) {
        return this.options.remove(key);
    }

    public boolean isOptionEnabled(String key) {
        return this.options.contains(key);
    }

    public boolean equals(Object o) {
        if (o instanceof EncodingOptions) {
            EncodingOptions other = (EncodingOptions)o;
            return this.options.equals(other.options);
        }
        return false;
    }

    public int hashCode() {
        return this.options.hashCode();
    }

    public String toString() {
        return this.options.toString();
    }
}

